/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.mandas.docker.client.ProgressHandler;
import org.mandas.docker.client.exceptions.DockerException;
import org.mandas.docker.client.messages.ProgressMessage;

public class AnsiProgressHandler
implements ProgressHandler {
    private static final char ESC_CODE = '\u001b';
    private final PrintStream out;
    private final Map<String, Integer> idsToLines;

    public AnsiProgressHandler() {
        this(System.out);
    }

    public AnsiProgressHandler(PrintStream out) {
        this.out = out;
        this.idsToLines = new HashMap<String, Integer>();
    }

    @Override
    public void progress(ProgressMessage message) throws DockerException {
        if (message.error() != null) {
            throw new DockerException(message.error());
        }
        if (message.progressDetail() != null) {
            this.printProgress(message);
            return;
        }
        String value = message.stream();
        value = value != null ? value.replaceFirst("\n$", "") : message.status();
        if (value == null) {
            value = message.toString();
        }
        this.out.println(value);
    }

    private void printProgress(ProgressMessage message) {
        String progress;
        String id = message.id();
        Integer line = this.idsToLines.get(id);
        int diff = 0;
        if (line == null) {
            line = this.idsToLines.size();
            this.idsToLines.put(id, line);
        } else {
            diff = this.idsToLines.size() - line;
        }
        if (diff > 0) {
            this.out.printf("%c[%dA", Character.valueOf('\u001b'), diff);
            this.out.printf("%c[2K\r", Character.valueOf('\u001b'));
        }
        if ((progress = message.progress()) == null) {
            progress = "";
        }
        this.out.printf("%s: %s %s%n", id, message.status(), progress);
        if (diff > 0) {
            this.out.printf("%c[%dB", Character.valueOf('\u001b'), diff - 1);
        }
    }
}

