/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.common.utilities.exception;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tml.common.utilities.UtilitiesResources;
import org.eclipse.tml.common.utilities.exception.ExceptionMessage;
import org.eclipse.tml.common.utilities.exception.ExceptionStatus;

public abstract class AbstractExceptionStatus
extends ExceptionStatus {
    public static final int CODE_ERROR_USER = 100;

    public AbstractExceptionStatus(IStatus status) {
        super(status);
    }

    public AbstractExceptionStatus(int severity, String pluginId, int code, String message, Throwable exception) {
        super(severity, pluginId, code, message, exception);
    }

    public AbstractExceptionStatus(int code, String pluginId) {
        super(code, pluginId, null, null);
    }

    public AbstractExceptionStatus(int code, String pluginId, Throwable exception) {
        super(code, pluginId, exception);
    }

    public AbstractExceptionStatus(int code, String pluginId, Object[] args, Throwable exception) {
        super(code, pluginId, args, exception);
    }

    public abstract ExceptionMessage getEmulatorMessage(int var1);

    public ExceptionMessage getDefaultEmulatorMessage(int code) {
        ExceptionMessage message = null;
        switch (code) {
            case 100: {
                message = new ExceptionMessage(4, UtilitiesResources.TML_Error);
                break;
            }
            default: {
                message = new ExceptionMessage(4, UtilitiesResources.TML_Error);
            }
        }
        return message;
    }

    public void createEmulatorStatus(int code, String pluginId, Object[] args, Throwable exception) {
        ExceptionMessage message = null;
        message = code > 100 ? this.getEmulatorMessage(code) : this.getDefaultEmulatorMessage(code);
        String messageText = message.getMessage();
        if (args != null) {
            messageText = NLS.bind((String)message.getMessage(), (Object[])args);
        }
        this.setStatus((IStatus)new Status(message.getSeverity(), pluginId, code, messageText, exception));
    }
}

