/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.factory.ServiceFactory;
import org.eclipse.tml.framework.device.internal.model.MobileDeviceType;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IDeviceTypeRegistry;
import org.eclipse.tml.framework.device.model.IService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTypeRegistry
implements IDeviceTypeRegistry {
    private static final String XML_ELEMENT_DEVICE_TYPE = "deviceType";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_LABEL = "label";
    private static final String XML_ATTRIBUTE_IS_ABSTRACT = "isAbstract";
    private static final String XML_ATTRIBUTE_SUPERCLASS = "superClass";
    private static final String XML_ATTRIBUTE_PROPERTY = "property";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static DeviceTypeRegistry _instance;
    private Map<String, IDeviceType> deviceTypes = new HashMap<String, IDeviceType>();

    private DeviceTypeRegistry() {
    }

    public static DeviceTypeRegistry getInstance() {
        if (_instance == null) {
            _instance = new DeviceTypeRegistry();
        }
        return _instance;
    }

    @Override
    public IDeviceType getDeviceTypeById(String id) {
        this.loadDeviceTypesExtensions();
        return this.deviceTypes.get(id);
    }

    @Override
    public Collection<IDeviceType> getDeviceTypes() {
        this.loadDeviceTypesExtensions();
        return this.deviceTypes.values();
    }

    public Set<String> getDeviceTypeIds() {
        this.loadDeviceTypesExtensions();
        return this.deviceTypes.keySet();
    }

    @Override
    public ImageDescriptor getImage() {
        return DevicePlugin.getDefault().getImageDescriptor("ICON_MOVING");
    }

    private synchronized Map<String, IDeviceType> loadDeviceTypesExtensions() {
        IExtension[] extensions;
        IExtensionPoint extensionPoint;
        if (this.deviceTypes.isEmpty() && (extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tml.deviceTypes")) != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int k = 0;
                while (k < elements.length) {
                    IConfigurationElement element = elements[k];
                    if (element.getName().equals(XML_ELEMENT_DEVICE_TYPE)) {
                        IDeviceType deviceType = this.loadDeviceType(element);
                        deviceType.setBundleName(element.getContributor().getName());
                        this.deviceTypes.put(deviceType.getId(), deviceType);
                    }
                    ++k;
                }
                ++i;
            }
            for (IDeviceType deviceType : this.deviceTypes.values()) {
                deviceType.setServices(this.loadServices(deviceType));
                deviceType.getProperties().putAll((Map<?, ?>)this.loadSuperClassProperties(deviceType));
            }
        }
        return this.deviceTypes;
    }

    private Properties loadSuperClassProperties(IDeviceType deviceType) {
        Properties properties = new Properties();
        String superClassDeviceTypeId = deviceType.getSuperClass();
        if (superClassDeviceTypeId != null && this.deviceTypes.containsKey(superClassDeviceTypeId)) {
            IDeviceType superClassDeviceType = this.deviceTypes.get(superClassDeviceTypeId);
            properties.putAll((Map<?, ?>)this.loadSuperClassProperties(superClassDeviceType));
            Properties superClassDeviceTypeProperties = superClassDeviceType.getProperties();
            Properties currentDeviceTypeProperties = deviceType.getProperties();
            for (String string : superClassDeviceTypeProperties.keySet()) {
                if (currentDeviceTypeProperties.containsKey(string)) continue;
                properties.put(string, superClassDeviceTypeProperties.get(string));
            }
        }
        return properties;
    }

    private IDeviceType loadDeviceType(IConfigurationElement element) {
        String superClass;
        String id = element.getAttribute(XML_ATTRIBUTE_ID);
        String label = element.getAttribute(XML_ATTRIBUTE_LABEL);
        MobileDeviceType deviceType = new MobileDeviceType(id, label);
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement childElement = children[i];
            if (childElement.getName().equals(XML_ATTRIBUTE_PROPERTY)) {
                String name = childElement.getAttribute(XML_ATTRIBUTE_NAME);
                String value = childElement.getAttribute(XML_ATTRIBUTE_VALUE);
                deviceType.addProperty(name, value);
            }
            ++i;
        }
        String isAbstract = element.getAttribute(XML_ATTRIBUTE_IS_ABSTRACT);
        if (isAbstract != null && Boolean.valueOf(isAbstract).booleanValue()) {
            deviceType.setAbstract(true);
        }
        if ((superClass = element.getAttribute(XML_ATTRIBUTE_SUPERCLASS)) != null) {
            deviceType.setSuperClass(superClass);
        }
        return deviceType;
    }

    private List<IService> loadServices(IDeviceType deviceType) {
        ArrayList<IService> services = new ArrayList<IService>();
        services.addAll(this.loadServices(deviceType.getId()));
        String superClassDeviceTypeId = deviceType.getSuperClass();
        if (superClassDeviceTypeId != null && this.deviceTypes.containsKey(superClassDeviceTypeId)) {
            List<IService> superServices = this.loadServices(this.deviceTypes.get(superClassDeviceTypeId));
            for (IService service : superServices) {
                if (this.serviceExists(services, service.getId())) continue;
                services.add(service);
            }
        }
        return services;
    }

    private boolean serviceExists(List<IService> services, String serviceId) {
        if (services != null) {
            for (IService service : services) {
                if (!service.getId().equals(serviceId)) continue;
                return true;
            }
        }
        return false;
    }

    private List<IService> loadServices(String deviceTypeId) {
        ArrayList<IService> services = new ArrayList<IService>();
        Collection servs = PluginUtils.getInstalledExtensions((String)"org.eclipse.tml.serviceDefinition");
        for (IExtension service : servs) {
            if (!service.getUniqueIdentifier().equals(deviceTypeId)) continue;
            try {
                services.add(ServiceFactory.createService(service));
            }
            catch (TmLException t) {
                t.printStackTrace();
            }
        }
        return services;
    }
}

