/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.utilities.logger;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tml.utilities.logger.ILogger;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public final class SimpleLogger
implements ILogger {
    private static SimpleLogger logLogger;
    private static final Map<String, String> levelsMap;

    static {
        levelsMap = new HashMap<String, String>();
        levelsMap.put("DEBUG", "[DEBUG]");
        levelsMap.put("INFO", "[INFO]");
        levelsMap.put("WARN", "[WARN]");
        levelsMap.put("ERROR", "[ERROR]");
        levelsMap.put("FATAL", "[FATAL]");
        levelsMap.put("ALL", "[LOG]");
    }

    private SimpleLogger() {
        MessageConsole console = new MessageConsole("System Output", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
        MessageConsoleStream stream = console.newMessageStream();
        System.setOut(new PrintStream((OutputStream)stream));
        System.setErr(new PrintStream((OutputStream)stream));
    }

    private void configureLogView(int logView) {
        switch (logView) {
            case 1: {
                this.setAppenderConsole();
                break;
            }
            default: {
                String errMsg = Integer.toString(logView);
                throw new IllegalArgumentException(errMsg);
            }
        }
    }

    public void configureLogger(Object classType) {
        this.configureLogView(1);
    }

    public void debug(Object message) {
        System.out.println("[DEBUG]" + message);
    }

    public void error(Object message) {
        System.out.println("[ERROR]" + message);
    }

    public void error(Object message, Object throwable) {
        System.out.println("[ERROR]" + message + "-" + ((Throwable)throwable).getMessage());
    }

    public void fatal(Object message) {
        System.out.println("[FATAL]" + message);
    }

    public Object getCurrentLevel() {
        return "[LOG]";
    }

    public static SimpleLogger getInstance() {
        if (logLogger == null) {
            logLogger = new SimpleLogger();
        }
        return logLogger;
    }

    public void info(Object message) {
        System.out.println("[INFO]" + message);
    }

    public void log(Object priority, Object message, Object throwable) {
        System.out.println(String.valueOf(levelsMap.get(priority)) + message + "-" + ((Throwable)throwable).getMessage());
    }

    public void log(Object throwable) {
        System.out.println("[LOG]" + ((Throwable)throwable).getMessage());
    }

    public void log(Object priority, Object message) {
        System.out.println(String.valueOf(levelsMap.get(priority)) + message);
    }

    private void setAppenderConsole() {
    }

    private void setAppenderFile() {
    }

    private void setAppenderHTML() {
    }

    public void setLevel(Object level) {
    }

    public void setLogToConsole() {
    }

    public void setLogToFile(String filename) {
    }

    public void setLogToFile(String filename, String threshold) {
    }

    public void setLogToHTMLFile(String htmlFilename) {
    }

    public void warn(Object message) {
        System.out.println("[WARN]" + message);
    }
}

