/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.network.telnet;

import java.io.IOException;
import org.eclipse.tml.common.utilities.logger.ILogger;
import org.eclipse.tml.linuxtools.LinuxToolsPlugin;
import org.eclipse.tml.linuxtools.network.IConnectionProvider;
import org.eclipse.tml.linuxtools.network.IConstants;
import org.eclipse.tml.linuxtools.network.telnet.TelnetWrapper;
import org.eclipse.tml.linuxtools.tools.AbstractNotifier;

public class TelnetProvider
extends AbstractNotifier
implements IConnectionProvider {
    private final String CMD_FETCH_PREFIX = "cat ";
    private TelnetWrapper connectionWrapper = new TelnetWrapper();
    private ILogger logger = LinuxToolsPlugin.getLogger();
    private Thread connectThread = null;
    private Thread loginThread = null;
    private Thread sendCommandThread = null;

    public void connect(String host, int port) throws IOException {
        final String hostAux = host;
        final int portAux = port;
        final TelnetWrapper connectionWrapperAux = this.connectionWrapper;
        this.connectThread = new Thread(){

            public void run() {
                try {
                    IConstants.OperationCode opCode = connectionWrapperAux.connect(hostAux, portAux);
                    TelnetProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_CONNECT_FINISHED, opCode);
                }
                catch (IOException iOException) {
                    TelnetProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_CONNECT_ERROR, IConstants.OperationCode.UNEXPECTED_RESULT);
                }
            }
        };
        this.connectThread.start();
    }

    public void disconnect() throws IOException {
        if (this.connectThread != null && this.connectThread.isAlive()) {
            this.connectThread.interrupt();
        }
        if (this.loginThread != null && this.loginThread.isAlive()) {
            this.loginThread.interrupt();
        }
        if (this.sendCommandThread != null && this.sendCommandThread.isAlive()) {
            this.sendCommandThread.interrupt();
        }
        this.connectionWrapper.disconnect();
        this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_DISCONNECT_FINISHED, IConstants.OperationCode.SUCCESS);
    }

    public void login(String user, String password) throws IOException {
        final String userAux = user;
        final String passwordAux = password;
        final TelnetWrapper connectionWrapperAux = this.connectionWrapper;
        this.loginThread = new Thread(){

            public void run() {
                try {
                    IConstants.OperationCode opCode = connectionWrapperAux.login(userAux, passwordAux);
                    TelnetProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_LOGIN_FINISHED, opCode);
                }
                catch (IOException iOException) {
                    TelnetProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_LOGIN_ERROR, IConstants.OperationCode.UNEXPECTED_RESULT);
                }
            }
        };
        this.loginThread.start();
    }

    public StringBuffer getLastResponde() {
        return this.connectionWrapper.getLastResponde();
    }

    public void sendCommand(IConstants.CommandCode cmd, String cmdStr) throws IOException {
        if (IConstants.CommandCode.FETCH_FILE != cmd) {
            return;
        }
        final String commandAux = "cat " + cmdStr + "\n";
        final TelnetWrapper connectionWrapperAux = this.connectionWrapper;
        this.sendCommandThread = new Thread(){

            public void run() {
                try {
                    connectionWrapperAux.setResponseLength(2048);
                    if (connectionWrapperAux.sendCommand(commandAux) != null) {
                        StringBuffer result = connectionWrapperAux.getLastResponde();
                        TelnetProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_SENDCOMMAND_FINISHED, result);
                    } else {
                        TelnetProvider.this.logger.info((Object)"##### NULL ######");
                    }
                }
                catch (IOException iOException) {
                    TelnetProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_SENDCOMMAND_ERROR, null);
                }
            }
        };
        this.sendCommandThread.start();
    }

    public void sendData(String out) {
        this.connectionWrapper.sendData(out);
    }

    public void setResponseLength(int maxLength) {
        this.connectionWrapper.setResponseLength(maxLength);
    }
}

