/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.network.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import org.eclipse.tml.linuxtools.network.IConstants;

public class TelnetWrapper {
    public final String PROMPT = "[###]:";
    private final String[] LOGIN_TOKENS = new String[]{"login:", "Login:"};
    private final String[] PASSWORD_TOKENS = new String[]{"password:", "Password:"};
    private final String[] LOGIN_FAILED_TOKENS = new String[]{"Login incorrect", "Access denied"};
    private final String CHANGE_PROMPT = "export PS1='[\\043\\043\\043]:'\n";
    private TelnetClient client = null;
    private InputStream inStream = null;
    private PrintStream outStream = null;
    private StringBuffer lastResponse = null;
    private int maxResponseDataLength = 1024;
    private int MAX_LENGTH_PASSWORD_TOKENS = 32;
    private int MAX_LENGTH_LOGIN_FAILED = 32;
    private int MAX_LENGTH_LOGIN_INITSCREEN = 2048;
    private int MAX_LENGTH_CHANGE_PROMPT = 128;

    public TelnetWrapper() {
        if (this.client == null) {
            this.client = new TelnetClient();
            try {
                this.client.addOptionHandler((TelnetOptionHandler)new TerminalTypeOptionHandler("VT100", false, false, true, false));
                this.client.addOptionHandler((TelnetOptionHandler)new SuppressGAOptionHandler(true, true, true, true));
                this.client.addOptionHandler((TelnetOptionHandler)new EchoOptionHandler(false, false, false, false));
            }
            catch (InvalidTelnetOptionException invalidTelnetOptionException) {}
        }
    }

    public IConstants.OperationCode connect(String host, int port) throws IOException {
        this.client.connect(host, port);
        this.inStream = this.client.getInputStream();
        this.outStream = new PrintStream(this.client.getOutputStream());
        IConstants.OperationCode retVal = this.readUntilTokens(this.LOGIN_TOKENS) == null ? IConstants.OperationCode.SUCCESS : IConstants.OperationCode.LOGIN_REQUIRED;
        return retVal;
    }

    public void disconnect() throws IOException {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public IConstants.OperationCode login(String user, String password) throws IOException {
        IConstants.OperationCode retVal = IConstants.OperationCode.UNEXPECTED_RESULT;
        this.sendData(String.valueOf(user) + "\n");
        this.setResponseLength(this.MAX_LENGTH_PASSWORD_TOKENS);
        if (this.readUntilTokens(this.PASSWORD_TOKENS) != null) {
            this.sendData(String.valueOf(password) + "\n");
            this.setResponseLength(this.MAX_LENGTH_LOGIN_FAILED);
            if (this.readUntilTokens(this.LOGIN_FAILED_TOKENS) != null) {
                retVal = this.readUntilTokens(this.LOGIN_TOKENS) != null ? IConstants.OperationCode.LOGIN_FAILED : IConstants.OperationCode.UNEXPECTED_RESULT;
                return retVal;
            }
            this.setResponseLength(this.MAX_LENGTH_LOGIN_INITSCREEN);
            int toBeSkipped = this.inStream.available();
            this.inStream.skip(toBeSkipped);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        this.setResponseLength(this.MAX_LENGTH_CHANGE_PROMPT);
        this.sendData("export PS1='[\\043\\043\\043]:'\n");
        if (this.readUntilTokens("[###]:") != null) {
            retVal = IConstants.OperationCode.SUCCESS;
        }
        return retVal;
    }

    public StringBuffer getLastResponde() {
        return this.lastResponse;
    }

    public String sendCommand(String command) throws IOException {
        this.sendData(command);
        return this.readUntilTokens("[###]:");
    }

    public void sendData(String out) {
        if (this.outStream != null) {
            this.outStream.print(out);
            this.outStream.flush();
        }
    }

    public void setResponseLength(int maxLength) {
        this.maxResponseDataLength = maxLength;
    }

    private String readUntilTokens(String token) throws IOException {
        return this.readUntilTokens(new String[]{token});
    }

    private String readUntilTokens(String[] tokenArray) throws IOException {
        String matchedString = null;
        boolean tokenFound = false;
        StringBuffer readData = new StringBuffer();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < tokenArray.length) {
            hashMap.put(tokenArray[i], new Integer(0));
            ++i;
        }
        i = 0;
        while (i < this.maxResponseDataLength) {
            int aux = this.inStream.read();
            char ch = '\u0000';
            if (aux != 0 && aux != 1) {
                ch = (char)aux;
                readData.append(ch);
                int j = 0;
                while (j < tokenArray.length) {
                    String token = tokenArray[j];
                    Integer rank = (Integer)hashMap.get(token);
                    if (ch == token.charAt(rank)) {
                        if ((rank = Integer.valueOf(rank + 1)) >= token.length()) {
                            readData.setLength(readData.length() - token.length());
                            matchedString = token;
                            tokenFound = true;
                        }
                    } else {
                        rank = 0;
                    }
                    hashMap.put(token, rank);
                    ++j;
                }
                if (tokenFound) break;
            }
            ++i;
        }
        this.lastResponse = readData;
        return matchedString;
    }
}

