/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.tools.cpuload;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tml.linuxtools.LinuxToolsPlugin;
import org.eclipse.tml.linuxtools.network.IConstants;
import org.eclipse.tml.linuxtools.tools.IListener;
import org.eclipse.tml.linuxtools.tools.INotifier;
import org.eclipse.tml.linuxtools.tools.ITool;
import org.eclipse.tml.linuxtools.tools.cpuload.CpuLoadTool;
import org.eclipse.tml.linuxtools.tools.cpuload.CpuLoadViewContentProvider;
import org.eclipse.tml.linuxtools.tools.cpuload.CpuLoadViewLabelProvider;
import org.eclipse.tml.linuxtools.tools.cpuload.Messages;
import org.eclipse.tml.linuxtools.tools.cpuload.ViewActionOptions;
import org.eclipse.tml.linuxtools.ui.DialogLogin;
import org.eclipse.tml.linuxtools.ui.IToolViewPart;
import org.eclipse.tml.linuxtools.ui.ViewActionConnect;
import org.eclipse.tml.linuxtools.ui.ViewActionDisconnect;
import org.eclipse.tml.linuxtools.ui.ViewActionPause;
import org.eclipse.tml.linuxtools.ui.ViewActionRun;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class CpuLoadView
extends ViewPart
implements IToolViewPart,
IListener {
    private final String COL_LABEL_CPU = Messages.CpuLoadView_Col_Label_Cpu;
    private final String COL_LABEL_USER_MODE = Messages.CpuLoadView_Col_Label_User_Mode;
    private final String COL_LABEL_NICE = Messages.CpuLoadView_Col_Label_Nice;
    private final String COL_LABEL_SYSTEM = Messages.CpuLoadView_Col_Label_System;
    private final String COL_LABEL_IDLE = Messages.CpuLoadView_Col_Label_Idle;
    private final String COL_LABEL_WAIT = Messages.CpuLoadView_Col_Label_Wait;
    private final String COL_LABEL_HIRQ = Messages.CpuLoadView_Col_label_HIrq;
    private final String COL_LABEL_SIRQ = Messages.CpuLoadView_Col_Label_SIrq;
    private ITool tool = null;
    private TableViewer viewer;
    private Action runAction;
    private Action pauseAction;
    private Action optionsAction;
    private Action disconnectAction;
    private Action connectAction;
    private boolean receivedData = false;
    private IPartListener partActivationListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            ITool tool;
            if (CpuLoadView.this.getSite().getPart() == part && (tool = CpuLoadView.this.getTool()) != null) {
                tool.disconnect();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 66304);
        this.viewer.setContentProvider((IContentProvider)new CpuLoadViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CpuLoadViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new CpuSorter());
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        new TableColumn(table, 16384).setText(this.COL_LABEL_CPU);
        new TableColumn(table, 16384).setText(this.COL_LABEL_USER_MODE);
        new TableColumn(table, 16384).setText(this.COL_LABEL_NICE);
        new TableColumn(table, 16384).setText(this.COL_LABEL_SYSTEM);
        new TableColumn(table, 16384).setText(this.COL_LABEL_IDLE);
        new TableColumn(table, 16384).setText(this.COL_LABEL_WAIT);
        new TableColumn(table, 16384).setText(this.COL_LABEL_HIRQ);
        new TableColumn(table, 16384).setText(this.COL_LABEL_SIRQ);
        this.refresh();
        this.resize();
        this.makeActions();
        this.addToToolBar();
        this.getViewSite().getWorkbenchWindow().getPartService().addPartListener(this.partActivationListener);
        this.setConnectEnabled(true);
        this.setRunPauseEnabled(false, false);
    }

    private void addToToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarMmanager = actionBars.getToolBarManager();
        toolBarMmanager.add((IAction)this.runAction);
        toolBarMmanager.add((IAction)this.pauseAction);
        toolBarMmanager.add((IAction)this.optionsAction);
        toolBarMmanager.add((IAction)this.disconnectAction);
        toolBarMmanager.add((IAction)this.connectAction);
    }

    private void makeActions() {
        this.runAction = new Action(){

            public void run() {
                ViewActionRun delegate = new ViewActionRun();
                delegate.init((IViewPart)CpuLoadView.this);
                delegate.run((IAction)this);
                CpuLoadView.this.setRunPauseEnabled(false, true);
            }
        };
        this.runAction.setToolTipText(Messages.CpuLoadView_Action_Run);
        this.runAction.setImageDescriptor(LinuxToolsPlugin.getDefault().getImageDescriptor("run.gif"));
        this.pauseAction = new Action(){

            public void run() {
                ViewActionPause delegate = new ViewActionPause();
                delegate.init((IViewPart)CpuLoadView.this);
                delegate.run((IAction)this);
                CpuLoadView.this.setRunPauseEnabled(true, false);
            }
        };
        this.pauseAction.setToolTipText(Messages.CpuLoadView_Action_Pause);
        this.pauseAction.setImageDescriptor(LinuxToolsPlugin.getDefault().getImageDescriptor("pause.gif"));
        this.optionsAction = new Action(){

            public void run() {
                ViewActionOptions delegate = new ViewActionOptions();
                delegate.init((IViewPart)CpuLoadView.this);
                delegate.run((IAction)this);
            }
        };
        this.optionsAction.setToolTipText(Messages.CpuLoadView_Action_Options);
        this.optionsAction.setImageDescriptor(LinuxToolsPlugin.getDefault().getImageDescriptor("options.gif"));
        this.disconnectAction = new Action(){

            public void run() {
                ViewActionDisconnect delegate = new ViewActionDisconnect();
                delegate.init((IViewPart)CpuLoadView.this);
                delegate.run((IAction)this);
            }
        };
        this.disconnectAction.setToolTipText(Messages.CpuLoadView_Action_Disconnect);
        this.disconnectAction.setImageDescriptor(LinuxToolsPlugin.getDefault().getImageDescriptor("disconnect.gif"));
        this.connectAction = new Action(){

            public void run() {
                ViewActionConnect delegate = new ViewActionConnect();
                delegate.init((IViewPart)CpuLoadView.this);
                delegate.run((IAction)this);
            }
        };
        this.connectAction.setToolTipText(Messages.CpuLoadView_Action_Connect);
        this.connectAction.setImageDescriptor(LinuxToolsPlugin.getDefault().getImageDescriptor("connect.gif"));
    }

    private void setConnectEnabled(boolean bool) {
        this.connectAction.setEnabled(bool);
        this.disconnectAction.setEnabled(!bool);
    }

    private void setRunPauseEnabled(boolean runBool, boolean pauseBool) {
        this.runAction.setEnabled(runBool);
        this.pauseAction.setEnabled(pauseBool);
    }

    public ITool getTool() {
        if (this.tool == null) {
            this.tool = new CpuLoadTool();
            this.tool.addListener((IListener)this);
        }
        return this.tool;
    }

    public void notify(INotifier notifier, IConstants.EventCode event, Object result) {
        if (notifier == this.tool) {
            final Object finalResult = result;
            final IConstants.EventCode finalEvent = event;
            final CpuLoadView finalView = this;
            final ITool finalTool = this.tool;
            this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    switch (finalEvent) {
                        case EVT_TOOL_REFRESH_VIEW: {
                            CpuLoadView.this.viewer.setInput(finalResult);
                            CpuLoadView.this.refresh();
                            if (CpuLoadView.this.receivedData) break;
                            CpuLoadView.this.resize();
                            CpuLoadView.this.receivedData = true;
                            break;
                        }
                        case EVT_TOOL_CONNECT_FINISHED: 
                        case EVT_TOOL_LOGIN_FINISHED: {
                            switch ((IConstants.OperationCode)finalResult) {
                                case SUCCESS: {
                                    CpuLoadView.this.setConnectEnabled(false);
                                    CpuLoadView.this.setRunPauseEnabled(false, true);
                                    break;
                                }
                                case LOGIN_REQUIRED: {
                                    DialogLogin dialog = new DialogLogin(finalView.getViewSite().getShell(), finalTool, false);
                                    dialog.open();
                                    break;
                                }
                                case LOGIN_FAILED: {
                                    DialogLogin dialog = new DialogLogin(finalView.getViewSite().getShell(), finalTool, true);
                                    dialog.open();
                                }
                            }
                            break;
                        }
                        case EVT_TOOL_DISCONNECT_FINISHED: {
                            CpuLoadView.this.setConnectEnabled(true);
                            CpuLoadView.this.setRunPauseEnabled(false, false);
                        }
                    }
                }
            });
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void resize() {
        Table table = this.viewer.getTable();
        int i = 0;
        int n = table.getColumnCount();
        while (i < n) {
            table.getColumn(i).pack();
            ++i;
        }
    }

    public void setData(Object data) {
        this.viewer.setInput(data);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private class CpuSorter
    extends ViewerSorter {
        private CpuSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            try {
                int a = new Integer(((String[])e1)[0]);
                int b = new Integer(((String[])e2)[0]);
                if (a > b) {
                    result = 1;
                } else if (a < b) {
                    result = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return result;
        }
    }
}

