/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.views;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.MetamodelResourceFactory;
import org.eclipse.stem.model.ui.wizards.ModelGeneratorWizard;
import org.eclipse.stem.model.ui.wizards.NewModelWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class ModelPackageView
extends ViewPart {
    Package basePackage;
    TreeViewer viewer;
    Button addModelButton;
    Button editModelButton;
    Button removeModelButton;
    Button generateButton;

    private void loadModel() {
        URI modelUri = URI.createURI((String)"platform:/plugin/org.eclipse.stem.model.transform/data/polioopvipv.metamodel");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("genmodel", new MetamodelResourceFactory());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new MetamodelResourceFactory());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("metamodel", new MetamodelResourceFactory());
        Resource modelResource = resourceSet.getResource(modelUri, true);
        this.basePackage = (Package)modelResource.getContents().get(0);
        EcoreUtil.resolveAll((EObject)this.basePackage);
    }

    public void createPartControl(Composite parent) {
        this.loadModel();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.viewer = new TreeViewer(container, 0x10000800);
        GridData viewGridData = new GridData(1808);
        viewGridData.horizontalSpan = 3;
        this.viewer.getTree().setLayoutData((Object)viewGridData);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Package) {
                    return ((Package)parentElement).getModels().toArray();
                }
                if (parentElement instanceof Model) {
                    return ((Model)parentElement).getCompartments().getCompartments().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return element instanceof Package || element instanceof Model;
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setInput((Object)this.basePackage);
        this.addModelButton = new Button(container, 8);
        this.addModelButton.setText("Add Model");
        this.addModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewModelWizard wizard = new NewModelWizard(MetamodelFactory.eINSTANCE.createModel());
                WizardDialog wizardDialog = new WizardDialog(ModelPackageView.this.getSite().getShell(), (IWizard)wizard);
                if (wizardDialog.open() == 0) {
                    ModelPackageView.this.basePackage.getModels().add((Object)wizard.getModel());
                    ModelPackageView.this.viewer.refresh();
                }
            }
        });
        this.editModelButton = new Button(container, 8);
        this.editModelButton.setText("Edit Model");
        this.editModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
            }
        });
        this.removeModelButton = new Button(container, 8);
        this.removeModelButton.setText("Remove Model");
        this.removeModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
            }
        });
        this.generateButton = new Button(container, 8);
        this.generateButton.setText("Generate");
        this.generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelGeneratorWizard wizard = new ModelGeneratorWizard(ModelPackageView.this.basePackage);
                WizardDialog wizardDialog = new WizardDialog(ModelPackageView.this.getSite().getShell(), (IWizard)wizard);
                wizardDialog.open();
            }
        });
    }

    public void setFocus() {
    }
}

