/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.digester3.Rule;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.model.property.accessor.FieldAccessor;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.xml.sax.Attributes;

public final class PublicFieldPropertiesRule
extends Rule {
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        ComponentDescription componentDescription = (ComponentDescription)this.getDigester().peek();
        Class<?> componentClass = componentDescription.getComponentClass();
        Field[] fieldArray = componentClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
                PublicFieldPropertiesRule.addSingleProperty(componentDescription, field);
            }
            ++n2;
        }
    }

    private static void addSingleProperty(ComponentDescription componentDescription, Field field) throws Exception {
        String title;
        String id = title = field.getName();
        Class<?> type = field.getType();
        PropertyEditor editor = DescriptionPropertiesHelper.getEditorForType(type);
        ExpressionConverter converter = DescriptionPropertiesHelper.getConverterForType(type);
        FieldAccessor accessor = new FieldAccessor(field);
        GenericPropertyDescription propertyDescription = new GenericPropertyDescription(id, title, type);
        propertyDescription.addAccessor(accessor);
        propertyDescription.setConverter(converter);
        propertyDescription.setEditor(editor);
        componentDescription.addProperty(propertyDescription);
    }
}

