/* LocaleInformation_de.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_de extends ListResourceBundle
{
  private static final String collation_rules = 
    "<0<1<2<3<4<5<6<7<8<9<A,a<b,B<c,C<d,D<e,E<f,F<g,G<h,H<i,I<j,J<k,K" +
    "<l,L<m,M<n,N<o,O<p,P<q,Q<r,R<s,S<t,T<u,U<v,V<w,W<x,X<y,Y<z,Z" + 
    "&ae,\u00e4&Ae,\u00c4&oe,\u00f6&Oe,\u00d6&ue,\u00fc&Ue,\u00dc&ss,\u00df";
  
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|BOL|KHO|ZMP|AUP|XAF|MTP|ZMK|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|LSL|BGO|BGN|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|ILL|VEB|LRD|ALV|HRK|HRD|ALL|JEP|ALK|VDP|VDN|MKD|VDD|TPP|XPF|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|ZAP|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UAK|QAR|UAH|CNY|MZM|UYU|SML|CNP|PGK|GNF|OMR|XFU|ZRZ|BTR|MAF|MAD|XFO|BTN|ZRN|MYR|AZM|GMP|KMF|SLL|GMD|BSP|CMF|MXV|MXP|BSD|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|JPY|MVR|MVP|XCD|SIT|YUR|AWG|YUO|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBA|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Jordanischer Dinar|Mvdol|Gold|F\u00e4r\u00f6er Inseln Krone|Libanesisches Pfund|Euro|Dong|Tansania Schilling|Bolivianischer Peso|Riel|Boliviano (1863-1962)|Riel (alt)|Sambisches Pfund|Australisches Pfund|CFA Franc (\u00c4quatorial)|Maltesisches Pfund|Kwacha|Ghana Pfund|Boliviano|Ghana Cedi (alt)|Maltesische Lira|Australischer Dollar|US Dollar (Gleicher Tag)|Italienische Lire|US Dollar (N\u00e4chster Tag)|Cedi|Singapur Dollar|Balboa|Kip|Som|Schweizer Franken|\u00d6sterreichischer Schilling|US Dollar|\u00c4thiopischer Dollar|Brunei-Dollar|Jamaika Pfund|Birr|Algerischer Franc Germinal|Algerischer Neuer Franc|Algerischer Dinar|Guarani|Libysches Pfund|Jamaika Dollar|Isl\u00e4ndische Krone|Spanische Pesete|Bermuda-Pfund|Libyscher Dinar|Bermuda-Dollar|Holl\u00e4ndischer Gulden|Ouguiya|Rial|Schwedische Krone|Nakfa|Kenia Schilling|Zentralafrikanische Republik CFA Franc|Argentinischer Peso|Argentinischer Peso (1983-1985)|Argentinischer Peso Moneda Nacional|Neuer Taiwan Dollar|Sudanesisches Pfund|Georgischer Lari|Georgischer Kupon Larit|Falkland Pfund|Argentinischer Austral|Sudanesischer Dinar|Irak Dinar|Tuvalu Dollar|Seychellen Rupie|Lettischer Rubel|Fidschi Pfund|Lettischer Lats|Kongolesische Zaire|Republik Kongo Franc|Franc congolais|Fidschi Dollar|Gold-Cordoba|Pataca|Gold-Cordoba|Cordoba|COMECON Transferabler Rubel|Finnische Mark (1860-1962)|Finnische Mark|Salomonen Dollar|Luxemburgischer Franc|Trinidad und Tobago Dollar (alt)|Angolanischer Escudo|Kwanza Reajustado|Tugrik|Forint|Burundi-Franc|Neuer Kwanza|Angolanischer Kwanza (1977-1990)|Trinidad und Tobago Dollar|Lilangeni|Neue Hebriden CFP Franc|Pfund Sterling|Saudi Riyal|Litauischer Talonas|Indische Rupie|Portugiesischer Escudo|Kwanza|Portugiesischer Conto|Litauischer Litas|Tenge|Kasachstan Rubel|Britische Jungferninseln Dollar|Nigerianisches Pfund|Naira|Gourde|Syrisches Pfund|Pal\u00e4stina Pfund|Bahrain-Dinar|Kyat|Niederl. Antillen Gulden|Tschechische Krone|Loti|Lew (1879-1952)|Lew|Kanadischer Dollar|Lew|T\u00fcrkische Lira|Kaiman-Dollar|Zypern Pfund|Schekel|Guyana Dollar|Dram|Israelisches Pfund|Schekel|Bolivar|Liberianischer Dollar|Albanischer Lek Valute|Kuna|Kroatischer Dinar|Lek|Jersey Pfund Sterling|Albanischer Lek (1946-1961)|Nordvietnam Viet Minh Piastre Dong Viet|Nordvietnam Neuer Dong|Denar|Nordvietnam Piastre Dong Viet|Timor Pataca|CFP Franc|Guinea Bissau Peso|Kuwait Dinar|Portugiesisch Guinea Mil Reis|Belgischer Franc|Timor Escudo|Belgischer Franc (konvertibel)|Portugiesisch Guinea Escudo|El Salvador Colon|Taka|Tonga Pfund Sterling|Pa\u02bbanga|CFA Franc (West)|Sowjetischer Rubel|Sowjetischer Neuer Rubel|Neukaledonien Franc Germinal|Kap Verde Escudo|Franz\u00f6sischer Antillen CFA Franc|Rand|Dominikanischer Peso|S\u00fcdafrikanisches Pfund|Tunesischer Dinar|Kubanischer Peso|Franz\u00f6sisch Guayana Franc Guiana|Uganda Schilling|Ceylon Rupie|Afar und Issa Franc|Vatikanstadt Lire|Sao Tome und Principe Escudo|Uganda Schilling (1966-1987)|Dobra|Marshall Inseln Dollar|Neuseeland Pfund|Tala|West-Samoa Pfund|Lempira|Turkmenistan-Manat|Quetzal|Neuseeland Dollar|Schottisches Pfund|Barbados-Dollar|Namibia Dollar|Madagaskar Franc|Madagaskar Ariary|\u00c4gyptisches Pfund|Zloty (1950-1995)|Bosnien und Herzegowina Neuer Dinar|Konvertierbare Mark|Belize-Dollar|Bosnien und Herzegowina Dinar|Zloty|Jemen Rial|Suriname Gulden|S\u00fcdkoreanischer Won|Belarus Rubel (neu)|Jemen Imadi Riyal|Belarus Rubel (1992-1994)|Tschechoslowakische Krone|S\u00fcdkoreanischer Won (alt)|S\u00fcdkoreanischer Hwan|Belarus Rubel (alt)|Somaliland Schilling|Neue Griechische Drachme|Pakistanische Rupie|Afghani|Simbabwe Dollar|Sri Lanka Rupie|Griechische Drachme|Irisches Pfund|Afghani|Jemen Dinar|Ruanda Franc|Costa Rica Colon|Tadschikistan Somoni|Tadschikistan Rubel|Estnische Krone|\u00c4quatorialguinea Peseta Guineana|Moldau Rubel Cupon|Hongkong Dollar|D\u00e4nische Krone|Moldau Leu|\u00c4quatorialguinea Franco|\u00c4quatorialguinea Ekwele Guineana|Rupiah|UAE Dirham|Nordkoreanischer Won|Indonesische Neue Rupiah|Pula|Moldau Leu Cupon|Indonesische Java Rupiah|Nordkoreanischer Won (alt)|Indonesischer Nica Guilder|Vatu|Islamischer Dinar|Somalia Schilling|Andorranische Pesete|Russischer Rubel (alt)|Dschibuti-Franc|Andorranischer Diner|Monaco Franc Germinal|Monaco Franc Nouveau|Verrechnungseinheit f\u00fcr EC|Ecuadorianischer Sucre|Liechtenstein Franken|Russischer Rubel (neu)|Philippinischer Peso|Usbekistan Sum|Kolumbianischer Peso|Baht|Nordirisches Pfund|Birmanische Rupie|Kongo CFA Franc|Birmanischer Kyat|Kolumbianischer Papier-Peso|Ukrainischer Karbovanetz|Katar Riyal|Hryvnia|Renminbi Yuan|Metical|Uruguayischer Peso|San Marino Lire|Chinesischer Jen Min Piao Yuan|Kina|Guinea Franc|Rial Omani|Franz\u00f6sischer UIC-Franc|Zaire|Bhutan Rupie|Marokkanischer Franc|Marokkanischer Dirham|Franz\u00f6sischer Gold-Franc|Ngultrum|Neuer Zaire|Malaysischer Ringgit|Aserbeidschan Manat|Gambia Pfund|Komoren Franc|Leone|Dalasi|Bahama-Pfund|Kamerun CFA Franc|Mexican Unidad de Inversion (UDI)|Mexikanischer Silber-Peso (1861-1992)|Bahama-Dollar|Mexikanischer Peso|Sol|Gr\u00f6nland Krone|Brasilianischer Cruzeiro (1942-1967)|Neuer Sol|Chilenischer Peso|Slowakische Krone|Peruanischer Inti|Brasilianischer Cruzeiro|Sonderziehungsrechte|Franz\u00f6sischer Franc Germinal/Franc Poincare|Franz\u00f6sischer Franc|Brasilianischer Cruzado Novo|Unidades de Fomento|Chilenischer Escudo|Real|Chilenischer Condor|Brasilianischer Cruzeiro (1990-1993)|Sperrmark|Malawi Pfund|Brasilianischer Cruzado|Brasilianischer Cruzeiro Novo (1967-1986)|Malawi Kwacha|Dnjestr-Republik Rubel|Deutsche Mark|Tschad CFA Franc|Dnjestr-Republik Rubel (neu)|Dnjestr-Republik Rubel Kupon|Nepalesische Rupie|Yen|Rufiyaa|Malediven Rupie|Ostkaribischer Dollar|Tolar|Jugoslawischer Reformierter Dinar|Aruba Florin|Jugoslawischer Oktober-Dinar|Jugoslawischer Dinar (konvertibel)|Neuer Dinar|Turks und Caicos Krone|Jugoslawischer 1994-Dinar|Jugoslawische F\u00f6deration Dinar|Neuer Leu|Jugoslawischer Dinar (1966-1990)|Leu|Tolar Bons|Norwegische Krone|Mauritius Rupie|Europ\u00e4ische Rechnungseinheit (XBD)|Gibraltar Pfund|Vietnamesischer Dong|Europ\u00e4ische Rechnungseinheit (XBC)|Republik Vietnam Dong|Europ\u00e4ische Rechnungseinheit|St. Helena Pfund|Vietnamesischer Neuer Dong";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|BOL|KHO|ZMP|AUP|XAF|MTP|ZMK|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|LSL|BGO|BGN|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|ILL|VEB|LRD|ALV|HRK|HRD|ALL|JEP|ALK|VDP|VDN|MKD|VDD|TPP|XPF|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|ZAP|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UAK|QAR|UAH|CNY|MZM|UYU|SML|CNP|PGK|GNF|OMR|XFU|ZRZ|BTR|MAF|MAD|XFO|BTN|ZRN|MYR|AZM|GMP|KMF|SLL|GMD|BSP|CMF|MXV|MXP|BSD|MXN|PES|GLK|PEN|BRZ|SKK|CLP|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|MVR|MVP|XCD|SIT|YUR|AWG|YUO|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBA|SHP|VNN";

  private static final String currenciesSymbolValues = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|BOL|KHO|ZMP|AUP|XAF|MTP|ZMK|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|som|SFr.|\u00f6S|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|LSL|BGO|BGN|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|ILL|VEB|LRD|ALV|HRK|HRD|ALL|JEP|ALK|VDP|VDN|MKD|VDD|TPP|XPF|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|ZAP|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|Af|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UAK|QAR|UAH|CNY|MZM|UYU|SML|CNP|PGK|GNF|OMR|XFU|ZRZ|BTR|MAF|MAD|XFO|BTN|ZRN|MYR|AZM|GMP|KMF|SLL|GMD|BSP|CMF|MXV|MXP|BSD|MXN|PES|GLK|PEN|BRZ|SKK|CLP|PEI|BRR|XDR|FRG|FF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DM|TDF|PDN|PDK|NPR|MVR|MVP|EC$|SIT|YUR|AWG|YUO|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBA|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Feb",
    "Mrz",
    "Apr",
    "Mai",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Okt",
    "Nov",
    "Dez",
    null,
  };

  private static final String[] months = {
    "Januar",
    "Februar",
    "M\u00e4rz",
    "April",
    "Mai",
    "Juni",
    "Juli",
    "August",
    "September",
    "Oktober",
    "November",
    "Dezember",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "So",
    "Mo",
    "Di",
    "Mi",
    "Do",
    "Fr",
    "Sa",
  };

  private static final String[] weekdays = {
    null,
    "Sonntag",
    "Montag",
    "Dienstag",
    "Mittwoch",
    "Donnerstag",
    "Freitag",
    "Samstag",
  };

  private static final String[] eras = {
    "v. Chr.",
    "n. Chr.",
  };

  private static final String[] ampms = {
    "vorm.",
    "nachm.",
  };

  private static final String[][] zoneStrings =
  {
    { "MEZ", "Mitteleurop\u00e4ische Zeit", "MESZ", "Mitteleurop\u00e4ische Sommerzeit",  "Europe/Berlin" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Osttimor|Tokelau|Tadschikistan|Thailand|Togo|Franz\u00f6sische S\u00fcd- und Antarktisgebiete|Guyana|Tschad|Turks- und Caicosinseln|Guinea-Bissau|Guam|Guatemala|S\u00fcdgeorgien und die S\u00fcdlichen Sandwichinseln|Griechenland|\u00c4quatorialguinea|Guadeloupe|Swasiland|Syrien|Guinea|Gambia|Gr\u00f6nland|El Salvador|S\u00e3o Tom\u00e9 und Pr\u00edncipe|Gibraltar|Ghana|Suriname|Franz\u00f6sisch-Guayana|Serbien|Georgien|Somalia|Grenada|Senegal|San Marino|Vereinigtes K\u00f6nigreich|Sierra Leone|Gabun|Slowakei|Svalbard und Jan Mayen|Slowenien|St. Helena|Singapur|Schweden|Sudan|Seychellen|Salomonen|Saudi-Arabien|Frankreich|F\u00e4r\u00f6er|Mikronesien|Ruanda|Falklandinseln|Russische F\u00f6deration|Fidschi|Finnland|Rum\u00e4nien|R\u00e9union|\u00c4thiopien|Spanien|Eritrea|Westsahara|\u00c4gypten|Estland|Ecuador|Algerien|Katar|Dominikanische Republik|Paraguay|Dominica|Palau|D\u00e4nemark|Dschibuti|Portugal|Pal\u00e4stinensische Gebiete|Puerto Rico|Deutschland|Pitcairn|St. Pierre und Miquelon|Polen|Pakistan|Philippinen|Papua-Neuguinea|Franz\u00f6sisch-Polynesien|Tschechische Republik|Peru|Zypern|Weihnachtsinsel|Kap Verde|Panama|Kuba|Costa Rica|Kolumbien|China|Kamerun|Chile|Cookinseln|C\u00f4te d\u2019Ivoire|Schweiz|Kongo|Zentralafrikanische Republik|Demokratische Republik Kongo|Kokosinseln (Keeling)|Oman|Kanada|Belize|Belarus|Botsuana|Bouvetinsel|Bhutan|Bahamas|Brasilien|Neuseeland|Bolivien|Brunei Darussalam|Bermuda|Niue|Benin|Burundi|Bahrain|Nauru|Bulgarien|Burkina Faso|Nepal|Belgien|Norwegen|Bangladesch|Barbados|Simbabwe|Niederlande|Bosnien und Herzegowina|Nicaragua|Nigeria|Norfolkinsel|Aserbaidschan|Niger|Neukaledonien|Aruba|Sambia|Namibia|Australien|\u00d6sterreich|Amerikanisch-Samoa|Argentinien|Antarktis|Mosambik|Angola|Malaysia|Niederl\u00e4ndische Antillen|Mexiko|Armenien|Malawi|Albanien|Malediven|S\u00fcdafrika|Mauritius|Malta|Anguilla|Montserrat|Mauretanien|Antigua und Barbuda|Martinique|Afghanistan|N\u00f6rdliche Marianen|Vereinigte Arabische Emirate|Macau S.A.R., China|Andorra|Mongolei|Myanmar|Mali|Mazedonien|Jugoslawien|Mayotte|Marshallinseln|Madagaskar|Republik Moldau|Monaco|Marokko|Jemen|Libyen|Lettland|Luxemburg|Litauen|Lesotho|Liberia|Sri Lanka|Liechtenstein|St. Lucia|Libanon|Laos|Kasachstan|Kaimaninseln|Kuwait|Republik Korea|Demokratische Volksrepublik Korea|St. Kitts und Nevis|Komoren|Kiribati|Samoa|Kambodscha|Kirgisistan|Kenia|Wallis und Futuna|Japan|Jordanien|Jamaika|Vanuatu|Vietnam|Amerikanische Jungferninseln|Britische Jungferninseln|Venezuela|St. Vincent und die Grenadinen|Vatikanstadt|Italien|Island|Iran|Irak|Usbekistan|Britisches Territorium im Indischen Ozean|Uruguay|Indien|Israel|Vereinigte Staaten|Irland|Indonesien|Amerikanisch-Ozeanien|Uganda|Ukraine|Ungarn|Haiti|Kroatien|Tansania|Honduras|Heard und McDonaldinseln|Taiwan|Tuvalu|Hong Kong S.A.R., China|Trinidad und Tobago|T\u00fcrkei|Tonga|Tunesien|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "Gwich\u02bbin|Akkadisch|Ekajuk|Ijo|Xhosa|Sumerisch|Susu|Verschiedene Sprachen|Lozi|Tonga (Nyasa)|Ponapeanisch|Minangkabau|Sukuma|Wolof|Mongo|Kutenai|Micmac|Wallonisch|Kum\u00fckisch|Zapotekisch|Kuschitische Sprachen (Andere)|Lojban|Dogri|Volap\u00fck|Otomangue-Sprachen|Vietnamesisch|Vai|Rarotongan|Venda-Sprache|Rapanui|Rajasthani|Osmanisch|Nzima|Neapolitanisch|Usbekisch|Ugaritisch|Tamaseq|Indianersprachen, Nordamerika (Andere)|Nahuatl|Urdu|Fanti|Ukrainisch|\u00c4gyptisch|Uigurisch|Fang|Nilosaharanische Sprachen|Mittelirisch|Baltische Sprachen (Andere)|Nyoro|Basaa-Sprache|Nyankole|Nyamwezi|Miao-Sprachen|Balinesisch|Osage|Belutschisch|Tahitisch|Bamileke-Sprachen|Twi|Serer|Tlingit|Tatarisch|Tsonga|Banda|T\u00fcrkisch|Tongaisch|Tswana-Sprache|Tagalog|Turkmenisch|Tigrinja|Thai|Kurukh|Tadschikisch|Blin|Telugu|Kru|Kaschubisch|Tamilisch|Tokelauanisch|Efik|Suaheli|Schwedisch|Sudanesisch|Karatschaiisch-Balkarisch|S\u00fcd-Sotho-Sprache|Swazi|Serbisch|Albanisch|Mende|Kreolische Sprachen|Somali|Afrihili|Shona|Samoanisch|Slowenisch|Griechisch (bis 1453)|Slowakisch|Gerbo|Singhalesisch|Serbo-Kroatisch|Krimtatarisch|Afro-Asiatische Sprachen  (Andere)|Sango|Nord-Samisch|Sindhi|Udmurtisch|Sardisch|Sanskrit|Ruandisch|Russisch|Mandaresisch|Rum\u00e4nisch|Rundi-Sprache|R\u00e4toromanisch|Moksha|Tiv|Adygai|Zuni|Kpelle|Quechua|Tigre|Songhai|Kreolisch-Portugiesisch (Andere)|Sogdien|Adangme|Kosraeanisch|Hethitisch|Kreolisch-Franz\u00f6sisch (Andere)|Krio|Himachali|Konkani|Hiligaynon|Gotisch|Gorontalo|Gondi|Dinka|Nubische Sprachen|Portugiesisch|Afghanisch (Paschtu)|Friulisch|Ph\u00f6nikisch|Althochdeutsch|Soninke|Koptisch|Yap|Acoli|Yao|Philippinen-Austronesisch (Andere)|Polnisch|Achinesisch|Pali|Pandschabisch|Buginesisch|Iban|Skolt-Lappisch|Burjatisch|Masai|Inari-Lappisch|Ossetisch|Austronesisch|Orija|Mandingo|Lule-Lappisch|Lappisch|Makassarisch|Oromo|Maithili|Ojibwa-Sprache|Magahi|Maduresisch|S\u00fcd-Samisch|Okzitanisch|Sotho (Nord)|Batak|Erzya|Dogrib|Chewa-Sprache|Maya-Sprachen|Navajo-Sprache|Kimbundu|Ndebele-Sprache (S\u00fcd)|Mittelhochdeutsch|Norwegisch|Norwegisch Nynorsk|Niederl\u00e4ndisch|Ndonga|Slawische Sprachen (Andere)|Nepalesisch|Ndebele-Sprache (Nord)|Cham-Sprachen|Tetum|Norwegisch Bokm\u00e5l|Nauruisch|Tereno|Temne|Birmanisch|Lesgisch|Maltesisch|Altpersisch|Malaiisch|Marathi|Altfranz\u00f6sisch|Moldauisch|Mittelfranz\u00f6sisch|Mongolisch|J\u00fcdisch-Arabisch|Malayalam|Mazedonisch|Maori|Marschallesisch|Madagassisch|Marwari|Braj|Slave|Lettisch|Luba|Delaware|Litauisch|Laotisch|Lingala|Limburgisch|Ewondo|Ganda-Sprache|Luxemburgisch|Latein|J\u00fcdisch-Persisch|Wotisch|Sinotibetische Sprachen (Andere)|Kirgisisch|Kornisch|Komi-Sprache|Kurdisch|Sioux-Sprachen|Kaschmirisch|Kanuri-Sprache|Awadhi|Koreanisch|Kannada|Kambodschanisch|Gr\u00f6nl\u00e4ndisch|Kasachisch|Romany|Kwanyama|Sidamo|Kikuyu-Sprache|Kongo|Altnordisch|Georgisch|Creek|Romance (Other)|Nogai|Munda-Sprachen|Polyglott|Javanisch|Gilbertesisch|Zande|Schan-Sprache|Fon|Kalm\u00fcckisch|Australische Sprachen|Sakisch|Japanisch|Khoisan-Sprachen (Andere)|Palau|Cheyenne|Thaisprachen (Andere)|Inukitut|Papiamento|Italienisch|Geb\u00e4rdensprache|Isl\u00e4ndisch|Khasi|Cherokee|Pampanga|Mittelpersisch|Chipewyan|Ido|Choctaw|Chinook|Tscheremissisch|Tuwinisch|Bantu|Pangasinan|Inupiak|Trukesisch|Sichuan Yi|Hawaiianisch|Banjari|Igbo-Sprache|Tschagataisch|Altirisch|Papuasprachen (Andere)|Interlingue|Indonesisch|Lahnda|Dajak|Chibcha|Interlingua|Ladino|Herero-Sprache|Haida|Darginisch|Armenisch|Athapaskische Sprachen|Ungarisch|Kreolisch|Dakota|Kroatisch|Hiri-Motu|Hindi|Dyula|Hebr\u00e4isch|Asturianisch|Hausa|Sorbisch|Manx|Gujarati|Semitische Sprachen (Andere)|Selkupisch|Irokesische Sprachen|Guarani|Galizisch|Arawak|Geez|Kunstsprachen (Andere)|Schottisch-G\u00e4lisch|Iranisch|Irisch|Arapaho-Sprache|Araukanisch|Friesisch|Siksika|Germanische Sprachen (Andere)|Yupik-Sprachen|Aram\u00e4isch|Franz\u00f6sisch|F\u00e4r\u00f6isch|Keltische Sprachen (Andere)|Fidschianisch|Finnisch|Ful|Elliceanisch|Cebuano|Persisch|Baskisch|Schottisch|Estnisch|Spanisch|Esperanto|Englisch|Griechisch|Altaische Sprachen (Andere)|Niue|Tupi-Sprachen|Ewe-Sprache|Tumbuka|Mossi|Bhutanisch|Nigerkordofanische Sprachen|Lushai|Finnougrische Sprachen (Andere)|Maledivisch|Nias|Mohawk|Luo|Lunda|Apachen-Sprachen|Luiseno|Hupa|Bini|Deutsch|Luba-Lulua|Bikol|Washo|Sprache nicht ermittelt|Waray|D\u00e4nisch|Mittelniederl\u00e4ndisch|Walamo|Manobo-Sprachen|Wakash-Sprachen|Santali|Kymrisch|Sassak|Kabardinisch|Tschuwaschisch|Kirchenslawisch|Manipuri|Tschechisch|Samaritanisch|Cree|Salish-Sprachen|Duala|Korsisch|Indianersprachen, S\u00fcdamerika (Andere)|Mandschurisch|Jakutisch|Altjavanisch|Ingush|Gbaya|Sandawe|Chamorro-Sprache|Indogermanische Sprachen (Andere)|Bhodschpuri|Mittelenglisch|Karenisch|Indoarische Sprachen|Tschetschenisch|Gayo|Katalanisch|Umbundu|Syrisch|Kamba|Tsimshian|Altenglisch|Kachin|Kaukasische Sprachen (Andere)|Kabylisch|Karakalpakisch|Bosnisch|Karibische Sprachen|Bretonisch|Tibetisch|Bengalisch|Bambara-Sprache|Ga|Indianersprachen, Zentralamerika (Andere)|Bislama|Biharisch|Bulgarisch|Wei\u00dfrussisch|Caddo|Baschkirisch|Zulu|Zenaga|Altprovenzalisch|Obersorbisch|Aserbaidschanisch|Aymar\u00e1-Sprache|Awarisch|Assamesisch|Niedersorbisch|Arabisch|Iloko|Elamisch|Chinesisch|Aragonesisch|Prakrit|Amharisch|Newari|Akan|Zhuang|Afrikaans|Avestisch|Abchasisch|Afar|Joruba|Algonkin-Sprachen|Aleutisch|Mon-Khmer-Sprachen|Jiddisch|Drawidische Sprachen (Andere)|Berbersprachen|Niederdeutsch|Bemba|Bedauye|Neumelanesisch";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "POSIX|REVISED";

  private static final String variantsValues = "Posix|Revidiert";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "collation_rules", collation_rules },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "dd.MM.yy" },
    { "mediumDateFormat", "dd.MM.yyyy" },
    { "longDateFormat", "d. MMMM yyyy" },
    { "fullDateFormat", "EEEE, d. MMMM yyyy" },
    { "fullTimeFormat", "H:mm' Uhr 'z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
