/* LocaleInformation_lv.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_lv extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "LVL";

  private static final String currenciesDisplayNameValues = "LVL";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "LVL";

  private static final String currenciesSymbolValues = "Ls";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "Mai",
    "J\u016bn",
    "J\u016bl",
    "Aug",
    "Sep",
    "Okt",
    "Nov",
    "Dec",
    null,
  };

  private static final String[] months = {
    "janv\u0101ris",
    "febru\u0101ris",
    "marts",
    "apr\u012blis",
    "maijs",
    "j\u016bnijs",
    "j\u016blijs",
    "augusts",
    "septembris",
    "oktobris",
    "novembris",
    "decembris",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Sv",
    "P",
    "O",
    "T",
    "C",
    "Pk",
    "S",
  };

  private static final String[] weekdays = {
    null,
    "sv\u0113tdiena",
    "pirmdiena",
    "otrdiena",
    "tre\u0161diena",
    "ceturtdiena",
    "piektdiena",
    "sestdiena",
  };

  private static final String[] eras = {
    "pm\u0113",
    "m\u0113",
  };

  private static final String territoriesKeys = "TL\u00A6TK\u00A6TJ\u00A6TH\u00A6TG\u00A6TF\u00A6GY\u00A6TD\u00A6TC\u00A6GW\u00A6GU\u00A6GT\u00A6GS\u00A6GR\u00A6GQ\u00A6GP\u00A6SZ\u00A6SY\u00A6GN\u00A6GM\u00A6GL\u00A6SV\u00A6ST\u00A6GI\u00A6GH\u00A6SR\u00A6GF\u00A6GE\u00A6SO\u00A6GD\u00A6SN\u00A6SM\u00A6GB\u00A6SL\u00A6GA\u00A6SK\u00A6SJ\u00A6SI\u00A6SH\u00A6SG\u00A6SE\u00A6SD\u00A6SC\u00A6SB\u00A6SA\u00A6FR\u00A6FO\u00A6FM\u00A6RW\u00A6FK\u00A6RU\u00A6FJ\u00A6FI\u00A6RO\u00A6RE\u00A6ET\u00A6ES\u00A6ER\u00A6EH\u00A6EG\u00A6EE\u00A6EC\u00A6DZ\u00A6QA\u00A6DO\u00A6PY\u00A6DM\u00A6PW\u00A6DK\u00A6DJ\u00A6PT\u00A6PS\u00A6PR\u00A6DE\u00A6PN\u00A6PM\u00A6PL\u00A6PK\u00A6PH\u00A6PG\u00A6PF\u00A6CZ\u00A6PE\u00A6CY\u00A6CX\u00A6CV\u00A6PA\u00A6CU\u00A6CR\u00A6CO\u00A6CN\u00A6CM\u00A6CL\u00A6CK\u00A6CI\u00A6CH\u00A6CG\u00A6CF\u00A6CD\u00A6CC\u00A6OM\u00A6CA\u00A6BZ\u00A6BY\u00A6BW\u00A6BV\u00A6BT\u00A6BS\u00A6BR\u00A6NZ\u00A6BO\u00A6BN\u00A6BM\u00A6NU\u00A6BJ\u00A6BI\u00A6BH\u00A6NR\u00A6BG\u00A6BF\u00A6NP\u00A6BE\u00A6NO\u00A6BD\u00A6BB\u00A6ZW\u00A6NL\u00A6BA\u00A6NI\u00A6NG\u00A6NF\u00A6AZ\u00A6NE\u00A6NC\u00A6AW\u00A6ZM\u00A6NA\u00A6AU\u00A6AT\u00A6AS\u00A6AR\u00A6AQ\u00A6MZ\u00A6AO\u00A6MY\u00A6AN\u00A6MX\u00A6AM\u00A6MW\u00A6AL\u00A6MV\u00A6ZA\u00A6MU\u00A6MT\u00A6AI\u00A6MS\u00A6MR\u00A6AG\u00A6MQ\u00A6AF\u00A6MP\u00A6AE\u00A6MO\u00A6AD\u00A6MN\u00A6MM\u00A6ML\u00A6MK\u00A6YU\u00A6YT\u00A6MH\u00A6MG\u00A6MD\u00A6MC\u00A6MA\u00A6YE\u00A6LY\u00A6LV\u00A6LU\u00A6LT\u00A6LS\u00A6LR\u00A6LK\u00A6LI\u00A6LC\u00A6LB\u00A6LA\u00A6KZ\u00A6KY\u00A6KW\u00A6KR\u00A6KP\u00A6KN\u00A6KM\u00A6KI\u00A6WS\u00A6KH\u00A6KG\u00A6KE\u00A6WF\u00A6JP\u00A6JO\u00A6JM\u00A6VU\u00A6VN\u00A6VI\u00A6VG\u00A6VE\u00A6VC\u00A6VA\u00A6IT\u00A6IS\u00A6IR\u00A6IQ\u00A6UZ\u00A6IO\u00A6UY\u00A6IN\u00A6IL\u00A6US\u00A6IE\u00A6ID\u00A6UM\u00A6UG\u00A6UA\u00A6HU\u00A6HT\u00A6HR\u00A6TZ\u00A6HN\u00A6HM\u00A6TW\u00A6TV\u00A6HK\u00A6TT\u00A6TR\u00A6TO\u00A6TN\u00A6TM";

  private static final String territoriesValues = "Austrumtimora\u00A6Tokelau\u00A6Tad\u017eikist\u0101na\u00A6Taizeme\u00A6Togo\u00A6Fran\u010du dienvidu teritorijas\u00A6Gaj\u0101na\u00A6\u010cada\u00A6T\u0113rksas un Kaikosas salas\u00A6Gvineja-Bisava\u00A6Guama\u00A6Gvatemala\u00A6Dienvidd\u017eord\u017eija un Dienvidsendvi\u010du salas\u00A6Grie\u0137ija\u00A6Ekvatori\u0101l\u0101 Gvineja\u00A6Gvadelupa\u00A6Svazilenda\u00A6S\u012brija\u00A6Gvineja\u00A6Gambija\u00A6Grenlande\u00A6Salvadora\u00A6Santome un Prinsipi\u00A6Gibralt\u0101rs\u00A6Gana\u00A6Surinama\u00A6Fran\u010du Gvi\u0101na\u00A6Gruzija\u00A6Som\u0101lija\u00A6Gren\u0101da\u00A6Seneg\u0101la\u00A6Sanmar\u012bno\u00A6Lielbrit\u0101nija\u00A6Sjerraleone\u00A6Gabona\u00A6Slov\u0101kija\u00A6Svalb\u0101ra un Jana Majena sala\u00A6Slov\u0113nija\u00A6Sv. Hel\u0113nas sala\u00A6Singap\u016bra\u00A6Zviedrija\u00A6Sud\u0101na\u00A6Sei\u0161e\u013cu salas\u00A6Z\u0101lamana salas\u00A6Sa\u016bda Ar\u0101bija\u00A6Francija\u00A6Far\u0113ru salas\u00A6Mikron\u0113zijas Federat\u012bv\u0101s Valstis\u00A6Ruanda\u00A6Folklenda salas\u00A6Krievija\u00A6Fid\u017ei\u00A6Somija\u00A6Rum\u0101nija\u00A6Reinjona\u00A6Etiopija\u00A6Sp\u0101nija\u00A6Eritreja\u00A6Rietumsah\u0101ra\u00A6\u0112\u0123ipte\u00A6Igaunija\u00A6Ekvadora\u00A6Al\u017e\u012brija\u00A6Katara\u00A6Dominik\u0101nas Republika\u00A6Paragvaja\u00A6Dominika\u00A6Palau\u00A6D\u0101nija\u00A6D\u017eibutija\u00A6Portug\u0101le\u00A6Palest\u012bnie\u0161u pa\u0161p\u0101rvaldes teritorija\u00A6Puertoriko\u00A6V\u0101cija\u00A6Pitk\u0113rna\u00A6Senpj\u0113ra un Mikelona\u00A6Polija\u00A6Pakist\u0101na\u00A6Filip\u012bnas\u00A6Papua-Jaungvineja\u00A6Fran\u010du Polin\u0113zija\u00A6\u010cehija\u00A6Peru\u00A6Kipra\u00A6Ziemsv\u0113tku sala\u00A6Kaboverde\u00A6Panama\u00A6Kuba\u00A6Kostarika\u00A6Kolumbija\u00A6\u0136\u012bna\u00A6Kamer\u016bna\u00A6\u010c\u012ble\u00A6Kuka salas\u00A6Kotdivu\u0101ra\u00A6\u0160veice\u00A6Kongo\u00A6Centr\u0101l\u0101frikas Republika\u00A6Kongo Demokr\u0101tisk\u0101 Republika\u00A6Kokosu (K\u012blinga) salas\u00A6Om\u0101na\u00A6Kan\u0101da\u00A6Beliza\u00A6Baltkrievija\u00A6Botsv\u0101na\u00A6Buv\u0113 sala\u00A6But\u0101na\u00A6Bahamas\u00A6Braz\u012blija\u00A6Jaunz\u0113lande\u00A6Bol\u012bvija\u00A6Bruneja\u00A6Bermudu salas\u00A6Niue\u00A6Benina\u00A6Burundi\u00A6Bahreina\u00A6Nauru\u00A6Bulg\u0101rija\u00A6Burkinafaso\u00A6Nep\u0101la\u00A6Be\u013c\u0123ija\u00A6Norv\u0113\u0123ija\u00A6Banglade\u0161a\u00A6Barbadosa\u00A6Zimbabve\u00A6N\u012bderlande\u00A6Bosnija un Hercegovina\u00A6Nikaragva\u00A6Nig\u0113rija\u00A6Norfolka\u00A6Azerbaid\u017e\u0101na\u00A6Nig\u0113ra\u00A6Jaunkaledonija\u00A6Aruba\u00A6Zambija\u00A6Nam\u012bbija\u00A6Austr\u0101lija\u00A6Austrija\u00A6Amerik\u0101\u0146u Samoa\u00A6Argent\u012bna\u00A6Antarktika\u00A6Mozambika\u00A6Angola\u00A6Malaizija\u00A6Anti\u013cas\u00A6Meksika\u00A6Arm\u0113nija\u00A6Mal\u0101vija\u00A6Alb\u0101nija\u00A6Mald\u012bvija\u00A6Dienvid\u0101frika\u00A6Maur\u012bcija\u00A6Malta\u00A6Angilja\u00A6Montserrata\u00A6Maurit\u0101nija\u00A6Antigva un Barbuda\u00A6Martinika\u00A6Afganist\u0101na\u00A6Zieme\u013cu Marianas\u00A6Apvienotie Ar\u0101bu Emir\u0101ti\u00A6Makao, \u0136\u012bnas \u012bpa\u0161\u0101s p\u0101rvaldes apgabals\u00A6Andora\u00A6Mongolija\u00A6Mjanma\u00A6Mali\u00A6Ma\u0137edonija\u00A6Dienvidsl\u0101vija\u00A6Majota\u00A6M\u0101r\u0161ala salas\u00A6Madagaskara\u00A6Moldova\u00A6Monako\u00A6Maroka\u00A6Jemena\u00A6L\u012bbija\u00A6Latvija\u00A6Luksemburga\u00A6Lietuva\u00A6Lesoto\u00A6Lib\u0113rija\u00A6\u0160rilanka\u00A6Lihten\u0161teina\u00A6Sentl\u016bsija\u00A6Lib\u0101na\u00A6Laosa\u00A6Kazahst\u0101na\u00A6Kaimanu salas\u00A6Kuveita\u00A6Dienvidkoreja\u00A6Zieme\u013ckoreja\u00A6Sentkitsa un Nevisa\u00A6Komoru salas\u00A6Kiribati\u00A6Samoa\u00A6Kambod\u017ea\u00A6Kirg\u012bzija\u00A6Kenija\u00A6Volisa un Futuna\u00A6Jap\u0101na\u00A6Jord\u0101nija\u00A6Jamaika\u00A6Vanuatu\u00A6Vjetnama\u00A6Amerik\u0101\u0146u Vird\u017e\u012bnu salas\u00A6Britu Vird\u017e\u012bnu salas\u00A6Venecu\u0113la\u00A6Sentvinsenta un Grenad\u012bnas\u00A6Vatik\u0101ns\u00A6It\u0101lija\u00A6Islande\u00A6Ir\u0101na\u00A6Ir\u0101ka\u00A6Uzbekist\u0101na\u00A6Britu Indijas oke\u0101na teritorija\u00A6Urugvaja\u00A6Indija\u00A6Izra\u0113la\u00A6United States\u00A6\u012arija\u00A6Indon\u0113zija\u00A6ASV maz\u0101s aizj\u016bras teritorijas\u00A6Uganda\u00A6Ukraina\u00A6Ung\u0101rija\u00A6Haiti\u00A6Horv\u0101tija\u00A6Tanz\u0101nija\u00A6Hondurasa\u00A6H\u0113rda un Makdonalda salas\u00A6Taiv\u0101na\u00A6Tuvalu\u00A6Honkonga, \u0136\u012bnas \u012bpa\u0161\u0101s p\u0101rvaldes apgabals\u00A6Trinid\u0101da un Tob\u0101go\u00A6Turcija\u00A6Tonga\u00A6Tunisija\u00A6Turkmenist\u0101na";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ja\u00A6en\u00A6tr\u00A6ko\u00A6no\u00A6el\u00A6nl\u00A6bg\u00A6lv\u00A6he\u00A6cs\u00A6it\u00A6lt\u00A6fr\u00A6zh\u00A6ru\u00A6ro\u00A6fi\u00A6ar\u00A6sv\u00A6pt\u00A6pl\u00A6sl\u00A6sk\u00A6de\u00A6hu\u00A6et\u00A6es\u00A6hr\u00A6da";

  private static final String languagesValues = "jap\u0101\u0146u\u00A6ang\u013cu\u00A6turku\u00A6korejie\u0161u\u00A6norv\u0113\u0123u\u00A6grie\u0137u\u00A6holandie\u0161u\u00A6bulg\u0101ru\u00A6latvie\u0161u\u00A6ivrits\u00A6\u010dehu\u00A6it\u0101lie\u0161u\u00A6lietuvie\u0161u\u00A6fran\u010du\u00A6\u0137\u012bnie\u0161u\u00A6krievu\u00A6rum\u0101\u0146u\u00A6somu\u00A6ar\u0101bu\u00A6zviedru\u00A6portug\u0101\u013cu\u00A6po\u013cu\u00A6slov\u0113\u0146u\u00A6slov\u0101ku\u00A6v\u0101cu\u00A6ung\u0101ru\u00A6igau\u0146u\u00A6sp\u0101\u0146u\u00A6horv\u0101tu\u00A6d\u0101\u0146u";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "yy.d.M" },
    { "mediumDateFormat", "yyyy.d.M" },
    { "longDateFormat", "yyyy'. gada 'd. MMMM" },
    { "fullDateFormat", "EEEE, yyyy'. gada 'd. MMMM" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
