/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sasl.srp;

import gnu.crypto.Registry;
import gnu.crypto.key.srp6.SRPAlgorithm;
import gnu.crypto.sasl.NoSuchUserException;
import gnu.crypto.sasl.UserAlreadyExistsException;
import gnu.crypto.sasl.srp.SRP;
import gnu.crypto.sasl.srp.SRPRegistry;
import gnu.crypto.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PasswordFile {
    private static final String USER_FIELD = "user";
    private static final String VERIFIERS_FIELD = "verifier";
    private static final String SALT_FIELD = "salt";
    private static final String CONFIG_FIELD = "config";
    private static String DEFAULT_FILE;
    private static final HashMap srps;
    private String confName;
    private String pwName;
    private String pw2Name;
    private File configFile;
    private File passwdFile;
    private File passwd2File;
    private long lastmodPasswdFile;
    private long lastmodPasswd2File;
    private HashMap entries;
    private HashMap configurations;
    private static final BigInteger[] Nsrp;

    private /* synthetic */ void finit$() {
        this.entries = new HashMap();
        this.configurations = new HashMap();
    }

    public PasswordFile() throws IOException {
        this(DEFAULT_FILE);
    }

    public PasswordFile(File pwFile) throws IOException {
        this(pwFile.getAbsolutePath());
    }

    public PasswordFile(String pwName) throws IOException {
        this(pwName, pwName + "2", pwName + ".conf");
    }

    public PasswordFile(String pwName, String confName) throws IOException {
        this(pwName, pwName + "2", confName);
    }

    public PasswordFile(String pwName, String pw2Name, String confName) throws IOException {
        this.finit$();
        this.pwName = pwName;
        this.pw2Name = pw2Name;
        this.confName = confName;
        this.readOrCreateConf();
        this.update();
    }

    private static final String nameToID(String mdName) {
        if (Registry.SHA_HASH.equalsIgnoreCase(mdName) || Registry.SHA1_HASH.equalsIgnoreCase(mdName) || Registry.SHA160_HASH.equalsIgnoreCase(mdName)) {
            return "0";
        }
        if (Registry.MD5_HASH.equalsIgnoreCase(mdName)) {
            return "1";
        }
        if (Registry.RIPEMD128_HASH.equalsIgnoreCase(mdName)) {
            return "2";
        }
        if (Registry.RIPEMD160_HASH.equalsIgnoreCase(mdName)) {
            return "3";
        }
        if (Registry.SHA256_HASH.equalsIgnoreCase(mdName)) {
            return "4";
        }
        if (Registry.SHA384_HASH.equalsIgnoreCase(mdName)) {
            return "5";
        }
        if (Registry.SHA512_HASH.equalsIgnoreCase(mdName)) {
            return "6";
        }
        return "0";
    }

    public synchronized boolean containsConfig(String index) throws IOException {
        this.checkCurrent();
        return this.configurations.containsKey(index);
    }

    public synchronized String[] lookupConfig(String index) throws IOException {
        this.checkCurrent();
        String[] result = null;
        if (this.configurations.containsKey(index)) {
            result = (String[])this.configurations.get(index);
        }
        return result;
    }

    public synchronized boolean contains(String user) throws IOException {
        this.checkCurrent();
        return this.entries.containsKey(user);
    }

    public synchronized void add(String user, String passwd, byte[] salt, String index) throws IOException {
        this.checkCurrent();
        if (this.entries.containsKey(user)) {
            throw new UserAlreadyExistsException(user);
        }
        HashMap<String, Object> fields = new HashMap<String, Object>(4);
        fields.put(USER_FIELD, user);
        fields.put(VERIFIERS_FIELD, this.newVerifiers(user, salt, passwd, index));
        fields.put(SALT_FIELD, Util.toBase64(salt));
        fields.put(CONFIG_FIELD, index);
        this.entries.put(user, fields);
        this.savePasswd();
    }

    public synchronized void changePasswd(String user, String passwd) throws IOException {
        byte[] salt;
        this.checkCurrent();
        if (!this.entries.containsKey(user)) {
            throw new NoSuchUserException(user);
        }
        HashMap fields = (HashMap)this.entries.get(user);
        try {
            salt = Util.fromBase64((String)fields.get(SALT_FIELD));
        }
        catch (NumberFormatException x) {
            throw new IOException("Password file corrupt");
        }
        String index = (String)fields.get(CONFIG_FIELD);
        fields.put(VERIFIERS_FIELD, this.newVerifiers(user, salt, passwd, index));
        this.entries.put(user, fields);
        this.savePasswd();
    }

    public synchronized void savePasswd() throws IOException {
        FileOutputStream f1 = new FileOutputStream(this.passwdFile);
        FileOutputStream f2 = new FileOutputStream(this.passwd2File);
        PrintWriter pw1 = null;
        PrintWriter pw2 = null;
        try {
            pw1 = new PrintWriter(f1, true);
            pw2 = new PrintWriter(f2, true);
            this.writePasswd(pw1, pw2);
        }
        finally {
            Object var7_7;
            Object var5_5 = null;
            if (pw1 != null) {
                try {
                    pw1.flush();
                }
                finally {
                    var7_7 = null;
                    pw1.close();
                }
            }
            if (pw2 != null) {
                try {
                    pw2.flush();
                }
                finally {
                    var7_7 = null;
                    pw2.close();
                }
            }
            try {
                f1.close();
            }
            catch (IOException ignored) {}
            try {
                f2.close();
            }
            catch (IOException ignored) {}
        }
        this.lastmodPasswdFile = this.passwdFile.lastModified();
        this.lastmodPasswd2File = this.passwd2File.lastModified();
    }

    public synchronized String[] lookup(String user, String mdName) throws IOException {
        this.checkCurrent();
        if (!this.entries.containsKey(user)) {
            throw new NoSuchUserException(user);
        }
        HashMap fields = (HashMap)this.entries.get(user);
        HashMap verifiers = (HashMap)fields.get(VERIFIERS_FIELD);
        String salt = (String)fields.get(SALT_FIELD);
        String index = (String)fields.get(CONFIG_FIELD);
        String verifier = (String)verifiers.get(PasswordFile.nameToID(mdName));
        return new String[]{verifier, salt, index};
    }

    private synchronized void readOrCreateConf() throws IOException {
        this.configurations.clear();
        this.configFile = new File(this.confName);
        try {
            FileInputStream fis = new FileInputStream(this.configFile);
            this.readConf(fis);
        }
        catch (FileNotFoundException x) {
            String g = Util.toBase64(Util.trim(new BigInteger("2")));
            for (int i = 0; i < Nsrp.length; ++i) {
                String index = String.valueOf(i + 1);
                String N = Util.toBase64(Util.trim(Nsrp[i]));
                this.configurations.put(index, new String[]{N, g});
            }
            FileOutputStream f0 = null;
            PrintWriter pw0 = null;
            try {
                f0 = new FileOutputStream(this.configFile);
                pw0 = new PrintWriter(f0, true);
                this.writeConf(pw0);
            }
            finally {
                Object var8_9 = null;
                if (pw0 != null) {
                    pw0.close();
                } else if (f0 != null) {
                    f0.close();
                }
            }
        }
    }

    private void readConf(InputStream in) throws IOException {
        String line;
        BufferedReader din = new BufferedReader(new InputStreamReader(in));
        while ((line = din.readLine()) != null) {
            String g;
            String N;
            String index;
            StringTokenizer st = new StringTokenizer(line, ":");
            try {
                index = st.nextToken();
                N = st.nextToken();
                g = st.nextToken();
            }
            catch (NoSuchElementException x) {
                throw new IOException("SRP password configuration file corrupt");
            }
            this.configurations.put(index, new String[]{N, g});
        }
    }

    private void writeConf(PrintWriter pw) {
        Iterator it = this.configurations.keySet().iterator();
        while (it.hasNext()) {
            String ndx = (String)it.next();
            String[] mpi = (String[])this.configurations.get(ndx);
            StringBuffer sb = new StringBuffer(ndx).append(":").append(mpi[0]).append(":").append(mpi[1]);
            pw.println(sb.toString());
        }
    }

    private HashMap newVerifiers(String user, byte[] s, String password, String index) throws UnsupportedEncodingException {
        String[] mpi = (String[])this.configurations.get(index);
        BigInteger N = new BigInteger(1, Util.fromBase64(mpi[0]));
        BigInteger g = new BigInteger(1, Util.fromBase64(mpi[1]));
        HashMap<String, String> result = new HashMap<String, String>(srps.size());
        for (int i = 0; i < srps.size(); ++i) {
            String digestID = String.valueOf(i);
            SRP srp = (SRP)srps.get(digestID);
            BigInteger x = new BigInteger(1, srp.computeX(s, user, password));
            BigInteger v = g.modPow(x, N);
            String verifier = Util.toBase64(v.toByteArray());
            result.put(digestID, verifier);
        }
        return result;
    }

    private synchronized void update() throws IOException {
        FileInputStream fis;
        this.entries.clear();
        this.passwdFile = new File(this.pwName);
        this.lastmodPasswdFile = this.passwdFile.lastModified();
        try {
            fis = new FileInputStream(this.passwdFile);
            this.readPasswd(fis);
        }
        catch (FileNotFoundException ignored) {
            // empty catch block
        }
        this.passwd2File = new File(this.pw2Name);
        this.lastmodPasswd2File = this.passwd2File.lastModified();
        try {
            fis = new FileInputStream(this.passwd2File);
            this.readPasswd2(fis);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void checkCurrent() throws IOException {
        if (this.passwdFile.lastModified() > this.lastmodPasswdFile || this.passwd2File.lastModified() > this.lastmodPasswd2File) {
            this.update();
        }
    }

    private void readPasswd(InputStream in) throws IOException {
        String line;
        BufferedReader din = new BufferedReader(new InputStreamReader(in));
        while ((line = din.readLine()) != null) {
            String index;
            String salt;
            String verifier;
            String user;
            StringTokenizer st = new StringTokenizer(line, ":");
            try {
                user = st.nextToken();
                verifier = st.nextToken();
                salt = st.nextToken();
                index = st.nextToken();
            }
            catch (NoSuchElementException x) {
                throw new IOException("SRP base password file corrupt");
            }
            HashMap<String, String> verifiers = new HashMap<String, String>(6);
            verifiers.put("0", verifier);
            HashMap<String, Object> fields = new HashMap<String, Object>(4);
            fields.put(USER_FIELD, user);
            fields.put(VERIFIERS_FIELD, verifiers);
            fields.put(SALT_FIELD, salt);
            fields.put(CONFIG_FIELD, index);
            this.entries.put(user, fields);
        }
    }

    private void readPasswd2(InputStream in) throws IOException {
        String line;
        BufferedReader din = new BufferedReader(new InputStreamReader(in));
        while ((line = din.readLine()) != null) {
            String verifier;
            String user;
            String digestID;
            StringTokenizer st = new StringTokenizer(line, ":");
            try {
                digestID = st.nextToken();
                user = st.nextToken();
                verifier = st.nextToken();
            }
            catch (NoSuchElementException x) {
                throw new IOException("SRP extended password file corrupt");
            }
            HashMap fields = (HashMap)this.entries.get(user);
            if (fields == null) continue;
            HashMap verifiers = (HashMap)fields.get(VERIFIERS_FIELD);
            verifiers.put(digestID, verifier);
        }
    }

    private void writePasswd(PrintWriter pw1, PrintWriter pw2) throws IOException {
        Iterator i = this.entries.keySet().iterator();
        while (i.hasNext()) {
            HashMap fields;
            String user = (String)i.next();
            if (!user.equals((fields = (HashMap)this.entries.get(user)).get(USER_FIELD))) {
                throw new IOException("Inconsistent SRP password data");
            }
            HashMap verifiers = (HashMap)fields.get(VERIFIERS_FIELD);
            StringBuffer sb1 = new StringBuffer().append(user).append(":").append((String)verifiers.get("0")).append(":").append((String)fields.get(SALT_FIELD)).append(":").append((String)fields.get(CONFIG_FIELD));
            pw1.println(sb1.toString());
            Iterator j = verifiers.keySet().iterator();
            while (j.hasNext()) {
                String digestID = (String)j.next();
                if ("0".equals(digestID)) continue;
                StringBuffer sb2 = new StringBuffer().append(digestID).append(":").append(user).append(":").append((String)verifiers.get(digestID));
                pw2.println(sb2.toString());
            }
        }
    }

    static {
        USER_FIELD = USER_FIELD;
        VERIFIERS_FIELD = VERIFIERS_FIELD;
        SALT_FIELD = SALT_FIELD;
        CONFIG_FIELD = CONFIG_FIELD;
        DEFAULT_FILE = System.getProperty("gnu.crypto.sasl.srp.password.file", "/etc/tpasswd");
        HashMap<String, SRP> map = new HashMap<String, SRP>(SRPRegistry.SRP_ALGORITHMS.length);
        map.put("0", SRP.instance(SRPRegistry.SRP_ALGORITHMS[0]));
        for (int i = 1; i < SRPRegistry.SRP_ALGORITHMS.length; ++i) {
            try {
                map.put(String.valueOf(i), SRP.instance(SRPRegistry.SRP_ALGORITHMS[i]));
                continue;
            }
            catch (Exception x) {
                System.err.println("Ignored: " + x);
                x.printStackTrace(System.err);
            }
        }
        srps = map;
        Nsrp = new BigInteger[]{SRPAlgorithm.N_2048, SRPAlgorithm.N_1536, SRPAlgorithm.N_1280, SRPAlgorithm.N_1024, SRPAlgorithm.N_768, SRPAlgorithm.N_640, SRPAlgorithm.N_512};
    }
}

