/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicencePanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3691043187997552948L;
    private String licence;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;

    public LicencePanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, new IzPanelLayout());
        this.loadLicence();
        this.add((Component)LabelFactory.create(installerFrame.langpack.getString("LicencePanel.info"), installerFrame.icons.getImageIcon("history"), 10), "nextLine");
        JTextArea jTextArea = new JTextArea(this.licence);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setAlignmentX(0.0f);
        this.add((Component)jScrollPane, "nextLine");
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = installerFrame.langpack.getString("LicencePanel.agree");
        this.yesRadio = new JRadioButton(string, false);
        buttonGroup.add(this.yesRadio);
        this.add((Component)this.yesRadio, "nextLine");
        this.yesRadio.addActionListener(this);
        char c = '\u0000';
        if (string != null && string.length() > 0) {
            c = string.toLowerCase().charAt(0);
            this.yesRadio.setMnemonic(c);
        }
        string = installerFrame.langpack.getString("LicencePanel.notagree");
        this.noRadio = new JRadioButton(string, true);
        buttonGroup.add(this.noRadio);
        this.add((Component)this.noRadio, "nextLine");
        this.noRadio.addActionListener(this);
        if (string != null && string.length() > 0) {
            char c2 = string.toLowerCase().charAt(0);
            if (c == c2) {
                if (string.indexOf(" ") != -1 && string.indexOf(" ") < string.length() - 2) {
                    c2 = string.toLowerCase().charAt(string.indexOf(" ") + 1);
                } else if (string.length() > 0) {
                    c2 = string.toLowerCase().charAt(1);
                }
            }
            if (c2 > '\u0000') {
                this.noRadio.setMnemonic(c2);
            }
        }
        this.setInitialFocus(this.noRadio);
        this.getLayoutHelper().completeLayout();
    }

    private void loadLicence() {
        try {
            String string = "LicencePanel.licence";
            this.licence = ResourceManager.getInstance().getTextResource(string);
        }
        catch (Exception exception) {
            this.licence = "Error : could not load the licence text !";
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

