## This file is part of GNU RADIUS.
## Copyright (C) 2001, Sergey Poznyakoff
##
## This file is free software; as a special exception the author gives
## unlimited permission to copy and/or distribute it, with or without
## modifications, as long as this notice is preserved.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
## implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

BEGIN {
	print "/* $Id: mksnmp-h.awk,v 1.2 2001/03/07 10:42:11 gray Exp $ */"
	print "/* This file is automatically generated"
	print " * Please, do not edit."
	for (i = 1; i < ARGC; i++)
		print " * Source file: " ARGV[i]
        print " */"
}

/--.*/ {
	print substr($0, 3);
	next;
}

/-beginX/ {
	create_X++
	next
}

/-endX/ {
	create_X--
	next
}

NF == 2 {
	print "#define MIB_" $1 " " $2
	n = split($2, a, ",")
	print "#define LEN_" $1 " " n
	print "#define MIB_KEY_" $1 " " a[n]
	if (create_X) {
		print "#define MIB_" $1 "_X " $2 ",0"
		print "#define LEN_" $1 "_X " n+1
	}
	next
}


