/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/

#line 1 "rushopt.opt"
/* This file is part of GNU Rush.                  
   Copyright (C) 2008, 2009 Sergey Poznyakoff

   GNU Rush is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Rush is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Rush.  If not, see <http://www.gnu.org/licenses/>. */

#include <error.h>   
   
#line 19 "rushopt.opt"

#line 19
void print_help(void);
#line 19
void print_usage(void);
#line 74 "rushopt.opt"

#line 74
/* Option codes */
#line 74
enum {
#line 74
	_OPTION_INIT=255,
#line 74
	#line 32 "rushopt.opt"

#line 32
	OPTION_LINT,
#line 63 "rushopt.opt"

#line 63
	OPTION_SHOW_DEFAULT,
#line 74 "rushopt.opt"

#line 74
	OPTION_USAGE,
#line 74 "rushopt.opt"

#line 74
	OPTION_VERSION,

#line 74 "rushopt.opt"
	MAX_OPTION
#line 74
};
#line 74
static struct option long_options[] = {
#line 74
	#line 23 "rushopt.opt"

#line 23
	{ "debug", required_argument, 0, 'd' },
#line 30 "rushopt.opt"

#line 30
	{ "test", no_argument, 0, 't' },
#line 32 "rushopt.opt"

#line 32
	{ "lint", no_argument, 0, OPTION_LINT },
#line 37 "rushopt.opt"

#line 37
	{ "user", required_argument, 0, 'u' },
#line 55 "rushopt.opt"

#line 55
	{ "security-check", required_argument, 0, 'C' },
#line 63 "rushopt.opt"

#line 63
	{ "show-default", no_argument, 0, OPTION_SHOW_DEFAULT },
#line 74 "rushopt.opt"

#line 74
	{ "help", no_argument, 0, 'h' },
#line 74 "rushopt.opt"

#line 74
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 74 "rushopt.opt"

#line 74
	{ "version", no_argument, 0, OPTION_VERSION },

#line 74 "rushopt.opt"
	{0, 0, 0, 0}
#line 74
};
#line 74
static struct opthelp {
#line 74
        const char *opt;
#line 74
        const char *arg;
#line 74
        int is_optional;
#line 74
        const char *descr;
#line 74
} opthelp[] = {
#line 74
	#line 25 "rushopt.opt"

#line 25
	{ "-d, --debug", N_("NUMBER"), 0, N_("Set debugging level.") },
#line 33 "rushopt.opt"

#line 33
	{ "-t, --test, --lint", NULL, 0, N_("Run in test mode.") },
#line 39 "rushopt.opt"

#line 39
	{ "-u, --user", N_("NAME"), 0, N_("Supply user name in test mode.") },
#line 51 "rushopt.opt"

#line 51
	{ "-c", N_("COMMAND"), 0, N_("Execute COMMAND.") },
#line 57 "rushopt.opt"

#line 57
	{ "-C, --security-check", N_("CHECK"), 0, N_("Add or remove configuration security check.") },
#line 65 "rushopt.opt"

#line 65
	{ "--show-default", NULL, 0, N_("Show default configuration.") },
#line 74 "rushopt.opt"

#line 74
	{ NULL, NULL, 0, N_("Other options") },
#line 74 "rushopt.opt"

#line 74
	{ "-h, --help", NULL, 0, N_("Give this help list") },
#line 74 "rushopt.opt"

#line 74
	{ "--usage", NULL, 0, N_("Give a short usage message") },
#line 74 "rushopt.opt"

#line 74
	{ "--version", NULL, 0, N_("Print program version") },

#line 74 "rushopt.opt"
};
#line 19 "rushopt.opt"

#line 19
const char *program_version = "rush" " (" PACKAGE_STRING ")";
#line 19
static char doc[] = N_("rush - a restricted user shell.");
#line 19
static char args_doc[] = N_("[FILE]");
#line 19
const char *program_bug_address = "<" PACKAGE_BUGREPORT ">";
#line 19
		    
#line 19
#define DESCRCOLUMN 30
#line 19
#define RMARGIN 79
#line 19
#define GROUPCOLUMN 2
#line 19
#define USAGECOLUMN 13
#line 19
		    
#line 19
static void
#line 19
indent (size_t start, size_t col)
#line 19
{
#line 19
  for (; start < col; start++)
#line 19
    putchar (' ');
#line 19
}
#line 19
		    
#line 19
static void
#line 19
print_option_descr (const char *descr, size_t lmargin, size_t rmargin)
#line 19
{
#line 19
  while (*descr)
#line 19
    {
#line 19
      size_t s = 0;
#line 19
      size_t i;
#line 19
      size_t width = rmargin - lmargin;
#line 19

#line 19
      for (i = 0; ; i++)
#line 19
	{
#line 19
	  if (descr[i] == 0 || isspace (descr[i]))
#line 19
	    {
#line 19
	      if (i > width)
#line 19
		break;
#line 19
	      s = i;
#line 19
	      if (descr[i] == 0)
#line 19
		break;
#line 19
	    }
#line 19
	}
#line 19
      printf ("%*.*s\n", s, s, descr);
#line 19
      descr += s;
#line 19
      if (*descr)
#line 19
	{
#line 19
	  indent (0, lmargin);
#line 19
	  descr++;
#line 19
	}
#line 19
    }
#line 19
}
#line 19

#line 19
void
#line 19
print_help(void)
#line 19
{
#line 19
  unsigned i;
#line 19
  
#line 19
  printf ("%s %s [%s]... %s\n", _("Usage:"), "rush", _("OPTION"),
#line 19
	  gettext (args_doc)); 
#line 19
  if (doc && doc[0])
#line 19
    print_option_descr(gettext (doc), 0, RMARGIN);
#line 19
  putchar ('\n');
#line 19

#line 19
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 19
    {
#line 19
      unsigned n;
#line 19
      if (opthelp[i].opt)
#line 19
	{
#line 19
	  n = printf ("  %s", opthelp[i].opt);
#line 19
	  if (opthelp[i].arg)
#line 19
	    {
#line 19
	      char *cb, *ce;
#line 19
	      if (strlen (opthelp[i].opt) == 2)
#line 19
		{
#line 19
		  if (!opthelp[i].is_optional)
#line 19
		    {
#line 19
		      putchar (' ');
#line 19
		      n++;
#line 19
		    }
#line 19
		}
#line 19
	      else
#line 19
		{
#line 19
		  putchar ('=');
#line 19
		  n++;
#line 19
		}
#line 19
	      if (opthelp[i].is_optional)
#line 19
		{
#line 19
		  cb = "[";
#line 19
		  ce = "]";
#line 19
		}
#line 19
	      else
#line 19
		cb = ce = "";
#line 19
	      n += printf ("%s%s%s", cb, gettext (opthelp[i].arg), ce);
#line 19
	    }
#line 19
	  if (n >= DESCRCOLUMN)
#line 19
	    {
#line 19
	      putchar ('\n');
#line 19
	      n = 0;
#line 19
	    }
#line 19
	  indent (n, DESCRCOLUMN);
#line 19
	  print_option_descr (gettext (opthelp[i].descr), DESCRCOLUMN, RMARGIN);
#line 19
	}
#line 19
      else
#line 19
	{
#line 19
	  if (i)
#line 19
	    putchar ('\n');
#line 19
	  indent (0, GROUPCOLUMN);
#line 19
	  print_option_descr (gettext (opthelp[i].descr),
#line 19
			      GROUPCOLUMN, RMARGIN);
#line 19
	  putchar ('\n');
#line 19
	}
#line 19
    }
#line 19
  
#line 19
  putchar ('\n');
#line 19
  print_option_descr (_("Mandatory or optional arguments to long options are also mandatory or optional for any corresponding short options."), 0, RMARGIN);
#line 19
  putchar ('\n');
#line 19
  printf (_("Report bugs to %s.\n"), program_bug_address);
#line 19
}
#line 19

#line 19
void
#line 19
print_usage(void)
#line 19
{
#line 19
  unsigned i;
#line 19
  int f = 0;
#line 19
  unsigned n;
#line 19
  char buf[RMARGIN+1];
#line 19

#line 19
#define FLUSH                        do                                   {                              	  buf[n] = 0;              	  printf ("%s\n", buf);    	  n = USAGECOLUMN;         	  memset (buf, ' ', n);        }                                while (0)
#line 19
#define ADDC(c)   do { if (n == RMARGIN) FLUSH; buf[n++] = c; } while (0)
#line 19

#line 19
  n = snprintf (buf, sizeof buf, "%s %s ", _("Usage:"), "rush");
#line 19

#line 19
  /* Print a list of short options without arguments. */
#line 19
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 19
    {
#line 19
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 19
	  && opthelp[i].arg == NULL)
#line 19
	{
#line 19
	  if (f == 0)
#line 19
	    {
#line 19
	      ADDC('[');
#line 19
	      ADDC('-');
#line 19
	      f = 1;
#line 19
	    }
#line 19
	  ADDC(opthelp[i].opt[1]);
#line 19
	}
#line 19
    }
#line 19
  if (f)
#line 19
    ADDC(']');
#line 19

#line 19
  /* Print a list of short options with arguments. */
#line 19
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 19
    {
#line 19
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 19
	  && opthelp[i].arg)
#line 19
	{
#line 19
	  size_t len = 5 
#line 19
	                + strlen (opthelp[i].arg)
#line 19
			   + (opthelp[i].is_optional ? 2 : 1);
#line 19
	  if (n + len > RMARGIN) FLUSH;
#line 19
	  buf[n++] = ' '; 
#line 19
	  buf[n++] = '['; 
#line 19
	  buf[n++] = '-';
#line 19
	  buf[n++] = opthelp[i].opt[1];
#line 19
	  if (opthelp[i].is_optional)
#line 19
	    {
#line 19
	      buf[n++] = '[';
#line 19
	      strcpy (&buf[n], opthelp[i].arg);
#line 19
	      n += strlen (opthelp[i].arg);
#line 19
	      buf[n++] = ']';
#line 19
	    }
#line 19
	  else
#line 19
	    {
#line 19
	      buf[n++] = ' ';
#line 19
	      strcpy (&buf[n], opthelp[i].arg);
#line 19
	      n += strlen (opthelp[i].arg);
#line 19
	    }
#line 19
	  buf[n++] = ']';
#line 19
	}
#line 19
    }
#line 19

#line 19
  /* Print a list of long options */
#line 19
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 19
    {
#line 19
      if (opthelp[i].opt && opthelp[i].descr)
#line 19
	{
#line 19
	  size_t len;
#line 19
	  const char *longopt;
#line 19

#line 19
	  if (opthelp[i].opt[1] == '-')
#line 19
	    longopt = opthelp[i].opt;
#line 19
	  else if (opthelp[i].opt[2] == ',')
#line 19
	    longopt = opthelp[i].opt + 4;
#line 19
	  else
#line 19
	    continue;
#line 19

#line 19
	  len = 3 + strlen (longopt)
#line 19
	          + (opthelp[i].arg ? 1 + strlen (opthelp[i].arg)
#line 19
		      + (opthelp[i].is_optional ? 2 : 0) : 0);
#line 19
	  if (n + len > RMARGIN) FLUSH;
#line 19
	  buf[n++] = ' '; 
#line 19
	  buf[n++] = '['; 
#line 19
	  strcpy (&buf[n], longopt);
#line 19
	  n += strlen (longopt);
#line 19
	  if (opthelp[i].arg)
#line 19
	    {
#line 19
	      buf[n++] = '=';
#line 19
	      if (opthelp[i].is_optional)
#line 19
		{
#line 19
		  buf[n++] = '[';
#line 19
		  strcpy (&buf[n], opthelp[i].arg);
#line 19
		  n += strlen (opthelp[i].arg);
#line 19
		  buf[n++] = ']';
#line 19
		}
#line 19
	      else
#line 19
		{
#line 19
		  strcpy (&buf[n], opthelp[i].arg);
#line 19
		  n += strlen (opthelp[i].arg);
#line 19
		}
#line 19
	    }
#line 19
	  buf[n++] = ']';
#line 19
	}
#line 19
    }
#line 19
  FLUSH;
#line 19
  
#line 19
}
#line 19

#line 19
const char version_etc_copyright[] =
#line 19
  /* Do *not* mark this string for translation.  %s is a copyright
     symbol suitable for this locale, and %d is the copyright
     year.  */
#line 19
  "Copyright %s 2005, 2006, 2007, 2008 Sergey Poznyakoff";
#line 19

#line 19
void
#line 19
print_version_only(const char *program_version, FILE *stream)
#line 19
{
#line 19
	fprintf (stream, "%s\n", program_version);
#line 19
	/* TRANSLATORS: Translate "(C)" to the copyright symbol
	   (C-in-a-circle), if this symbol is available in the user's
	   locale.  Otherwise, do not translate "(C)"; leave it as-is.  */
#line 19
	fprintf (stream, version_etc_copyright, _("(C)"));
#line 19
	fputc ('\n', stream);
#line 19
}
#line 19

#line 19
void
#line 19
print_version(const char *program_version, FILE *stream)
#line 19
{
#line 19
	print_version_only(program_version, stream);
#line 19
	
#line 19
	fputs (_("License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>\nThis is free software: you are free to change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by law.\n\n"),
#line 19
	       stream);
#line 19
	
#line 19
}
#line 19

#line 74 "rushopt.opt"

#line 74


void
get_options(int argc, char *argv[])
{
    
#line 79
 {
#line 79
  int c;
#line 79

#line 79

#line 79
  while ((c = getopt_long(argc, argv, "d:tu:c:C:h",
#line 79
                          long_options, NULL)) != EOF)
#line 79
    {
#line 79
      switch (c)
#line 79
        {
#line 79
        default:
#line 79
	exit(1);
#line 79
       
#line 79
	#line 25 "rushopt.opt"
	 case 'd':
#line 25
          {
#line 25

	debug_level = atoi(optarg);
	debug_option = 1;

#line 28
             break;
#line 28
          }
#line 33 "rushopt.opt"
	 case 't': case OPTION_LINT:
#line 33
          {
#line 33

	lint_option = 1;

#line 35
             break;
#line 35
          }
#line 39 "rushopt.opt"
	 case 'u':
#line 39
          {
#line 39

	lint_option = 1;
	if (getuid())
		die(usage_error,
		    NULL,
		    _("the --user option is allowed "
		      "for the superuser only"));
	test_user_name = optarg;

#line 47
             break;
#line 47
          }
#line 51 "rushopt.opt"
	 case 'c':
#line 51
          {
#line 51

	command = optarg;

#line 53
             break;
#line 53
          }
#line 57 "rushopt.opt"
	 case 'C':
#line 57
          {
#line 57

	if (cfck_keyword(optarg))
		die(usage_error, NULL,
		    _("unknown keyword: %s"), optarg);

#line 61
             break;
#line 61
          }
#line 65 "rushopt.opt"
	 case OPTION_SHOW_DEFAULT:
#line 65
          {
#line 65

#ifdef RUSH_DEFAULT_CONFIG
	printf("%s\n", RUSH_DEFAULT_CONFIG);
	exit(0);
#else
	error(1, 0, _("No default configuration"));	
#endif

#line 72
             break;
#line 72
          }
#line 74 "rushopt.opt"
	 case 'h':
#line 74
          {
#line 74

#line 74
		print_help ();
#line 74
                exit (0);
#line 74
	 
#line 74
             break;
#line 74
          }
#line 74 "rushopt.opt"
	 case OPTION_USAGE:
#line 74
          {
#line 74

#line 74
		print_usage ();
#line 74
		exit (0);
#line 74
	 
#line 74
             break;
#line 74
          }
#line 74 "rushopt.opt"
	 case OPTION_VERSION:
#line 74
          {
#line 74

#line 74
		/* Give version */
#line 74
		print_version(program_version, stdout);
#line 74
		exit (0);
#line 74
         
#line 74
             break;
#line 74
          }

#line 79 "rushopt.opt"
        }
#line 79
    }
#line 79
 }   
#line 79

}
