/*
 * Copyright (C) 1999, 2000, 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// decorators for html

#ifndef CSSDECORATOR_H
#define CSSDECORATOR_H

#include "decorators.h"

#include <string>

using std::string;

class SpanDecorator : public TextDecorator
{
 protected:
  string span ;

 public:
  SpanDecorator( TextGenerator *t, CharTranslator *, const string &ta);
  virtual ~SpanDecorator() {}

  virtual void startDecorate();
  virtual void endDecorate();

 protected:
  void startTAG( ) const;
  void endTAG( ) const;
} ;

#endif
