(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JavaScript Bridge.
 *
 * The Initial Developer of the Original Code is
 * Sterling Bates.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Theo Lustenberger <theo@theo.ch>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** *)

(*
 *	Please send comments for enhancements, fixes, etc, to whoelse@sterlingbates.com
 *
 *	Contents: Illustrates the use of TJSBridge to connect objects to native and script code
 *						simultaneously.  Demo'd by jssamples.CreateBridge.
 *
 * 	Revision history:
 * October 30, 2003 - Initial release
 *)

unit jssamples_bridge;

interface

uses jsbridge, js15decl, Dialogs, SysUtils;

type
  TMyJSBridge = class(TJSBridge)
  private
    FInt: Integer;
    FValue: String;
  published
    property Int: Integer read FInt write FInt;
    property Value: String read FValue write FValue;

    procedure Alert(str: PBridgeChar);
    function  GetInt: Integer;
    function  GetValue: String;
    procedure SetInt(AInt: Integer);
    procedure SetValue(str: PBridgeChar);
  end;

implementation

{ TMyJSBridge }

procedure TMyJSBridge.Alert(str: PBridgeChar);
begin
  ShowMessage('alert:'#10#10 + str);
end;

function TMyJSBridge.GetInt: Integer;
begin
  Result := FInt;
end;

function TMyJSBridge.GetValue: String;
begin
  Result := FValue;
end;

procedure TMyJSBridge.SetInt(AInt: Integer);
begin
  FInt := AInt;
end;

procedure TMyJSBridge.SetValue(str: PBridgeChar);
begin
	FValue := str;
	UniqueString(FValue);
end;

end.

