// Zend Studio Toolbar for Mozilla/Firefox
// (c) 2004 Zend Technologies, All Rights Reserved
//
// This file is subject to
// the Zend Studio End User License Agreement

function zendstudiotoolbarGetZDESearch(){
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");

	try {
		return prefs.getBoolPref("ZDE_Search");
	} catch(e) {
		return true;
	}
}

function zendstudiotoolbarGetZDELocal(){
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");

	try {
		return prefs.getBoolPref("ZDE_Local");
	} catch(e) {
		return true;
	}
}

function zendstudiotoolbarGetZDEPath(){
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");

	var ZDE_Path = null;

	try {
		ZDE_Path = prefs.getCharPref("ZDE_Path");
	} catch(e) {
	}

	if (ZDE_Path == null) {
		if (window.navigator.platform.toLowerCase().indexOf("win") != -1) // windows
			document.getElementById("zendtoolbarSettingsPath").value = "c:\\program files\\zend\\bin\\zde.exe";
		else  // unix
			document.getElementById("zendtoolbarSettingsPath").value = "/usr/local/Zend/bin/ZDE";
	}

	return ZDE_Path;
}

function zendstudiotoolbarGetZDEAutodetectPort(){
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");

	var ZDE_AutodetectPort = null;

	try {
		ZDE_AutodetectPort = prefs.getCharPref("ZDE_AutodetectPort");
	} catch(e) {
	}

	if (ZDE_AutodetectPort == null) {
		ZDE_AutodetectPort = "20080";
	}

	return ZDE_AutodetectPort;
}

function zendstudiotoolbarGetZDEIP(showPrompt){
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");

	var ip = "";
	try {
		ip = prefs.getCharPref("ZDE_IP");
	} catch(e) {}
	
	// if showPrompt is true - ask the user for IP untill he gives a reasonable answer
	while( showPrompt && (ip == "" || ip == null) ){
			ip = prompt("Please enter the IP address of the computer running ZDE.\n\n**You can change this setting later from the 'settings' dialog.","");
	}
	prefs.setCharPref("ZDE_IP",ip);

	return ip;
}

function zendstudiotoolbarGetZDEPort(){
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");

	var ZDE_Port = null;

	try {
		ZDE_Port = prefs.getCharPref("ZDE_Port");
	} catch(e) {
	}

	if (ZDE_Port == null || ZDE_Port == "") {
		ZDE_Port = "10000";
	}

	return ZDE_Port;
}

function zendstudiotoolbarGetUseSSL(){
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");

	try {
		return prefs.getBoolPref("ZDE_UseSSL");
	} catch(e) {
		return false;
	}
}

function zendstudiotoolbarGetAutodetect(){
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");

	try {
		return prefs.getBoolPref("ZDE_Autodetect");
	} catch(e) {
		return true;
	}
}

function zendtoolbarSaveSettings(){
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");
	
	// General
	prefs.setBoolPref("ZDE_Search",         document.getElementById("zendtoolbarSettingsSearch").checked );
	// Debug Session Settings
	prefs.setBoolPref("ZDE_Local",          document.getElementById("zendtoolbarSettingsLocal" ).checked );
	// Zend Studio Settings
	prefs.setCharPref("ZDE_Path",           document.getElementById("zendtoolbarSettingsPath"  ).value   );
	prefs.setBoolPref("ZDE_Autodetect",     document.getElementById("zendtoolbarSettingsAutodetect").selected );
	prefs.setCharPref("ZDE_AutodetectPort", document.getElementById("zendtoolbarSettingsAutodetectPort").value );	
	prefs.setCharPref("ZDE_IP",             document.getElementById("zendtoolbarSettingsIP"    ).value   );
	prefs.setCharPref("ZDE_Port",           document.getElementById("zendtoolbarSettingsPort"  ).value   );
	prefs.setBoolPref("ZDE_UseSSL",         document.getElementById("zendtoolbarSettingsUseSSL").checked );
}


function zendtoolbarLoadSettings()
{
	document.getElementById("zendtoolbarSettings").getButton("extra2").label = "Uninstall";

	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");
	
	// General
	document.getElementById("zendtoolbarSettingsSearch"        ).checked = zendstudiotoolbarGetZDESearch();
	// Debug Session Settings
	document.getElementById("zendtoolbarSettingsLocal"         ).checked = zendstudiotoolbarGetZDELocal();
	// Zend Studio Settings
	document.getElementById("zendtoolbarSettingsPath"          ).value   = zendstudiotoolbarGetZDEPath();
	document.getElementById("zendtoolbarSettingsAutodetectPort").value   = zendstudiotoolbarGetZDEAutodetectPort();
	document.getElementById("zendtoolbarSettingsIP"            ).value   = zendstudiotoolbarGetZDEIP(false);
	document.getElementById("zendtoolbarSettingsPort"          ).value   = zendstudiotoolbarGetZDEPort();
	document.getElementById("zendtoolbarSettingsUseSSL"        ).checked = zendstudiotoolbarGetUseSSL();

	if( zendstudiotoolbarGetAutodetect() )
		document.getElementById("zendtoolbarSettingsRadio").selectedIndex = 0;
	else 
		document.getElementById("zendtoolbarSettingsRadio").selectedIndex = 1;

	toggleAutoDetect();
}

function toggleAutoDetect(){
	try {
		var ZDE_Autodetect = document.getElementById("zendtoolbarSettingsAutodetect").selected;
		
		// Display when autodetect is selected
		document.getElementById("zendtoolbarSettingsAutodetectPort"   ).disabled = !ZDE_Autodetect;
		document.getElementById("zendtoolbarSettingsAutodetectPortLbl").disabled = !ZDE_Autodetect;
		document.getElementById("zendtoolbarSettingsAutodetectTest"   ).disabled = !ZDE_Autodetect;
		
		// Hide when autodetect is selected
		document.getElementById("zendtoolbarSettingsIP"     ).disabled = ZDE_Autodetect;
		document.getElementById("zendtoolbarSettingsIPLbl"  ).disabled = ZDE_Autodetect;
		document.getElementById("zendtoolbarSettingsPort"   ).disabled = ZDE_Autodetect;
		document.getElementById("zendtoolbarSettingsPortLbl").disabled = ZDE_Autodetect;
		document.getElementById("zendtoolbarSettingsUseSSL" ).disabled = ZDE_Autodetect;
	} catch(e) { 
		alert("Zend Studio Toolbar internal error has occured.\nPlease restart your browser."); 
	}

}

function testAutoDetect(){
	try{
		// save the current value in the detect port field because getZdeSettings() reads from the prefs.
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("zendtoolbar.");

		var autoDetect = document.getElementById("zendtoolbarSettingsAutodetect").selected;
		if( ! autoDetect ) return;

		prefs.setCharPref("ZDE_AutodetectPort",document.getElementById("zendtoolbarSettingsAutodetectPort").value );
		prefs.setBoolPref("ZDE_Autodetect", autoDetect );
	
		if( !getZdeSettings() ){
			// do nothing - alert is already displayed at getZdeSettings()...
		}
		else {
			//var msg = "Auto detected settings:\n"+
			//          "Zend Studio Debug Port: "+ZDE_Port+"\n"+
			//          "Zend Studio IP Adderss: "+ZDE_IP+"\n";
			//
			//if( ZDE_UseSSL ){
			//	msg = msg+"Zend Studio will encrypt communications using SSL."
			//}
			//alert(msg);
			/* Don't display ZDE_Port & ZDE_IP since tunneling may be turned on and they will
			   make no sense to the user */
			alert("Auto Detect test was completed successfully.");
		}
	} catch(e) { alert(e); }
}
