/*

The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is jslib team code.
The Initial Developer of the Original Code is jslib team.

Portions created by jslib team are
Copyright (C) 2000 jslib team.  All
Rights Reserved.

Original Author: Pete Collins <pete@mozdev.org>
Contributor(s):
  Henrik Gemal <http://gemal.dk>
*/

/************** DUBUG ******************/
if (typeof(JS_LIB_LOADED) == "boolean") 
{

  const JS_DEBUG_LOADED     = true;
  const JS_DEBUG_FILE       = "debug.js";
  const jslibConsoleService = jslibGetService("@mozilla.org/consoleservice;1", 
                                              "nsIConsoleService");

  /****************************************************************
  * void jslibDebug(aOutString)                                   *
  * aOutString is an argument of string debug message             *
  * returns void                                                  *
  *   eg:                                                         * 
  *       var msg="Testing function";                             *
  *       jslibDebug(msg);                                        *
  *                                                               *
  *   outputs: Testing function                                   *
  ****************************************************************/

  function jslibDebug(aMsg) 
  {
    if (!JS_LIB_DEBUG)
      return; 

    if (JS_LIB_DEBUG_ALERT)
      alert(aMsg);

    jslibDumpInternal(aMsg+"\n");
  }

function jslibDebugSep (aMsg)
{
  if (!JS_LIB_DEBUG)
  return;

    jslibPrintSep(aMsg);
  }

  // print to stdout
  function jslibPrint(aMsg) { jslibDumpInternal(aMsg+"\n"); }

  // print to stdout
  function jslibPrintDebug(aMsg, aOutString) 
  {
    if (!aMsg) aMsg = "JSLIB_DEBUG: ";
    jslibDumpInternal(aMsg+" "+aOutString+"\n");
  }

  // same as above
  function jslibDebugMsg (aMsg, aOutString) { jslibPrintDebug(aMsg, aOutString); }

  // dump w/ bracket
  function jslibDebugMsgBracket (aMsg, aOutString) 
  { 
    jslibPrintDebug(aMsg, "["+aOutString+"]"); 
  }

  // print w/ bracket
  function jslibPrintBracket(aOutString) 
  {
    jslibDumpInternal("["+aOutString+"]\n");
  }

  // print message
  function jslibPrintMsg(aOutStr1, aOutStr2) 
  {
    jslibDumpInternal(aOutStr1+": "+aOutStr2+"\n");
  }

  // print line
  function jslibPrintLine() { jslibDumpInternal("\n"); }
  var jslibPrintLn = jslibPrintLine;

  function jslibPrintSep (aMsg)
  {
    jslibPrintLine();
    jslibPrint("*********************");
    jslibPrint(aMsg);
    jslibPrint("*********************");
    jslibPrintLine();
  }


  /****************************************************************
  * void jslibError(e)                                            *
  * e        - argument of results exception                      *
  * returns e.result                                              *
  *   Ex:                                                         * 
  *       jslibError(e)                                           *
  *                                                               *
  *   outputs:                                                    *
  *       -----======[ ERROR ]=====-----                          *
  *       Error in jslib.js: include:  Missing file path argument *
  *                                                               *
  *       NS_ERROR_NUMBER:   NS_ERROR_XPC_NOT_ENOUGH_ARGS         *
  *       ------------------------------                          *
  *                                                               *
  ****************************************************************/

  function jslibError(e) 
  {
    if (jslibTypeIsStr(e))
      return jslibErrorMsg(e);

    var rv = null;
    var errMsg="";
    if (jslibTypeIsObj(e)) {
      var m, n, r, l, ln, fn = "";
      try {
        rv = -e.result;
        m  = e.message;
        fn = e.filename;
        l  = e.location; 
        ln = l.lineNumber; 
      } catch (e) {}
      errMsg+="FileName:          "+fn+"\n"           +
              "Result:            "+rv+"\n"           +
              "Message:           "+m+"\n"            +
              "LineNumber:        "+ln+"\n";
    }

    errMsg = "\n-----======[ jsLib ERROR ]=====-----\n" + errMsg;
    errMsg += "-------------------------------------\n";

    jslibDebug(errMsg);

    return rv;
  }

  function jslibErrorWarn (e)
  {
    jslibDebug("jsLib warn: "+e);
    return null;
  }

  function jslibErrorMsg (e, comment)
  {
    typeof(comment) == "string" ? jslibDebugMsgBracket(e, comment) : jslibDebug(e);
    return -jslibRes[e];
  }

  function jslibPrintProperties (aObj)
  {
    for (var list in aObj)
      jslibPrint(list);
  }

  function jslibGetProperties (aObj)
  {
    var out = new Array ();
    for (var list in aObj)
      out.push(list);

    return out;
  }

  function jslibPrintType (aObj)
  {
      jslibPrint(typeof(aObj));
  }

  function jslibPrintTypeWName (aName, aObj)
  {
      jslibPrint("Name: "+aName+" JSType: "+typeof(aObj));
  }

  function jslibTypeIsObj (aType) 
  { 
    return (aType && typeof(aType) == "object"); 
  }
  function jslibTypeIsFunc (aType) 
  { 
    return (aType && typeof(aType) == "function"); 
  }
  function jslibTypeIsStr (aType) 
  { 
    return (aType && typeof(aType) == "string"); 
  }
  function jslibTypeIsNum (aType) 
  { 
    return (aType && typeof(aType) == "number"); 
  }
  function jslibTypeIsUndef (aType) 
  { 
    return (aType && typeof(aType) == "undefined"); 
  }

  var jslibTypeIsObject    = jslibTypeIsObj;
  var jslibTypeIsFunction  = jslibTypeIsFunc;
  var jslibTypeIsString    = jslibTypeIsStr;
  var jslibTypeIsNumber    = jslibTypeIsNum;
  var jslibTypeIsUndefined = jslibTypeIsUndef;

  // possible undefined types -  use w/ typeof 
  // eg: 
  //   jslibUTypeIsObj(typeof(window));

  function jslibUTypeIsObj   (aType) { return (aType == "object"); }
  function jslibUTypeIsFunc  (aType) { return (aType == "function"); }
  function jslibUTypeIsStr   (aType) { return (aType == "string"); }
  function jslibUTypeIsNum   (aType) { return (aType == "number"); }
  function jslibUTypeIsUndef (aType) { return (aType == "undefined"); }

  var jslibUTypeIsObject    = jslibUTypeIsObj;
  var jslibUTypeIsFunction  = jslibUTypeIsFunc;
  var jslibUTypeIsString    = jslibUTypeIsStr;
  var jslibUTypeIsNumber    = jslibUTypeIsNum;
  var jslibUTypeIsUndefined = jslibUTypeIsUndef;

  function jslibDumpConsole (aMsg)
  {
    jslibConsoleService.logStringMessage(aMsg);
  }

  function jslibDumpInternal (aMsg)
  {
    dump(aMsg);
    jslibDumpConsole(aMsg);
  }

  function jslibLoadMsg (aFileName)
  {
    jslibDebug("*** load: "+aFileName+" OK");
  }

  function jslibErrorLookUp (aErrorNum)
  {
    var errCode, rv = null;
    if (jslibTypeIsNum(aErrorNum)) {
      errCode = Math.abs(aErrorNum);
      for (var list in jslibRes)
        if(errCode == jslibRes[list]) {
          rv = list;
          break;
        }
    } else if (jslibTypeIsString(aErrorNum)) {
      errCode = aErrorNum;
      if (errCode in jslibRes) 
        rv = -jslibRes[errCode];
    }

    return rv;
  }

  // Welcome message
  jslibLoadMsg(JS_DEBUG_FILE);

if (JS_LIB_VERBOSE)
    jslibDebug(JS_LIB_HELP);
  jslibDebugSep("JS_LIB DEBUG IS ON");

} 
 
                                                                                                    

