/*** -*- Mode: Javascript; tab-width: 2;
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/
                                                                                                    
Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.
                                                                                                    
The Original Code is jslib code.
The Initial Developer of the Original Code is jslib team.
                                                                                                    
Portions created by jslib team are
Copyright (C) 2000 jslib team.  All
Rights Reserved.
                                                                                                    
Contributor(s): Rajeev J Sebastian <rajeev_jsv@yahoo.com)> (original author)
                                                                                                    

MultipartRequest
  This object is used to represent the MultipartRequest
  Create any (any number, any combination, any order)
    of the Parts that you would like to use.
  Add them to MultipartRequest using mpr.put(part)
  Pass the MultipartRequest to the HTTP object
    just like other Request objects

FilePart
  This Part is used to pass a file through the body of
  the request
    filepart.setFile(<a name>, <a jslib File obj>, <content type>);

TextPart
  This Part is used to pass a long text through the body
  of the request. content-type can be used to provide an
  interpretation of text like text/plain, text/xml, text/html
    textpart.setPart(<a name>, <a string>, <content type>);

URLParametersPart
  This Part is used to pass urlencoded parameters through
  the request url of the request
    urlparampart.put(<parameter key>, <parameter value>);

BodyParametersPart
  This Part is used to pass urlencoded parameters through
  the body of the request.
    bodyparampart.put(<parameter key>, <parameter value>);
  You can also set a name for the part using
    bodyparampart.setName(<namestring>);

*************************************/


if (typeof(JS_LIB_LOADED)=='boolean') {

const JS_MULTIPARTREQUEST_FILE     = "multipartRequest.js";
const JS_MULTIPARTREQUEST_LOADED   = true;

const boundary = "--i-N-5-4-N-3-k-4-n-3-------------314159265358979323846";
const delimiter = "\r\n--"+boundary+"\r\n" ;
const close_delim = "\r\n--"+boundary+"--" ;

//accepts several parameters, which are placed in the body
//of the request

function Parts()
{
  this._array = new Array();
}

Parts.prototype = {
  _iterind: 0,

  put: function(part)
  {
    this._array.push(part);
  },

  find: function(type)
  {
    var list = new Parts();
    this.resetIterator();
    while( this.hasMoreElements() )
    {
      var param = this.getNext();
      if( param.type == type ) list.put(param);
    }
    return list;
  },

  //iterator
  resetIterator: function()
  {
    this._iterind = 0;
  },

  hasMoreElements: function()
  {
    if( this._iterind < this._array.length - 1 ) return true;
    else return false;
  },

  next: function()
  {
    return this._array[_iterind++];
  }
}

function MultipartRequest(baseuri)
{
  this.baseu = baseuri;
  this.parts = new Parts();
}

MultipartRequest.prototype =
{
  baseu: null,
  method: "POST",
  parts: null,

  put: function(part)
  {
    this.parts.put(part);
    return this;
  },

  getRequestUri: function() {
    var uri = this.baseu;
    uri +="?";
    while( this.parts.hasMoreElements() ) {
      var part = this.parts.getNext();
        var params = part._getRequestUriParams();
        if( params == null ) continue;
        params.resetIterator();
        while(params.hasMoreElements()) {
          var head = params.getNext();
          uri += head.key +"="+head.value+"&";
        }
      }
    }
    uri = uri.slice(0,-1); //remove the last & or last ?
    return uri;
  },

  getRequestMethod: function() {
    return this.method;
  },

  setRequestHeaders: function(xhr) {
    while( this.parts.hasMoreElements() ) {
      var part = this.parts.getNext();
      if( typeof(part) == "URLParameterPart" ) {
        var phead = part._getRequestHeaders();
        if( params == null ) continue;
        phead.resetIterator();
        while(phead.hasMoreElements()) {
          var head = phead.getNext();
          xhr.setRequestHeader(head.key,head.value);
        }
      }
    }
    xhr.setRequestHeader("Content-type","multipart/form-data; boundary="+boundary);
  },

  getBody: function() {
    var strinsC = Components.classes["@mozilla.org/io/string-input-stream;1"].
    var multiplexstrmC = Components.classes["@mozilla.org/io/multiplex-input-stream;1"];
    var mimestrmC = Components.classes["@mozilla.org/network/mime-input-stream;1"].

    var delimstrm = strinsC.createInstance( Components.interfaces.nsIStringInputStream );
    delimstrm.setData(delimiter,-1);

    var multiplexstrm = multiplexstrmC.createInstance( Components.interfaces.nsIMultiplexInputStream );
    multiplexstrm.appendStream(delimstrm);

    this.parts.resetIterator();
    //for each part

    while( this.parts.hasMoreElements() ) {
      var part = this.parts.getNext();

      var mimestrm = mimestrmC.createInstance( Components.interfaces.nsIMIMEInputStream );
      mimestrm.addContentLength = true;

      var body = part._getBody();
      if( body == null ) continue;
      var phead = part._getRequestHeaders();
      phead.resetIterator();
      while(phead.hasMoreElements()) {
        var head = phead.getNext();
        mimestrm.addHeader(head.key,head.value);
      }
      mimestrm.setData(body);
      multiplexstrm.appendStream(mimestrm);
      //is it necessary to create a new stream ?
      //leave it in anyway
      delimstrm = strinsC.createInstance( Components.interfaces.nsIStringInputStream );
      delimstrm.setData(delimiter,-1);
      multiplexstrm.appendStream(delimstrm);
    }

    var cdelimstrm = strinsC.createInstance( Components.interfaces.nsIStringInputStream );
    cdelimstrm.setData(close_delim,-1);

    multiplexstrm.appendStream(cdelimstrm);

    return multiplexstrm;
  }
}
jslibDebug('*** load: '+JS_MULTIPARTREQUEST_FILE+' OK');

} // END BLOCK JS_LIB_LOADED CHECK

// If jslib base library is not loaded, dump this error.
else {
   dump("JS_BASE library not loaded:\n"
        + " \tTo load use: chrome://jslib/content/jslib.js\n"

        + " \tThen: include(jslib_multipartrequest);\n\n");

};
