/*** -*- Mode: Javascript; tab-width: 2;
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/
                                                                                                    
Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.
                                                                                                    
The Original Code is jslib code.
The Initial Developer of the Original Code is jslib team.
                                                                                                    
Portions created by jslib team are
Copyright (C) 2000 jslib team.  All
Rights Reserved.
                                                                                                    
Contributor(s): Rajeev J Sebastian <rajeev_jsv@yahoo.com)> (original author)
                                                                                                    
*************************************/


//accepts several parameters, which are placed in the body
//of the request

if (typeof(JS_LIB_LOADED)=='boolean') {

const JS_POSTREQUEST_FILE     = "postRequest.js";
const JS_POSTREQUEST_LOADED   = true;

if (typeof(JS_DICTIONARY_LOADED)!='boolean')
  include(jslib_dictionary);

function PostRequest(baseuri){
  this.baseu = baseuri;
  this.parameters = new Dictionary();
}

PostRequest.prototype = {
  baseu: null,
  method: "POST",
  parameters: null,
  cnttype: null,
  cntenc: null,

  put: function(key,value) {
    this.parameters.put(key,value);
    return this;
  },

  getRequestUri: function() {
    var uri = "";
    uri += this.baseu;
    return uri;
  },

  getRequestMethod: function() {
    return this.method;
  },

  setRequestHeaders: function(p) {
    p.setRequestHeader("Content-type","application/x-www-form-urlencoded");
  },

  getBody: function() {
    var uri = "";
    this.parameters.resetIterator();
    while( this.parameters.hasMoreElements() )
    {
      var param = this.parameters.next();
      if( this.parameters.hasMoreElements() )
        uri+= escape(param.key)+"="+escape(param.value)+"&";
      else {
        uri+= escape(param.key)+"="+escape(param.value);
        break;
      }
    }
    return uri;
  }
}

jslibDebug('*** load: '+JS_POSTREQUEST_FILE+' OK');

} // END BLOCK JS_LIB_LOADED CHECK

// If jslib base library is not loaded, dump this error.
else {
   dump("JS_BASE library not loaded:\n"
        + " \tTo load use: chrome://jslib/content/jslib.js\n"

        + " \tThen: include(jslib_postrequest);\n\n");

};
