using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;

namespace SmartSync
{
    public class AppSettings
    {
        private static Settings data = new Settings();
        public static String SETTINGSFILE = "settings.xml";

        public static String getStgFile()
        {
            return getAppDir() + "\\" + SETTINGSFILE;
        }

        public static String getDefaultFolder()
        {
            return Environment.GetEnvironmentVariable("USERPROFILE");
        }

        private static bool createFolders()
        {
            try
            {
                String appDir = getDefaultFolder() + "\\SmartSync";
                if (System.IO.Directory.Exists(appDir) == false)
                    System.IO.Directory.CreateDirectory(appDir);
                return true;
            }
            catch (Exception e)
            {
                return false;
            }
        }

        public static String getAppDir()
        {
            createFolders();
            //Environment.SpecialFolder.LocalApplicationData
            String appDir = getDefaultFolder() + "\\SmartSync";
            return appDir;
        }

        private static void LoadSettings()
        {
            try
            {
                System.IO.StreamReader input = new System.IO.StreamReader(getStgFile());
                XmlSerializer ser = new XmlSerializer(typeof(Settings));
                data = (Settings)ser.Deserialize(input);
            }
            catch (Exception ex)
            {
                data.firstSync = true;
            }
        }

        private static void SaveSettings()
        {
            StringBuilder sb = new StringBuilder();
            System.IO.StringWriter output = new System.IO.StringWriter(sb);
            XmlSerializer ser = new XmlSerializer(typeof(Settings));
            ser.Serialize(output, data);
            String xmlData = sb.ToString();
            System.IO.StreamWriter writer = new System.IO.StreamWriter(getStgFile());
            writer.Write(xmlData);
            writer.Flush();
            writer.Close();
        }

        public static bool firstSync
        {
            get
            {
                LoadSettings();
                return data.firstSync;
            }
            set
            {
                data.firstSync = value;
                SaveSettings();
            }
        }

    }

    [XmlRoot("Settings")]
    public class Settings
    {
        [XmlElement("firstSync")]
        public bool firstSync = true;
    }
}
