namespace CoreSync
{
	public ref class ObjectStore : System::Object
	{
	private:
		static int pvt_iInitCount=0;
	public:
		/// <summary>
		/// Initialize Ce Remote API (RAPI). Calls CeRapiInit().
		/// Return True if the function succeed, False otherwise.
		/// If Init has already been called, a counter will be incremented.
		///   To UnInitialize RAPI properly, you'll have to make the same number of UnInit calls.
		/// </summary>
		static bool Init();
		/// <summary>
		/// UnInitialize Ce Remote API (RAPI). Calls CeRapiUninit().
		/// If Init has been called more than one time, this function will decrement a counter.
		///   When the counter will reach 0, CeRapiUninit() will be called.
		/// </summary>
		static void UnInit();

		/// <summary>
		/// Returns the number of contacts on the PocketPC. This function is used by Contacts.
		/// </summary>
		static int getContactsCount();
		/// <summary>
		/// Returns a collection of Contacts which represents all the Contacts on PocketPC.
		/// </summary>
		static Contacts ^getContacts();
		/// <summary>
		/// Return the contact specified by the supplied OID.
		/// It is not suggested to use this funcion to retrieve multiple contacts, since it is not optimized for multiple requests.
		/// </summary>
		static Contact ^getContact(int OID);
		/// <summary>
		/// Put a Contact on the PocketPC. Return the OID of the contact added or modified.
		/// If the Contact.OID attribute is 0, the contact will be added.
		/// If the Contact.OID attribute is not 0, the contact will be modified.
		/// </summary>
		static int putContact(Contact ^oContact);
		/// <summary>
		/// Remove the contact specified by OID from the PocketPC. This function is used by Contacts.
		/// </summary>
		static bool removeContact(int OID);
		/// <summary>
		/// Allow access to a specified database on the PocketPC. This function can be used to access and debug databases.
		/// </summary>
		static Database ^getDatabase(System::String ^sDBName);
	};

}
