 
/****************************************************************************
 *  (c) Copyright 2007 Wi-Fi Alliance.  All Rights Reserved
 *
 *
 *  LICENSE
 *
 *  License is granted only to Wi-Fi Alliance members and designated
 *  contractors ($B!H(BAuthorized Licensees$B!I(B)..AN  Authorized Licensees are granted
 *  the non-exclusive, worldwide, limited right to use, copy, import, export
 *  and distribute this software:
 *  (i) solely for noncommercial applications and solely for testing Wi-Fi
 *  equipment; and
 *  (ii) solely for the purpose of embedding the software into Authorized
 *  Licensee$B!G(Bs proprietary equipment and software products for distribution to
 *  its customers under a license with at least the same restrictions as
 *  contained in this License, including, without limitation, the disclaimer of
 *  warranty and limitation of liability, below..AN  The distribution rights
 *  granted in clause
 *  (ii), above, include distribution to third party companies who will
 *  redistribute the Authorized Licensee$B!G(Bs product to their customers with or
 *  without such third party$B!G(Bs private label. Other than expressly granted
 *  herein, this License is not transferable or sublicensable, and it does not
 *  extend to and may not be used with non-Wi-Fi applications..AN  Wi-Fi Alliance
 *  reserves all rights not expressly granted herein..AN 
 *.AN 
 *  Except as specifically set forth above, commercial derivative works of
 *  this software or applications that use the Wi-Fi scripts generated by this
 *  software are NOT AUTHORIZED without specific prior written permission from
 *  Wi-Fi Alliance.
 *.AN 
 *  Non-Commercial derivative works of this software for internal use are
 *  authorized and are limited by the same restrictions; provided, however,
 *  that the Authorized Licensee shall provide Wi-Fi Alliance with a copy of
 *  such derivative works under a perpetual, payment-free license to use,
 *  modify, and distribute such derivative works for purposes of testing Wi-Fi
 *  equipment.
 *.AN 
 *  Neither the name of the author nor "Wi-Fi Alliance" may be used to endorse
 *  or promote products that are derived from or that use this software without
 *  specific prior written permission from Wi-Fi Alliance.
 *
 *  THIS SOFTWARE IS PROVIDED BY WI-FI ALLIANCE "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A.AN PARTICULAR PURPOSE,
 *  ARE DISCLAIMED. IN NO EVENT SHALL WI-FI ALLIANCE BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, THE COST OF PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE) ARISING IN ANY WAY OUT OF
 *  THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. ******************************************************************************
 */

/* 
 *   File: wfa_cs.c -- configuration and setup
 *   This file contains all implementation for the dut setup and control 
 *   functions, such as network interfaces, ip address and wireless specific
 *   setup with its supplicant.
 *
 *   The current implementation is to show how these functions
 *   should be defined in order to support the Agent Control/Test Manager 
 *   control commands. To simplify the current work and avoid any GPL licenses,
 *   the functions mostly invoke shell commands by calling linux system call,
 *   system("<commands>"). 
 *
 *   It depends on the differnt device and platform, vendors can choice their
 *   own ways to interact its systems, supplicants and process these commands
 *   such as using the native APIs.
 *
 *   Revision History:
 *        2006/03/10  -- initially created by qhu
 *        2006/06/01  -- BETA Release by qhu
 *        2006/06/13  -- 00.02 Release by qhu
 *        2006/06/30  -- 00.10 Release by qhu
 *        2006/07/10  -- 01.00 Release by qhu
 *        2006/09/01  -- 01.05 Release by qhu
 *        2006/10/26  -- 01.06 Released by qhu
 *                       replace hardcoded buf size with macro
 *        2006/12/02  -- bugs: 1. fixes incorrect order of getipconfig.sh
 *                                input parameters reported by p.schwann
 *                             2. will add a new network for wap_cli command
 *                                in case the network id 0 not present,
 *                                recommended by c.benson
 *                                the solution is to reimplement with calling
 *                                native C API
 *        2007/01/11  -- 01.10 released by qhu
 *        2007/02/15  -- WMM Extension Beta released by qhu, mkaroshi
 *        2007/03/18  -- add file close statements
 *        2007/03/21  -- rename the file to avoid the confusion.
 *        2007/03/30  -- 01.40 WPA2 and Official WMM Beta Release by qhu
 *        2007/04/20  -- 02.00 WPA2 and Official WMM Release by qhu
 *        2007/08/15 --  02.10 WMM-Power Save release by qhu
 *        2007/10/10 --  02.20 Voice SOHO beta -- qhu
 *        2007/11/07 --  02.30 Voice HSO -- qhu
 *        2007/12/10 --  02.32 Add a function to upload test results.
 *        2008/01/03 --  02.34 Support the result upload command.
 *        2008/03/12 --  02.41 Bug #16, incorrect file descriptor used. Change 
 *                       the "tmpfile" to "tmpfd" and a few places. Make a macro
 *                       WFA_STAUT_IF in file "inc/wfa_cs.h" for WLAN interface
 *                       name in the function "wfaDeviceListIF()
 *                      
 *                       Not A Bug. Put back to the function from 
 *                       wfaSetEncryption1() to wfaSetEncryption() for 
 *                       supporting WEP. Porting could select which should be 
 *                       used according to WEP support or not.
 *                        
 *        
 */ 
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <linux/types.h>
#include <linux/socket.h>
#include <poll.h>

#include "wfa_portall.h"
#include "wfa_debug.h"
#include "wfa_ver.h"
#include "wfa_main.h"
#include "wfa_types.h"
#include "wfa_ca.h"
#include "wfa_tlv.h"
#include "wfa_sock.h"
#include "wfa_tg.h"
#include "wfa_cmds.h"
#include "wfa_rsp.h"
#include "wfa_utils.h"
#ifdef WFA_WMM_PS_EXT
#include "wfa_wmmps.h"
#endif

#if 1 // by bbelief
#include "wpa_helpers.h"
#include "wfa_p2p.h"
#endif

#define CERTIFICATES_PATH    "/etc/wpa_supplicant"

/* Some device may only support UDP ECHO, activate this line */
//#define WFA_PING_UDP_ECHO_ONLY 1

extern unsigned short wfa_defined_debug;
int wfaExecuteCLI(char *CLI);

/* Since the two definitions are used all over the CA function */
char gCmdStr[WFA_CMD_STR_SZ];
dutCmdResponse_t gGenericResp;
int wfaTGSetPrio(int sockfd, int tgClass);
void create_apts_msg(int msg, unsigned int txbuf[],int id);

extern char e2eResults[];
//extern char *e2eResults;
FILE *e2efp = NULL;
int chk_ret_status()
{
    char *ret = getenv(WFA_RET_ENV);

    if(*ret == '1')
       return TRUE;
    else
       return FALSE;
}

/*
 * agtCmdProcGetVersion(): response "ca_get_version" command to controller
 *  input:  cmd --- not used
 *          valLen -- not used
 *  output: parms -- a buffer to store the version info response.
 */
int agtCmdProcGetVersion(int len, BYTE *parms, int *respLen, BYTE *respBuf)
{
    dutCmdResponse_t *getverResp = &gGenericResp;

    DPRINT_INFO(WFA_OUT, "entering agtCmdProcGetVersion ...\n");

    getverResp->status = STATUS_COMPLETE;
    wSTRNCPY(getverResp->cmdru.version, WFA_SYSTEM_VER, WFA_VERNAM_LEN);

    wfaEncodeTLV(WFA_GET_VERSION_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)getverResp, respBuf);

    *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);

    return TRUE;
}

/*
 * wfaStaAssociate():
 *    The function is to force the station wireless I/F to re/associate 
 *    with the AP.
 */
int wfaStaAssociate(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCommand_t *assoc = (dutCommand_t *)caCmdBuf;
   char *ifname = assoc->intf;
   dutCmdResponse_t *staAssocResp = &gGenericResp;
   // WPS stations only	
   caStaAssociate_t *assoc_wps = (caStaAssociate_t *)&(assoc->cmdsu.wps_assoc);

   DPRINT_INFO(WFA_OUT, "entering wfaStaAssociate ...\n");
   /* use 'ifconfig' command to bring down the interface (linux specific) */
   sprintf(gCmdStr, "ifconfig %s down", ifname);
   system(gCmdStr);


   // WPS stations
	DPRINT_INFO(WFA_OUT, "The WPS option is : %d \n",assoc_wps->wps);		
   /* use 'ifconfig' command to bring up the interface (linux specific) */
   sprintf(gCmdStr, "ifconfig %s up", ifname);
   system(gCmdStr);

   /* 
    *  use 'wpa_cli' command to force a 802.11 re/associate 
    *  (wpa_supplicant specific) 
    */
   sprintf(gCmdStr, "wpa_cli -i%s reassociate", ifname);
   system(gCmdStr);

   /*
    * Then report back to control PC for completion.
    * This does not have failed/error status. The result only tells
    * a completion.
    */
   staAssocResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_ASSOCIATE_RESP_TLV, 4, (BYTE *)staAssocResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE; 
}

/*
 * wfaStaReAssociate():
 *    The function is to force the station wireless I/F to re/associate 
 *    with the AP.
 */
int wfaStaReAssociate(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCommand_t *assoc = (dutCommand_t *)caCmdBuf;
   char *ifname = assoc->intf;
   dutCmdResponse_t *staAssocResp = &gGenericResp;

   DPRINT_INFO(WFA_OUT, "entering wfaStaAssociate ...\n");
   /* use 'ifconfig' command to bring down the interface (linux specific) */
   sprintf(gCmdStr, "ifconfig %s down", ifname);
   system(gCmdStr);

   /* use 'ifconfig' command to bring up the interface (linux specific) */
   sprintf(gCmdStr, "ifconfig %s up", ifname);

   /* 
    *  use 'wpa_cli' command to force a 802.11 re/associate 
    *  (wpa_supplicant specific) 
    */
   sprintf(gCmdStr, "wpa_cli -i%s reassociate", ifname);
   system(gCmdStr);

   /*
    * Then report back to control PC for completion.
    * This does not have failed/error status. The result only tells
    * a completion.
    */
   staAssocResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_ASSOCIATE_RESP_TLV, 4, (BYTE *)staAssocResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE; 
}

/*
 * wfaStaIsConnected():
 *    The function is to check whether the station's wireless I/F has 
 *    already connected to an AP.
 */
int wfaStaIsConnected(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCommand_t *connStat = (dutCommand_t *)caCmdBuf;
   dutCmdResponse_t *staConnectResp = &gGenericResp;
   char *ifname = connStat->intf;
   FILE *tmpfile = NULL;
   char result[32];


   DPRINT_INFO(WFA_OUT, "Entering isConnected ...\n"); 

#if 1
    if (get_wpa_status(ifname, "wpa_state", result, sizeof(result)) < 0)
            return -2;
   DPRINT_INFO(WFA_OUT, "wpa_state : %s\n", result); 
   
    if(strcmp(result, "COMPLETED") == 0)
        staConnectResp->cmdru.connected = 1;
   else
      staConnectResp->cmdru.connected = 0;

#else
#ifdef WFA_NEW_CLI_FORMAT
   sprintf(gCmdStr, "wfa_chkconnect %s\n", ifname); 
   system(gCmdStr);

   if(chk_ret_status() == TRUE)
      staConnectResp->cmdru.connected = 1;
   else
      staConnectResp->cmdru.connected = 0;
#else
   /*
    * use 'wpa_cli' command to check the interface status
    * none, scanning or complete (wpa_supplicant specific)
    */
   sprintf(gCmdStr, "/sbin/wpa_cli -i%s status | grep ^wpa_state= | cut -f2- -d= > /tmp/.isConnected", ifname);
   system(gCmdStr);

   /*
    * the status is saved in a file.  Open the file and check it.
    */
   tmpfile = fopen("/tmp/.isConnected", "r+");
   if(tmpfile == NULL)
   {
      staConnectResp->status = STATUS_ERROR;
      wfaEncodeTLV(WFA_STA_IS_CONNECTED_RESP_TLV, 4, (BYTE *)staConnectResp, respBuf);
      *respLen = WFA_TLV_HDR_LEN + 4;

      DPRINT_ERR(WFA_ERR, "file open failed\n");
      return FALSE;
   }

   fscanf(tmpfile, "%s", result);

   if(strncmp(result, "COMPLETED", 9) == 0)
      staConnectResp->cmdru.connected = 1;
   else
      staConnectResp->cmdru.connected = 0;
#endif
#endif

   /*
    * Report back the status: Complete or Failed.
    */
   staConnectResp->status = STATUS_COMPLETE;
   
   wfaEncodeTLV(WFA_STA_IS_CONNECTED_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)staConnectResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);

   return TRUE;
}

/*
 * wfaStaGetIpConfig():
 * This function is to retriev the ip info including
 *     1. dhcp enable
 *     2. ip address
 *     3. mask 
 *     4. primary-dns
 *     5. secondary-dns
 *
 *     The current implementation is to use a script to find these information
 *     and store them in a file. 
 */
int wfaStaGetIpConfig(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
    int slen, ret, i = 0;
    dutCommand_t *getIpConf = (dutCommand_t *)caCmdBuf;
    dutCmdResponse_t *ipconfigResp = &gGenericResp; 
    char *ifname = getIpConf->intf;
    caStaGetIpConfigResp_t *ifinfo = &ipconfigResp->cmdru.getIfconfig;

    FILE *tmpfd;
    char string[256];
    char *str;

    /*
     * check a script file (the current implementation specific)
     */
    ret = access("/usr/local/sbin/getipconfig.sh", F_OK);
    if(ret == -1)
    {
       ipconfigResp->status = STATUS_ERROR;
       wfaEncodeTLV(WFA_STA_GET_IP_CONFIG_RESP_TLV, 4, (BYTE *)ipconfigResp, respBuf);   
       *respLen = WFA_TLV_HDR_LEN + 4;

       DPRINT_ERR(WFA_ERR, "file not exist\n");
       return FALSE; 

    }

    strcpy(ifinfo->dns[0], "0");
    strcpy(ifinfo->dns[1], "0");
    
    /*
     * Run the script file "getipconfig.sh" to check the ip status 
     * (current implementation  specific). 
     * note: "getipconfig.sh" is only defined for the current implementation
     */
    sprintf(gCmdStr, "getipconfig.sh /tmp/ipconfig.txt %s\n", ifname); 

    system(gCmdStr);

    /* open the output result and scan/retrieve the info */
    tmpfd = fopen("/tmp/ipconfig.txt", "r+");

    if(tmpfd == NULL)
    {
      ipconfigResp->status = STATUS_ERROR;
      wfaEncodeTLV(WFA_STA_GET_IP_CONFIG_RESP_TLV, 4, (BYTE *)ipconfigResp, respBuf);
      *respLen = WFA_TLV_HDR_LEN + 4;

      DPRINT_ERR(WFA_ERR, "file open failed\n");
      return FALSE;
    }

    for(;;)
    {
        if(fgets(string, 256, tmpfd) == NULL)
           break; 

        /* check dhcp enabled */
        if(strncmp(string, "dhcpcli", 7) ==0)
        {
            str = strtok(string, "=");
            str = strtok(NULL, "=");
            if(str != NULL)
               ifinfo->isDhcp = 1;
            else
               ifinfo->isDhcp = 0;
        }

        /* find out the ip address */
        if(strncmp(string, "ipaddr", 6) == 0)
        {
            str = strtok(string, "=");
            str = strtok(NULL, " ");
            if(str != NULL)
            {
               wSTRNCPY(ifinfo->ipaddr, str, 15);
               ifinfo->ipaddr[15]='\0';
            }
            else
               wSTRNCPY(ifinfo->ipaddr, "none", 15);
        }

        /* check the mask */
        if(strncmp(string, "mask", 4) == 0)
        {
            char ttstr[16];
            char *ttp = ttstr;

            str = strtok_r(string, "=", &ttp);
            if(*ttp != '\0')
            {
               strcpy(ifinfo->mask, ttp);
               slen = strlen(ifinfo->mask);
               ifinfo->mask[slen-1] = '\0';
            }
            else
               strcpy(ifinfo->mask, "none");
        }

        /* find out the dns server ip address */
        if(strncmp(string, "nameserv", 8) == 0)
        {
            char ttstr[16];
            char *ttp = ttstr;
            
            str = strtok_r(string, " ", &ttp);
            if(str != NULL && i < 2)
            {
               strcpy(ifinfo->dns[i], ttp);
               slen = strlen(ifinfo->dns[i]);
               ifinfo->dns[i][slen-1] = '\0';
            }
            else
               strcpy(ifinfo->dns[i], "none");

            i++;
        }
     }

     /*
      * Report back the results
      */
     ipconfigResp->status = STATUS_COMPLETE;
     wfaEncodeTLV(WFA_STA_GET_IP_CONFIG_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)ipconfigResp, respBuf);   

     *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);

#if 0
     DPRINT_INFO(WFA_OUT, "%i %i %s %s %s %s %i\n", ipconfigResp->status, 
        ifinfo->isDhcp, ifinfo->ipaddr, ifinfo->mask, 
            ifinfo->dns[0], ifinfo->dns[1], *respLen);
#endif

     fclose(tmpfd);
     return TRUE;
}

/*
 * wfaStaSetIpConfig():
 *   The function is to set the ip configuration to a wireless I/F.
 *   1. IP address
 *   2. Mac address
 *   3. default gateway
 *   4. dns nameserver (pri and sec).  
 */
int wfaStaSetIpConfig(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCommand_t *setIpConf = (dutCommand_t *)caCmdBuf;
   caStaSetIpConfig_t *ipconfig = &setIpConf->cmdsu.ipconfig;
   dutCmdResponse_t *staSetIpResp = &gGenericResp;

   DPRINT_INFO(WFA_OUT, "entering wfaStaSetIpConfig ...\n");

   /*
    * Use command 'ifconfig' to configure the interface ip address, mask.
    * (Linux specific).
    */
   sprintf(gCmdStr, "/sbin/ifconfig %s %s netmask %s > /dev/null 2>&1 ", ipconfig->intf, ipconfig->ipaddr, ipconfig->mask);
   system(gCmdStr);

   /* use command 'route add' to set set gatewway (linux specific) */ 
   if(ipconfig->defGateway[0] != '\0')
   {
      sprintf(gCmdStr, "/sbin/route add default gw %s > /dev/null 2>&1", ipconfig->defGateway);
      system(gCmdStr);
   }

   /* set dns (linux specific) */
   sprintf(gCmdStr, "cp /etc/resolv.conf /tmp/resolv.conf.bk");
   system(gCmdStr);
   sprintf(gCmdStr, "echo nameserv %s > /etc/resolv.conf", ipconfig->pri_dns);
   system(gCmdStr);
   sprintf(gCmdStr, "echo nameserv %s >> /etc/resolv.conf", ipconfig->sec_dns);
   system(gCmdStr);

   /*
    * report status
    */
   staSetIpResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_IP_CONFIG_RESP_TLV, 4, (BYTE *)staSetIpResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

/*
 * wfaStaVerifyIpConnection():
 * The function is to verify if the station has IP connection with an AP by
 * send ICMP/pings to the AP.
 */ 
int wfaStaVerifyIpConnection(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCommand_t *verip = (dutCommand_t *)caCmdBuf;
   dutCmdResponse_t *verifyIpResp = &gGenericResp;

#ifndef WFA_PING_UDP_ECHO_ONLY
   char strout[64], *pcnt;
   FILE *tmpfile;
   
   DPRINT_INFO(WFA_OUT, "Entering wfaStaVerifyIpConnection ...\n");

   /* set timeout value in case not set */
   if(verip->cmdsu.verifyIp.timeout <= 0)
   {
        verip->cmdsu.verifyIp.timeout = 10;
   }
   
   /* execute the ping command  and pipe the result to a tmp file */
   sprintf(gCmdStr, "ping %s -c 3 -W %u | grep loss | cut -f3 -d, 1>& /tmp/pingout.txt", verip->cmdsu.verifyIp.dipaddr, verip->cmdsu.verifyIp.timeout);
   system(gCmdStr); 

   /* scan/check the output */
   tmpfile = fopen("/tmp/pingout.txt", "r+");
   if(tmpfile == NULL)
   {
      verifyIpResp->status = STATUS_ERROR;
      wfaEncodeTLV(WFA_STA_VERIFY_IP_CONNECTION_RESP_TLV, 4, (BYTE *)verifyIpResp, respBuf);   
      *respLen = WFA_TLV_HDR_LEN + 4;

      DPRINT_ERR(WFA_ERR, "file open failed\n");
      return FALSE;
   }
   
   verifyIpResp->status = STATUS_COMPLETE;
   if(fscanf(tmpfile, "%s", strout) == EOF)
       verifyIpResp->cmdru.connected = 0;
   else
   {
       pcnt = strtok(strout, "%"); 
       
       /* if the loss rate is 100%, not able to connect */
       if(atoi(pcnt) == 100)
          verifyIpResp->cmdru.connected = 0;
       else
          verifyIpResp->cmdru.connected = 1;
   }

   fclose(tmpfile);
#else
   int btSockfd;
   struct pollfd fds[2];
   int timeout = 2000;
   char anyBuf[64];
   struct sockaddr_in toAddr;
   int done = 1, cnt = 0, ret, nbytes;

   verifyIpResp->status = STATUS_COMPLETE;
   verifyIpResp->cmdru.connected = 0;

   btSockfd = wfaCreateUDPSock("127.0.0.1", WFA_UDP_ECHO_PORT);

   if(btSockfd == -1)
   {
      verifyIpResp->status = STATUS_ERROR;
      wfaEncodeTLV(WFA_STA_VERIFY_IP_CONNECTION_RESP_TLV, 4, (BYTE *)verifyIpResp, respBuf);   
      *respLen = WFA_TLV_HDR_LEN + 4;
      return FALSE;;
   }

   toAddr.sin_family = AF_INET;
   toAddr.sin_addr.s_addr = inet_addr(verip->cmdsu.verifyIp.dipaddr);
   toAddr.sin_port = htons(WFA_UDP_ECHO_PORT);

   while(done)
   {
       wfaTrafficSendTo(btSockfd, (char *)anyBuf, 64, (struct sockaddr *)&toAddr);
       cnt++;

       fds[0].fd = btSockfd;
       fds[0].events = POLLIN | POLLOUT; 

       ret = poll(fds, 1, timeout);
       switch(ret)
       {
           case 0:
             /* it is time out, count a packet lost*/
           break;
           case -1:
             /* it is an error */
           default:
           {
              switch(fds[0].revents)
              {
                  case POLLIN:
                  case POLLPRI:
                  case POLLOUT:
                  nbytes = wfaTrafficRecv(btSockfd, (char *)anyBuf, (struct sockaddr *)&toAddr);
                  if(nbytes != 0)
                      verifyIpResp->cmdru.connected = 1;
                      done = 0;
                  break;
                  default:
                  /* errors but not care */
                   ;
              } 
           }
       } 
       if(cnt == 3)
       {
          done = 0;
       }
   }
       
#endif

   wfaEncodeTLV(WFA_STA_VERIFY_IP_CONNECTION_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)verifyIpResp, respBuf);   

   *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
   
   return TRUE;
}

/*
 * wfaStaGetMacAddress()
 *    This function is to retrieve the MAC address of a wireless I/F.
 */
int wfaStaGetMacAddress(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
    dutCommand_t *getMac = (dutCommand_t *)caCmdBuf;
    dutCmdResponse_t *getmacResp = &gGenericResp;
    char *str;
    char *ifname = getMac->intf;

    FILE *tmpfd;
    char string[128];

    DPRINT_INFO(WFA_OUT, "Entering wfaStaGetMacAddress ...\n");
    /*
     * run the script "getipconfig.sh" to find out the mac
     */
    //sprintf(gCmdStr, "getipconfig.sh /tmp/ipconfig.txt %s", ifname); 
    sprintf(gCmdStr, "ifconfig %s > /tmp/ipconfig.txt ", ifname); 
    system(gCmdStr);

    tmpfd = fopen("/tmp/ipconfig.txt", "r+");
    if(tmpfd == NULL)
    {
      getmacResp->status = STATUS_ERROR;
      wfaEncodeTLV(WFA_STA_GET_MAC_ADDRESS_RESP_TLV, 4, (BYTE *)getmacResp, respBuf);   
      *respLen = WFA_TLV_HDR_LEN + 4;

      DPRINT_ERR(WFA_ERR, "file open failed\n");
      return FALSE;
    }

        if(fgets(string, 256, tmpfd) == NULL)
        {
           getmacResp->status = STATUS_ERROR;
        }

         str = strtok(string, " ");
         while(str && ((strcmp(str,"HWaddr")) != 0))
        {
            str = strtok(NULL, " ");
        }
         
        /* get mac */
        if(str)
            {
          str = strtok(NULL, " ");
          strcpy(getmacResp->cmdru.mac, str);
               getmacResp->status = STATUS_COMPLETE;
    }
 
 
    wfaEncodeTLV(WFA_STA_GET_MAC_ADDRESS_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)getmacResp, respBuf);   

    *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);

    fclose(tmpfd);
    return TRUE;
}

/*
 * wfaStaGetStats():
 * The function is to retrieve the statistics of the I/F's layer 2 txFrames, 
 * rxFrames, txMulticast, rxMulticast, fcsErrors/crc, and txRetries.
 * Currently there is not definition how to use these info. 
 */
int wfaStaGetStats(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t *statsResp = &gGenericResp;

   /* this is never used, you can skip this call */

   statsResp->status = STATUS_ERROR;
   wfaEncodeTLV(WFA_STA_GET_STATS_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)statsResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);


   return TRUE;
}

/*
 * wfaSetEncryption():
 *   The function is to set the wireless interface with WEP or none.
 *
 *   Since WEP is optional test, current function is only used for 
 *   resetting the Security to NONE/Plaintext (OPEN). To test WEP, 
 *   this function should be replaced by the next one (wfaSetEncryption1())
 *
 *   Input parameters: 
 *     1. I/F
 *     2. ssid
 *     3. encpType - wep or none
 *     Optional:
 *     4. key1
 *     5. key2
 *     6. key3
 *     7. key4
 *     8. activeKey Index
 */

int wfaSetEncryption1(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetEncryption_t *setEncryp = (caStaSetEncryption_t *)caCmdBuf;
   dutCmdResponse_t *setEncrypResp = &gGenericResp;
   
   /*
    * disable the network first
    */
   sprintf(gCmdStr, "wpa_cli -i %s disable_network 0", setEncryp->intf);
   system(gCmdStr);

   /*
    * set SSID
    */    
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", setEncryp->intf, setEncryp->ssid);
   system(gCmdStr);

   /*
    * Tell the supplicant for infrastructure mode (1)
    */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 mode 0", setEncryp->intf);
   system(gCmdStr);

   /*
    * set Key management to NONE (NO WPA) for plaintext or WEP
    */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt NONE", setEncryp->intf);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", setEncryp->intf);
   system(gCmdStr);

   setEncrypResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_ENCRYPTION_RESP_TLV, 4, (BYTE *)setEncrypResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

/*
 *  Since WEP is optional, this function could be used to replace
 *  wfaSetEncryption() if necessary. 
 */
int wfaSetEncryption(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetEncryption_t *setEncryp = (caStaSetEncryption_t *)caCmdBuf;
   dutCmdResponse_t *setEncrypResp = &gGenericResp;
   int i;

   /*
    * disable the network first
    */
   sprintf(gCmdStr, "wpa_cli -i %s disable_network 0", setEncryp->intf);
   system(gCmdStr);

   /*
    * set SSID
    */    
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", setEncryp->intf, setEncryp->ssid);
   system(gCmdStr);

   /*
    * Tell the supplicant for infrastructure mode (1)
    */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 mode 0", setEncryp->intf);
   system(gCmdStr);

   /*
    * set Key management to NONE (NO WPA) for plaintext or WEP
    */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt NONE", setEncryp->intf);
   system(gCmdStr);

   /* set keys */
   if(setEncryp->encpType == 1)
   {
      for(i=0; i<4; i++)
      {
         if(setEncryp->keys[i][0] != '\0')
         {
             sprintf(gCmdStr, "wpa_cli -i %s set_network 0 wep_key%i %s",
                   setEncryp->intf, i, setEncryp->keys[i]);
             system(gCmdStr);
         }
      }

      /* set active key */
      i = setEncryp->activeKeyIdx;
      if(setEncryp->keys[i][0] != '\0')
      {
          sprintf(gCmdStr, "wpa_cli -i %s set_network 0 wep_tx_keyidx %i",
            setEncryp->intf, setEncryp->activeKeyIdx);
          system(gCmdStr);
      }
   }
   else /* clearly remove the keys -- reported by p.schwann */
   {
         
      for(i = 0; i < 4; i++)
      {
          sprintf(gCmdStr, "wpa_cli -i %s set_network 0 wep_key%i \"\"", setEncryp->intf, i);
          system(gCmdStr);
      }
   }

   sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", setEncryp->intf);
   system(gCmdStr);

   setEncrypResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_ENCRYPTION_RESP_TLV, 4, (BYTE *)setEncrypResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

/*
 * wfaStaSetEapTLS():
 *   This is to set
 *   1. ssid
 *   2. encrypType - tkip or aes-ccmp
 *   3. keyManagementType - wpa or wpa2
 *   4. trustedRootCA
 *   5. clientCertificate
 */
int wfaStaSetEapTLS(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetEapTLS_t *setTLS = (caStaSetEapTLS_t *)caCmdBuf;
   char *ifname = setTLS->intf;
   dutCmdResponse_t *setEapTlsResp = &gGenericResp;

   DPRINT_INFO(WFA_OUT, "Entering wfaStaSetEapTLS ...\n");

   /*
    * need to store the trustedROOTCA and clientCertificate into a file first.
    */
#ifdef WFA_NEW_CLI_FORMAT
   sprintf(gCmdStr, "wfa_set_eaptls -i %s %s %s %s", ifname, setTLS->ssid, setTLS->trustedRootCA, setTLS->clientCertificate);
   system(gCmdStr);
#else

   sprintf(gCmdStr, "wpa_cli -i %s disable_network 0", ifname);
   system(gCmdStr);

   /* ssid */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", ifname, setTLS->ssid);
   system(gCmdStr);

   /* key management */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt WPA-EAP", ifname);
   system(gCmdStr);

   /* protocol WPA */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 proto WPA", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 eap TLS", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ca_cert '\"%s\"'", ifname, setTLS->trustedRootCA);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 identity '\"wifi-user@wifilabs.local\"'", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 private_key '\"%s/%s\"'", ifname, CERTIFICATES_PATH, setTLS->clientCertificate);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 private_key_passwd '\"wifi\"'", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", ifname);
   system(gCmdStr);
#endif

   setEapTlsResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_EAPTLS_RESP_TLV, 4, (BYTE *)setEapTlsResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

/*
 * The function is to set 
 *   1. ssid
 *   2. passPhrase
 *   3. keyMangementType - wpa/wpa2
 *   4. encrypType - tkip or aes-ccmp
 */
int wfaStaSetPSK(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetPSK_t *setPSK = (caStaSetPSK_t *)caCmdBuf;
   dutCmdResponse_t *setPskResp = &gGenericResp;

#ifdef WFA_NEW_CLI_FORMAT
   sprintf(gCmdStr, "wfa_set_psk %s %s %s", setPSK->intf, setPSK->ssid, setPSK->passphrase); 
   system(gCmdStr);
#else
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", setPSK->intf, setPSK->ssid); 
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt WPA-PSK", setPSK->intf); 
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 psk '\"%s\"'", setPSK->intf, setPSK->passphrase); 
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", setPSK->intf);
   system(gCmdStr);
#endif

   setPskResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_PSK_RESP_TLV, 4, (BYTE *)setPskResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE; 
}

/*
 * wfaStaGetInfo(): 
 * Get vendor specific information in name/value pair by a wireless I/F.
 */
int wfaStaGetInfo(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   dutCommand_t *getInfo = (dutCommand_t *)caCmdBuf;

   /*
    * Normally this is called to retrieve the vendor information
    * from a interface, no implement yet
    */
   sprintf(infoResp.cmdru.info, "interface,%s,vendor,XXX,cardtype,802.11a/b/g", getInfo->intf);

   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_GET_INFO_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}

/*
 * wfaStaSetEapTTLS():
 *   This is to set
 *   1. ssid
 *   2. username
 *   3. passwd
 *   4. encrypType - tkip or aes-ccmp
 *   5. keyManagementType - wpa or wpa2
 *   6. trustedRootCA
 */
int wfaStaSetEapTTLS(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetEapTTLS_t *setTTLS = (caStaSetEapTTLS_t *)caCmdBuf;
   char *ifname = setTTLS->intf;
   dutCmdResponse_t *setEapTtlsResp = &gGenericResp;

#ifdef WFA_NEW_CLI_FORMAT
   sprintf(gCmdStr, "wfa_set_eapttls %s %s %s %s %s", ifname, setTTLS->ssid, setTTLS->username, setTTLS->passwd, setTTLS->trustedRootCA);
   system(gCmdStr);
#else

   sprintf(gCmdStr, "wpa_cli -i %s disable_network 0", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", ifname, setTTLS->ssid);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 identity '\"%s\"'", ifname, setTTLS->username);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 password '\"%s\"'", ifname, setTTLS->passwd);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt WPA-EAP", ifname);
   system(gCmdStr);

/* This may not need to set. if it is not set, default to take all */
//   sprintf(cmdStr, "wpa_cli -i %s set_network 0 pairwise '\"%s\"", ifname, setTTLS->encrptype);
//   system(cmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 eap TTLS", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ca_cert '\"%s/%s\"'", ifname, CERTIFICATES_PATH, setTTLS->trustedRootCA);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 proto WPA", ifname);
   system(gCmdStr);

//   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 anonymous_identity '\"anonymous\"'", ifname);
//   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 phase2 '\"auth=MSCHAPV2\"'", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", ifname);
   system(gCmdStr);
#endif

   setEapTtlsResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_EAPTTLS_RESP_TLV, 4, (BYTE *)setEapTtlsResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

/*
 * wfaStaSetEapSIM():
 *   This is to set
 *   1. ssid
 *   2. user name
 *   3. passwd
 *   4. encrypType - tkip or aes-ccmp
 *   5. keyMangementType - wpa or wpa2
 */
int wfaStaSetEapSIM(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetEapSIM_t *setSIM = (caStaSetEapSIM_t *)caCmdBuf;
   char *ifname = setSIM->intf;
   dutCmdResponse_t *setEapSimResp = &gGenericResp;

#ifdef WFA_NEW_CLI_FORMAT
   sprintf(gCmdStr, "wfa_set_eapsim %s %s %s %s", ifname, setSIM->ssid, setSIM->username, setSIM->encrptype);
   system(gCmdStr);
#else

   sprintf(gCmdStr, "wpa_cli -i %s disable_network 0", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", ifname, setSIM->ssid);
   system(gCmdStr);


   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 identity '\"%s\"'", ifname, setSIM->username);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt WPA-EAP", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 pairwise '\"%s\"'", ifname, setSIM->encrptype);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 eap SIM", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 proto WPA", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", ifname);
   system(gCmdStr);
#endif

   setEapSimResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_EAPSIM_RESP_TLV, 4, (BYTE *)setEapSimResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

/*
 * wfaStaSetPEAP()
 *   This is to set
 *   1. ssid
 *   2. user name
 *   3. passwd
 *   4. encryType - tkip or aes-ccmp
 *   5. keyMgmtType - wpa or wpa2
 *   6. trustedRootCA
 *   7. innerEAP
 *   8. peapVersion
 */
int wfaStaSetPEAP(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetEapPEAP_t *setPEAP = (caStaSetEapPEAP_t *)caCmdBuf;
   char *ifname = setPEAP->intf;
   dutCmdResponse_t *setPeapResp = &gGenericResp;

#ifdef WFA_NEW_CLI_FORMAT
   sprintf(gCmdStr, "wfa_set_peap %s %s %s %s %s %s %i %s", ifname, setPEAP->ssid, setPEAP->username, 
                                                          setPEAP->passwd, setPEAP->trustedRootCA,
							  setPEAP->encrptype, setPEAP->peapVersion,
							  setPEAP->innerEAP);
   system(gCmdStr);
#else

   sprintf(gCmdStr, "wpa_cli -i %s disable_network 0", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", ifname, setPEAP->ssid);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 eap PEAP", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 anonymous_identity '\"anonymous\"' ", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 identity '\"%s\"'", ifname, setPEAP->username);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 password '\"%s\"'", ifname, setPEAP->passwd);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ca_cert '\"%s/%s\"'", ifname, CERTIFICATES_PATH, setPEAP->trustedRootCA);
   system(gCmdStr);

   /* if this not set, default to set support all */
   //sprintf(gCmdStr, "wpa_cli -i %s set_network 0 pairwise '\"%s\"'", ifname, setPEAP->encrptype);
   //system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt WPA-EAP", ifname);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 phase1 '\"peaplabel=%i\"'", ifname, setPEAP->peapVersion);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 phase2 '\"auth=%s\"'", ifname, setPEAP->innerEAP);
   system(gCmdStr);

   sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", ifname);
   system(gCmdStr);
#endif

   setPeapResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_PEAP_RESP_TLV, 4, (BYTE *)setPeapResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

/*
 * wfaStaSetUAPSD()
 *    This is to set
 *    1. acBE
 *    2. acBK
 *    3. acVI
 *    4. acVO
 */
int wfaStaSetUAPSD(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetUAPSD_t *setUAPSD = (caStaSetUAPSD_t *)caCmdBuf;
   char *ifname = setUAPSD->intf;
   char tmpStr[10];
   char line[100];
   char *pathl="/etc/Wireless/RT61STA";
   dutCmdResponse_t *setUAPSDResp = &gGenericResp;
   BYTE acBE=1;
   BYTE acBK=1;
   BYTE acVO=1;
   BYTE acVI=1;
   BYTE APSDCapable;
   FILE *pipe;

   /*
    * A series of setting need to be done before doing WMM-PS
    * Additional steps of configuration may be needed.
    */

   /*
    * bring down the interface
    */
   sprintf(gCmdStr, "ifconfig %s down",ifname);
   system(gCmdStr);
   /*
    * Unload the Driver
    */
   sprintf(gCmdStr, "rmmod rt61");
   system(gCmdStr);
#ifndef WFA_WMM_AC
   if(setUAPSD->acBE != 1)
     acBE=setUAPSD->acBE = 0;
   if(setUAPSD->acBK != 1)
     acBK=setUAPSD->acBK = 0;
   if(setUAPSD->acVO != 1)
     acVO=setUAPSD->acVO = 0;
   if(setUAPSD->acVI != 1)
     acVI=setUAPSD->acVI = 0;
#else
     acBE=setUAPSD->acBE;
     acBK=setUAPSD->acBK;
     acVO=setUAPSD->acVO;
     acVI=setUAPSD->acVI;
#endif

   APSDCapable = acBE||acBK||acVO||acVI;
   /*
    * set other AC parameters
    */

   sprintf(tmpStr,"%d;%d;%d;%d",setUAPSD->acBE,setUAPSD->acBK,setUAPSD->acVI,setUAPSD->acVO);
   sprintf(gCmdStr, "sed -e \"s/APSDCapable=.*/APSDCapable=%d/g\" -e \"s/APSDAC=.*/APSDAC=%s/g\" %s/rt61sta.dat >/tmp/wfa_tmp",APSDCapable,tmpStr,pathl);
   system(gCmdStr);
   
   sprintf(gCmdStr, "mv /tmp/wfa_tmp %s/rt61sta.dat",pathl);
   system(gCmdStr);
  pipe = popen("uname -r", "r");
  /* Read into line the output of uname*/
       fscanf(pipe,"%s",line);
       pclose(pipe);

   /*
    * load the Driver
    */
   sprintf(gCmdStr, "insmod /lib/modules/%s/extra/rt61.ko",line);
   system(gCmdStr);
   
   sprintf(gCmdStr, "ifconfig %s up",ifname);
   system(gCmdStr);

   setUAPSDResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_UAPSD_RESP_TLV, 4, (BYTE *)setUAPSDResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;
   return TRUE;
}

int wfaDeviceGetInfo(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCommand_t *dutCmd = (dutCommand_t *)caCmdBuf;
   caDevInfo_t *devInfo = &dutCmd->cmdsu.dev;   

#if 0 // by bbelief   
   dutCmdResponse_t *infoResp = &gGenericResp;
   /*a vendor can fill in the proper info or anything non-disclosure */
   caDeviceGetInfoResp_t dinfo = {"WFA Lab", "DemoUnit", WFA_SYSTEM_VER};

   DPRINT_INFO(WFA_OUT, "Entering wfaDeviceGetInfo ...\n");

   if(devInfo->fw == 0)
      memcpy(&infoResp->cmdru.devInfo, &dinfo, sizeof(caDeviceGetInfoResp_t));
   else
   {
      // Call internal API to pull the version ID */
      memcpy(infoResp->cmdru.devInfo.firmware, "NOVERSION", 15);
   }
#else
    dutCmdResponse_t infoResp;   

    memset(&infoResp, 0, sizeof(infoResp));
    DPRINT_INFO(WFA_OUT, "Entering wfaDeviceGetInfo ...\n");

    if(cmd_device_get_info(sigma_dut_ptr(), dutCmd, &infoResp) < 0){
        infoResp.status = STATUS_ERROR;  
        *respLen = 0;
        return FALSE;
    }

#endif

   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_DEVICE_GET_INFO_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);

   return TRUE;

}

/*
 * This funciton is to retrieve a list of interfaces and return
 * the list back to Agent control.
 * ********************************************************************
 * Note: We intend to make this WLAN interface name as a hardcode name.
 * Therefore, for a particular device, you should know and change the name
 * for that device while doing porting. The MACRO "WFA_STAUT_IF" is defined in 
 * the file "inc/wfa_ca.h". If the device OS is not linux-like, this most 
 * likely is hardcoded just for CAPI command responses.
 * *******************************************************************
 * 
 */
int wfaDeviceListIF(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t *infoResp = &gGenericResp;
   dutCommand_t *ifList = (dutCommand_t *)caCmdBuf;
   caDeviceListIFResp_t *ifListResp = &infoResp->cmdru.ifList;

   DPRINT_INFO(WFA_OUT, "Entering wfaDeviceListIF ...\n");
   
   switch(ifList->cmdsu.iftype)
   {
      case IF_80211:
      infoResp->status = STATUS_COMPLETE;
      ifListResp->iftype = IF_80211; 

#if 0      // by bbelief
      strcpy(ifListResp->ifs[0], WFA_STAUT_IF);
#else
      strcpy(ifListResp->ifs[0], get_main_ifname());   
#endif

      strcpy(ifListResp->ifs[1], "NULL");
      strcpy(ifListResp->ifs[2], "NULL");
      break;
      case IF_ETH:
      infoResp->status = STATUS_COMPLETE;
      ifListResp->iftype = IF_ETH; 
      strcpy(ifListResp->ifs[0], "eth0");
      strcpy(ifListResp->ifs[1], "NULL");
      strcpy(ifListResp->ifs[2], "NULL");
      break;
      default:
      {
         infoResp->status = STATUS_ERROR;
         wfaEncodeTLV(WFA_DEVICE_LIST_IF_RESP_TLV, 4, (BYTE *)infoResp, respBuf);   
         *respLen = WFA_TLV_HDR_LEN + 4;

         return TRUE; 
      }
   }
   
   wfaEncodeTLV(WFA_DEVICE_LIST_IF_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);

   return TRUE;
}

int wfaStaDebugSet(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t *debugResp = &gGenericResp;
   dutCommand_t *debugSet = (dutCommand_t *)caCmdBuf;

   DPRINT_INFO(WFA_OUT, "Entering wfaStaDebugSet ...\n");

   if(debugSet->cmdsu.dbg.state == 1) /* enable */
      wfa_defined_debug |= debugSet->cmdsu.dbg.level;
   else
      wfa_defined_debug = (~debugSet->cmdsu.dbg.level & wfa_defined_debug);

   debugResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_GET_INFO_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)debugResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);


   return TRUE;
}


/*
 *   wfaStaGetBSSID():
 *     This function is to retrieve BSSID of a specific wireless I/F.
 */ 
int wfaStaGetBSSID(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   char string[64]; 
   char *str;
   FILE *tmpfd;
   dutCmdResponse_t *bssidResp = &gGenericResp;

   DPRINT_INFO(WFA_OUT, "Entering wfaStaGetBSSID ...\n");
   /* retrieve the BSSID */
   sprintf(gCmdStr, "wpa_cli status > /tmp/bssid.txt");

   system(gCmdStr);

   tmpfd = fopen("/tmp/bssid.txt", "r+");
   if(tmpfd == NULL)
   {
      bssidResp->status = STATUS_ERROR;
      wfaEncodeTLV(WFA_STA_GET_BSSID_RESP_TLV, 4, (BYTE *)bssidResp, respBuf);   
      *respLen = WFA_TLV_HDR_LEN + 4;

      DPRINT_ERR(WFA_ERR, "file open failed\n");
      return FALSE;
   }

   for(;;)
   {
      if(fscanf(tmpfd, "%s", string) == EOF)
      {
         bssidResp->status = STATUS_COMPLETE; 
         strcpy(bssidResp->cmdru.bssid, "00:00:00:00:00:00");
         break; 
      }

      if(strncmp(string, "bssid", 5) == 0)
      {
         str = strtok(string, "=");
         str = strtok(NULL, "=");
         if(str != NULL)
         {
            strcpy(bssidResp->cmdru.bssid, str);
            bssidResp->status = STATUS_COMPLETE;
            break;
         }
      }
   }
 
   wfaEncodeTLV(WFA_STA_GET_BSSID_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)bssidResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);

   fclose(tmpfd);
   return TRUE;
}

/*
 * wfaStaSetIBSS()
 *    This is to set
 *    1. ssid
 *    2. channel
 *    3. encrypType - none or wep
 *    optional
 *    4. key1
 *    5. key2
 *    6. key3
 *    7. key4
 *    8. activeIndex - 1, 2, 3, or 4
 */
int wfaStaSetIBSS(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetIBSS_t *setIBSS = (caStaSetIBSS_t *)caCmdBuf;
   dutCmdResponse_t *setIbssResp = &gGenericResp;
   int i;

   /*
    * disable the network first
    */ 
   sprintf(gCmdStr, "wpa_cli -i %s disable_network 0", setIBSS->intf); 
   system(gCmdStr);

   /*
    * set SSID
    */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", setIBSS->intf, setIBSS->ssid); 
   system(gCmdStr);

   /*
    * Set channel for IBSS
    */
   sprintf(gCmdStr, "iwconfig %s channel %i", setIBSS->intf, setIBSS->channel);
   system(gCmdStr);

   /*
    * Tell the supplicant for IBSS mode (1)
    */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 mode 1", setIBSS->intf);
   system(gCmdStr);

   /*
    * set Key management to NONE (NO WPA) for plaintext or WEP
    */
   sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt NONE", setIBSS->intf);
   system(gCmdStr);

   if(setIBSS->encpType == 1)
   {
      for(i=0; i<4; i++)
      {
         if(strlen(setIBSS->keys[i]) ==5 || strlen(setIBSS->keys[i]) == 13)
         {
             sprintf(gCmdStr, "wpa_cli -i %s set_network 0 wep_key%i \"%s\"", 
                setIBSS->intf, i, setIBSS->keys[i]);
             system(gCmdStr);
         }
      } 

      i = setIBSS->activeKeyIdx;
      if(strlen(setIBSS->keys[i]) ==5 || strlen(setIBSS->keys[i]) == 13)
      {
         sprintf(gCmdStr, "wpa_cli -i %s set_network 0 wep_tx_keyidx %i", 
            setIBSS->intf, setIBSS->activeKeyIdx);
         system(gCmdStr);
      }
   }

   sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", setIBSS->intf);
   system(gCmdStr);

   setIbssResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_IBSS_RESP_TLV, 4, (BYTE *)setIbssResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

/*
 *  wfaSetMode():
 *  The function is to set the wireless interface with a given mode (possible 
 *  adhoc)
 *  Input parameters:
 *    1. I/F
 *    2. ssid
 *    3. mode adhoc or managed
 *    4. encType
 *    5. channel
 *    6. key(s)
 *    7. active  key
 */ 
int wfaStaSetMode(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetMode_t *setmode = (caStaSetMode_t *)caCmdBuf;
   dutCmdResponse_t *SetModeResp = &gGenericResp;
   int i;

   /*
    * bring down the interface
    */
   sprintf(gCmdStr, "ifconfig %s down",setmode->intf);
   system(gCmdStr);

   /*
    * distroy the interface
    */
   sprintf(gCmdStr, "wlanconfig %s destroy",setmode->intf);
   system(gCmdStr);


   /*
    * re-create the interface with the given mode
    */
   if(setmode->mode == 1)
        sprintf(gCmdStr, "wlanconfig %s create wlandev wifi0 wlanmode adhoc",setmode->intf);
   else
        sprintf(gCmdStr, "wlanconfig %s create wlandev wifi0 wlanmode managed",setmode->intf);

   system(gCmdStr);
   if(setmode->encpType == ENCRYPT_WEP)
    {
      int j = setmode->activeKeyIdx;
      for(i=0; i<4; i++)
      {
         if(setmode->keys[i][0] != '\0')
         {
             sprintf(gCmdStr, "iwconfig  %s key  s:%s",
                   setmode->intf, setmode->keys[i]);
             system(gCmdStr);
         }
      /* set active key */
         if(setmode->keys[j][0] != '\0')
             sprintf(gCmdStr, "iwconfig  %s key  s:%s",
                   setmode->intf, setmode->keys[j]);
         system(gCmdStr);
      }

    }
   /*
    * Set channel for IBSS
    */
    if(setmode->channel)
    {
      sprintf(gCmdStr, "iwconfig %s channel %i", setmode->intf, setmode->channel);
      system(gCmdStr);
    }


   /*
    * set SSID
    */
   sprintf(gCmdStr, "iwconfig %s essid %s", setmode->intf, setmode->ssid);
   system(gCmdStr);

   /*
    * bring up the interface
    */
   sprintf(gCmdStr, "ifconfig %s up",setmode->intf);
   system(gCmdStr);

   SetModeResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_MODE_RESP_TLV, 4, (BYTE *)SetModeResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

int wfaStaSetPwrSave(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetPwrSave_t *setps = (caStaSetPwrSave_t *)caCmdBuf;
   dutCmdResponse_t *SetPSResp = &gGenericResp;

   sprintf(gCmdStr, "iwconfig %s power %s", setps->intf, setps->mode);
   system(gCmdStr);


   SetPSResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_PWRSAVE_RESP_TLV, 4, (BYTE *)SetPSResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

int wfaStaUpload(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaUpload_t *upload = &((dutCommand_t *)caCmdBuf)->cmdsu.upload;
   dutCmdResponse_t *upLoadResp = &gGenericResp;
   caStaUploadResp_t *upld = &upLoadResp->cmdru.uld;
   
   if(upload->type == WFA_UPLOAD_VHSO_RPT)
   {
       int rbytes;
       /*
        * if asked for the first packet, always to open the file
        */
       if(upload->next == 1)
       {
          if(e2efp != NULL)
          {
              fclose(e2efp);
              e2efp = NULL;
          }

          e2efp = fopen(e2eResults, "r");
       }

       if(e2efp == NULL)
       {
           upLoadResp->status = STATUS_ERROR;
           wfaEncodeTLV(WFA_STA_UPLOAD_RESP_TLV, 4, (BYTE *)upLoadResp, respBuf);
           *respLen = WFA_TLV_HDR_LEN + 4;
           return FALSE;
       }
        
       rbytes = fread(upld->bytes, 1, 256, e2efp); 

       if(rbytes < 256)  
       {
           /* 
            * this means no more bytes after this read
            */
           upld->seqnum = 0;
           fclose(e2efp);
           e2efp=NULL;
       }
       else
       { 
           upld->seqnum = upload->next;
       }

       upld->nbytes = rbytes;

       upLoadResp->status = STATUS_COMPLETE;
       wfaEncodeTLV(WFA_STA_UPLOAD_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)upLoadResp, respBuf);
       *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
   }
   else
   {
       upLoadResp->status = STATUS_ERROR;
       wfaEncodeTLV(WFA_STA_UPLOAD_RESP_TLV, 4, (BYTE *)upLoadResp, respBuf);
       *respLen = WFA_TLV_HDR_LEN + 4;
   }

   return TRUE;
}
/*
 * wfaStaSetWMM()
 *  TO be ported on a specific plaform for the DUT
 *  This is to set the WMM related parameters at the DUT.
 *  Currently the function is used for GROUPS WMM-AC and WMM general configuration for setting RTS Threshhold, Fragmentation threshold and wmm (ON/OFF)
 *  It is expected that this function will set all the WMM related parametrs for a particular GROUP .
 */
int wfaStaSetWMM(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
#ifdef WFA_WMM_AC
    caStaSetWMM_t *setwmm = (caStaSetWMM_t *)caCmdBuf;
    char *ifname = setwmm->intf;
    dutCmdResponse_t *setwmmResp = &gGenericResp;
    //IEEEtypes_WMM_TSPEC_t tspec;

    switch(setwmm->group)
    {
    case GROUP_WMMAC:
	if (setwmm->send_trig)
	{
	    int Sockfd;
	    struct sockaddr_in psToAddr;
	    unsigned int TxMsg[512];
         
            Sockfd = wfaCreateUDPSock(setwmm->dipaddr, 12346);
	    memset(&psToAddr, 0, sizeof(psToAddr));
	    psToAddr.sin_family = AF_INET;
	    psToAddr.sin_addr.s_addr = inet_addr(setwmm->dipaddr);
	    psToAddr.sin_port = htons(12346);


	    switch (setwmm->trig_ac)
	    {
	    case WMMAC_AC_VO:
	        wfaTGSetPrio(Sockfd, 7);
	        create_apts_msg(APTS_CK_VO, TxMsg, 0);
	        DPRINT_INFO(WFA_OUT, "\r\nSending AC_VO trigger packet\n");
	        break;

	    case WMMAC_AC_VI:
	        wfaTGSetPrio(Sockfd, 5);
	        create_apts_msg(APTS_CK_VI, TxMsg, 0);
	        DPRINT_INFO(WFA_OUT, "\r\nSending AC_VI trigger packet\n");
	        break;

	    case WMMAC_AC_BK:
	        wfaTGSetPrio(Sockfd, 2);
	        create_apts_msg(APTS_CK_BK, TxMsg, 0);
	        DPRINT_INFO(WFA_OUT, "\r\nSending AC_BK trigger packet\n");
	        break;

	    default:
            case WMMAC_AC_BE:
	        wfaTGSetPrio(Sockfd, 0);
	        create_apts_msg(APTS_CK_BE, TxMsg, 0);
	        DPRINT_INFO(WFA_OUT, "\r\nSending AC_BE trigger packet\n");
	        break;
            }

	    sendto(Sockfd, TxMsg, 256, 0, (struct sockaddr *)&psToAddr,
	           sizeof(struct sockaddr));
	    close(Sockfd);
	    usleep(1000000);
	} 
	else if (setwmm->action == WMMAC_ADDTS)
        {
	    //wmmtspec_t* pCmdTspec = &(setwmm->actions.addts.tspec);
            DPRINT_INFO(WFA_OUT, "ADDTS AC PARAMS: dialog id: %d, TID: %d, "
	           "DIRECTION: %d, PSB: %d, UP: %d, "
		   "Fixed %d, MSDU Size: %d, Max MSDU Size %d, "
		   "MIN SERVICE INTERVAL: %d, MAX SERVICE INTERVAL: %d, "
		   "INACTIVITY: %d, SUSPENSION %d, SERVICE START TIME: %d, "
		   "MIN DATARATE: %d, MEAN DATA RATE: %d, PEAK DATA RATE: %d, "
	           "BURSTSIZE: %d, DELAY BOUND: %d, PHYRATE: %d, SPLUSBW: %f, "
		   "MEDIUM TIME: %d, ACCESSCAT: %d\n",
		   setwmm->actions.addts.dialog_token,
		   setwmm->actions.addts.tspec.tsinfo.TID,
		   setwmm->actions.addts.tspec.tsinfo.direction,
		   setwmm->actions.addts.tspec.tsinfo.PSB,
		   setwmm->actions.addts.tspec.tsinfo.UP,
		   setwmm->actions.addts.tspec.Fixed,
		   setwmm->actions.addts.tspec.size,
		   setwmm->actions.addts.tspec.maxsize,
		   setwmm->actions.addts.tspec.min_srvc,
		   setwmm->actions.addts.tspec.max_srvc,
		   setwmm->actions.addts.tspec.inactivity,
		   setwmm->actions.addts.tspec.suspension,
		   setwmm->actions.addts.tspec.srvc_strt_tim,
		   setwmm->actions.addts.tspec.mindatarate,
		   setwmm->actions.addts.tspec.meandatarate,
		   setwmm->actions.addts.tspec.peakdatarate,
		   setwmm->actions.addts.tspec.burstsize,
		   setwmm->actions.addts.tspec.delaybound,
		   setwmm->actions.addts.tspec.PHYrate,
		   setwmm->actions.addts.tspec.sba,
		   setwmm->actions.addts.tspec.medium_time,
		   setwmm->actions.addts.accesscat);

            // you should set your tspec here.

            system(gCmdStr);
        }
        else if (setwmm->action == WMMAC_DELTS)
	{
             // send del tspec 
        }

        setwmmResp->status = STATUS_COMPLETE;
        break;

    case GROUP_WMMCONF:
        sprintf(gCmdStr, "iwconfig %s rts %d",
                ifname,setwmm->actions.config.rts_thr);

        system(gCmdStr);
        sprintf(gCmdStr, "iwconfig %s frag %d",
                ifname,setwmm->actions.config.frag_thr);

        system(gCmdStr);
        sprintf(gCmdStr, "iwpriv %s wmmcfg %d",
                ifname, setwmm->actions.config.wmm);

        system(gCmdStr);
        setwmmResp->status = STATUS_COMPLETE;
        break;

    default:
        DPRINT_ERR(WFA_ERR, "The group %d is not supported\n",setwmm->group);
        setwmmResp->status = STATUS_ERROR;
        break;

    }

    wfaEncodeTLV(WFA_STA_SET_WMM_RESP_TLV, 4, (BYTE *)setwmmResp, respBuf);
    *respLen = WFA_TLV_HDR_LEN + 4;
#endif

    return TRUE;
}

int wfaStaSendNeigReq(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   //dutCommand_t *sendNeigReq = (dutCommand_t *)caCmdBuf;
   dutCmdResponse_t *sendNeigReqResp = &gGenericResp;

   /*
    *  run your device to send NEIGREQ
    */

   sendNeigReqResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SEND_NEIGREQ_RESP_TLV, 4, (BYTE *)sendNeigReqResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

int wfaStaSetEapFAST(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
    caStaSetEapFAST_t *setFAST= (caStaSetEapFAST_t *)caCmdBuf;
    char *ifname = setFAST->intf;
    dutCmdResponse_t *setEapFastResp = &gGenericResp;

#ifdef WFA_NEW_CLI_FORMAT
    sprintf(gCmdStr, "wfa_set_eapfast %s %s %s %s %s %s", ifname, setFAST->ssid, setFAST->username,
                                                          setFAST->passwd, setFAST->pacFileName,
                                                          setFAST->innerEAP);
    system(gCmdStr);
#else

    sprintf(gCmdStr, "wpa_cli -i %s disable_network 0", ifname);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", ifname, setFAST->ssid);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 identity '\"%s\"'", ifname, setFAST->username);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 password '\"%s\"'", ifname, setFAST->passwd);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt WPA-EAP", ifname);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 eap FAST", ifname);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 pac_file '\"%s/%s\"'", ifname, CERTIFICATES_PATH,     setFAST->pacFileName);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 anonymous_identity '\"anonymous\"'", ifname);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 phase1 '\"fast_provisioning=1\"'", ifname);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 phase2 '\"auth=%s\"'", ifname,setFAST->innerEAP);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", ifname);
    system(gCmdStr);
#endif

    setEapFastResp->status = STATUS_COMPLETE;
    wfaEncodeTLV(WFA_STA_SET_EAPFAST_RESP_TLV, 4, (BYTE *)setEapFastResp, respBuf);
    *respLen = WFA_TLV_HDR_LEN + 4;

    return TRUE;
}

int wfaStaSetEapAKA(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
    caStaSetEapAKA_t *setAKA= (caStaSetEapAKA_t *)caCmdBuf;
    char *ifname = setAKA->intf;
    dutCmdResponse_t *setEapAkaResp = &gGenericResp;

#ifdef WFA_NEW_CLI_FORMAT
    sprintf(gCmdStr, "wfa_set_eapaka %s %s %s %s", ifname, setAKA->ssid, setAKA->username, setAKA->passwd);
    system(gCmdStr);
#else

    sprintf(gCmdStr, "wpa_cli -i %s disable_network 0", ifname);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 ssid '\"%s\"'", ifname, setAKA->ssid);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 key_mgmt WPA-EAP", ifname);
    system(gCmdStr);
    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 proto WPA2", ifname);
    system(gCmdStr);
    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 proto CCMP", ifname);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 eap AKA", ifname);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 phase1 \"result_ind=1\"", ifname);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 identity '\"%s\"'", ifname, setAKA->username);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s set_network 0 password '\"%s\"'", ifname, setAKA->passwd);
    system(gCmdStr);

    sprintf(gCmdStr, "wpa_cli -i %s enable_network 0", ifname);
    system(gCmdStr);
#endif

    setEapAkaResp->status = STATUS_COMPLETE;
    wfaEncodeTLV(WFA_STA_SET_EAPAKA_RESP_TLV, 4, (BYTE *)setEapAkaResp, respBuf);
    *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

int wfaStaSetSystime(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaSetSystime_t *systime = (caStaSetSystime_t *)caCmdBuf;
   dutCmdResponse_t *setSystimeResp = &gGenericResp;

   DPRINT_INFO(WFA_OUT, "Entering wfaStaSetSystime ...\n");

   sprintf(gCmdStr, "date %d-%d-%d",systime->month,systime->date,systime->year);
   system(gCmdStr);

   sprintf(gCmdStr, "time %d:%d:%d", systime->hours,systime->minutes,systime->seconds);
   system(gCmdStr);

   setSystimeResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_SYSTIME_RESP_TLV, 4, (BYTE *)setSystimeResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

#ifdef WFA_STA_TB
int wfaStaPresetParams(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t *PresetParamsResp = &gGenericResp;
   caStaPresetParameters_t *presetParams = (caStaPresetParameters_t *)caCmdBuf;
   //int ret;
   //char *intfname = presetParams->intf;
   BYTE presetDone = 1;
   int st = 0;

   DPRINT_INFO(WFA_OUT, "Inside wfaStaPresetParameters function ...\n");

   if(presetParams->wmmFlag)
   {
      st = wfaExecuteCLI(gCmdStr);
      switch(st)
      {
         case 0:
         presetDone = 1;
         break;
         case 1:
         presetDone = 0;
         break;
         case 2:
         presetDone = 0;
         break;
      }
   }

   if(presetParams->modeFlag != 0)
   {
      switch(presetParams->wirelessMode)
      {
         default:
         DPRINT_INFO(WFA_OUT, "other mode does not need to support\n");
      }

      st = wfaExecuteCLI(gCmdStr);
      switch(st)
      {
         case 0:
         presetDone = 1;
         break;
         case 1:
         presetDone = 0;
         case 2:
         presetDone = 0;
         break;
      }
   }


   if(presetParams->psFlag)
   {

      DPRINT_INFO(WFA_OUT, "%s\n", gCmdStr);
      system(gCmdStr);
   }

   /************the followings are used for Voice Enterprise **************/
   if(presetParams->ftoa == eEnable)
   {
      // enable Fast BSS Transition Over the Air
   }
   else
   {
      // disable Fast BSS Transition Over the Air

   }

   if(presetParams->ftds == eEnable)
   {
      // enable Fast BSS Transition Over the DS 

   }
   else
   {
      // disable Fast BSS Transition Over the DS 

   }

   if(presetParams->activescan == eEnable)
   {
      // Enable Active Scan on STA 

   }
   else
   {
      // disable Active Scan on STA 

   }


   if (presetDone)
   {
      PresetParamsResp->status = STATUS_COMPLETE;
   }
   else
   {
      PresetParamsResp->status = STATUS_INVALID;
   }

   wfaEncodeTLV(WFA_STA_PRESET_PARAMETERS_RESP_TLV, 4, (BYTE *)PresetParamsResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}
#endif

int wfaStaSetWireless(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
    dutCmdResponse_t *staWirelessResp = &gGenericResp;

    staWirelessResp->status = STATUS_COMPLETE;
    wfaEncodeTLV(WFA_STA_SET_WIRELESS_RESP_TLV, 4, (BYTE *)staWirelessResp, respBuf);
    *respLen = WFA_TLV_HDR_LEN + 4;
    return TRUE;
}

int wfaStaSendADDBA(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
    dutCmdResponse_t *staSendADDBAResp = &gGenericResp;

    wfaEncodeTLV(WFA_STA_SET_SEND_ADDBA_RESP_TLV, 4, (BYTE *)staSendADDBAResp, respBuf);
    *respLen = WFA_TLV_HDR_LEN + 4;
    return TRUE;
}

int wfaStaSetRIFS(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
        dutCmdResponse_t *staSetRIFSResp = &gGenericResp;

        wfaEncodeTLV(WFA_STA_SET_RIFS_TEST_RESP_TLV, 4, (BYTE *)staSetRIFSResp, respBuf);
        *respLen = WFA_TLV_HDR_LEN + 4;

        return TRUE;

}

int wfaStaSendCoExistMGMT(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
    dutCmdResponse_t *staSendMGMTResp = &gGenericResp;

    wfaEncodeTLV(WFA_STA_SEND_COEXIST_MGMT_RESP_TLV, 4, (BYTE *)staSendMGMTResp, respBuf);
    *respLen = WFA_TLV_HDR_LEN + 4;

    return TRUE;

}

int wfaStaResetDefault(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   caStaResetDefault_t *reset = (caStaResetDefault_t *)caCmdBuf;
   dutCmdResponse_t *ResetResp = &gGenericResp;


   // need to make your own command available for this, here is only an example
   sprintf(gCmdStr, "myresetdefault %s program %s", reset->intf, reset->prog);
   system(gCmdStr);

   ResetResp->status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_RESET_DEFAULT_RESP_TLV, 4, (BYTE *)ResetResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}

int wfaStaTestBedCmd(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
    dutCmdResponse_t *staCmdResp = &gGenericResp;

    wfaEncodeTLV(WFA_STA_DISCONNECT_RESP_TLV, 4, (BYTE *)staCmdResp, respBuf);
    *respLen = WFA_TLV_HDR_LEN + 4;

    return TRUE;
}


int wfaStaDisconnect(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
    //dutCommand_t *disc = (dutCommand_t *)caCmdBuf;
    //char *intf = disc->intf;
    dutCmdResponse_t *staDiscResp = &gGenericResp;

    // stop the supplicant

	// Remove the profile / disconnect the STA from the current AP ( make sure it should not reassociate automatically)
	
	staDiscResp->status = STATUS_COMPLETE;

    wfaEncodeTLV(WFA_STA_DISCONNECT_RESP_TLV, 4, (BYTE *)staDiscResp, respBuf);
    *respLen = WFA_TLV_HDR_LEN + 4;

    return TRUE;
}

/* Execute CLI, read the status from Environment variable */
int wfaExecuteCLI(char *CLI)
{
   char *retstr;

   system(CLI);

   retstr = getenv("WFA_CLI_STATUS");
   DPRINT_INFO(WFA_OUT, "cli status %s\n", retstr);
   return atoi(retstr);
}

/* Supporting Functions */

void wfaSendPing(tgPingStart_t *staPing, float *interval, int streamid)
{
    int totalpkts;
    char cmdStr[128];
//    char *addr = staPing->dipaddr;
#ifdef WFA_PC_CONSOLE
    char addr[20];
    char bflag[] = "-b";
    char *tmpstr;
    int inum=0;
#else
    char bflag[] = "  ";
#endif
    totalpkts = staPing->duration * staPing->frameRate;
#ifdef WFA_PC_CONSOLE

    DPRINT_INFO(WFA_OUT, "\nCS : The Stream ID is %d",streamid);
    DPRINT_INFO(WFA_OUT, "\nCS :the addr is %s ",addr);
    strcpy(addr,staPing->dipaddr);
    DPRINT_INFO(WFA_OUT, "\nCS :Inside the WFA_PC_CONSLE BLOCK");
    DPRINT_INFO(WFA_OUT, "\nCS :the addr is %s ",addr);
    tmpstr = strtok(addr, ".");

    inum = atoi(tmpstr);

    DPRINT_INFO(WFA_OUT, "interval %f\n", *interval);

    if(inum >= 224 && inum <= 239) // multicast
    {
    }
    else // if not MC, check if it is BC address
    {
       DPRINT_INFO(WFA_OUT, "\nCS :Inside the BC address BLOCK");
       DPRINT_INFO(WFA_OUT, "\nCS :the inum %d",inum);
       strtok(NULL, ".");
       //strtok(NULL, ".");
       tmpstr = strtok(NULL, ".");
       DPRINT_INFO(WFA_OUT, "tmpstr %s\n", tmpstr);
       inum = atoi(tmpstr);
       DPRINT_INFO(WFA_OUT, "\nCS : The string is %s",tmpstr);
       if(inum != 255)
          memset(bflag, 0, strlen(bflag));
    }
#endif
    DPRINT_INFO(WFA_OUT, "\nCS : The Stream ID is %d",streamid);

    sprintf(cmdStr, "echo streamid=%i > /tmp/spout_%d.txt;wfaping.sh %s %s -i %f -c %i -s %i -q >> /tmp/spout_%d.txt 2>/dev/null",
          streamid,streamid,bflag, staPing->dipaddr, *interval, totalpkts, staPing->frameSize,streamid);
    system(cmdStr);
    DPRINT_INFO(WFA_OUT, "\nCS : The command string is %s",cmdStr);

    sprintf(cmdStr, "updatepid.sh /tmp/spout_%d.txt",streamid);
    system(cmdStr);
    DPRINT_INFO(WFA_OUT, "\nCS : The command string is %s",cmdStr);

}

int wfaStopPing(dutCmdResponse_t *stpResp, int streamid)
{
    char strout[256];
    FILE *tmpfile = NULL;
    char cmdStr[128];
    DPRINT_INFO(WFA_OUT, "Ping stop id %d\n", streamid);
    sprintf(cmdStr, "getpid.sh /tmp/spout_%d.txt /tmp/pid.txt",streamid);
    system(cmdStr);

    DPRINT_INFO(WFA_OUT, "\nCS : The command string is %s",cmdStr);

    system("stoping.sh /tmp/pid.txt ; sleep 2");

    sprintf(cmdStr, "getpstats.sh /tmp/spout_%d.txt",streamid);
    system(cmdStr);

    DPRINT_INFO(WFA_OUT, "\nCS : The command string is %s",cmdStr);

    tmpfile = fopen("/tmp/stpsta.txt", "r+");

    if(tmpfile == NULL)
    {
        return FALSE;
    }

    if(fscanf(tmpfile, "%s", strout) != EOF)
    {
        if(*strout == '\0')
        {
            stpResp->cmdru.pingStp.sendCnt = 0;
        }

        else
            stpResp->cmdru.pingStp.sendCnt = atoi(strout);
    }

    DPRINT_INFO(WFA_OUT, "after scan sent count %i\n", stpResp->cmdru.pingStp.sendCnt);


    if(fscanf(tmpfile, "%s", strout) != EOF)
    {
        if(*strout == '\0')
        {
            stpResp->cmdru.pingStp.repliedCnt = 0;
        }
        else
            stpResp->cmdru.pingStp.repliedCnt = atoi(strout);
    }
    DPRINT_INFO(WFA_OUT, "after scan replied count %i\n", stpResp->cmdru.pingStp.repliedCnt);

    fclose(tmpfile);

    return TRUE;
}

/*
 * wfaStaGetP2pDevAddress(): 
 */
int wfaStaGetP2pDevAddress(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   dutCommand_t *getInfo = (dutCommand_t *)caCmdBuf;

    DPRINT_INFO(WFA_OUT, "\n Entry wfaStaGetP2pDevAddress... ");
    memset(&infoResp, 0, sizeof(infoResp));

    if(cmd_sta_get_p2p_dev_address(sigma_dut_ptr(), getInfo, &infoResp) < 0){
        infoResp.status = STATUS_ERROR;  
        *respLen = 0;
    	return FALSE;
    }
    
    DPRINT_INFO(WFA_OUT, "%s :%s", __func__, &infoResp.cmdru.devid[0]);

    infoResp.status = STATUS_COMPLETE;
    wfaEncodeTLV(WFA_STA_GET_P2P_DEV_ADDRESS_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
    *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}



/*
 * wfaStaSetP2p(): 
 */
int wfaStaSetP2p(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaSetP2p_t *getStaSetP2p = (caStaSetP2p_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaSetP2p... ");    

	// Implement the function and this does not return any thing back.
    memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_set_p2p(sigma_dut_ptr(), getStaSetP2p, &infoResp) < 0){
        infoResp.status = STATUS_ERROR;  
        *respLen = 0;
    	 return FALSE;
     }    
   
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_P2P_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}
/*
 * wfaStaP2pConnect(): 
 */
int wfaStaP2pConnect(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaP2pConnect_t *getStaP2pConnect = (caStaP2pConnect_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaP2pConnect... ");

	// Implement the function and does not return anything.
       memset(&infoResp, 0, sizeof(infoResp));
	if(cmd_sta_p2p_connect(sigma_dut_ptr(), getStaP2pConnect, &infoResp) < 0){        
           infoResp.status = STATUS_ERROR;  
           *respLen = 0;
            return FALSE;
        }    

	
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_P2P_CONNECT_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}

/*
 * wfaStaStartAutoGo(): 
 */
int wfaStaStartAutoGo(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaStartAutoGo_t *getStaStartAutoGo = (caStaStartAutoGo_t *)caCmdBuf;

    DPRINT_INFO(WFA_OUT, "\n Entry wfaStaStartAutoGo... ");

    memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_start_autonomous_go(sigma_dut_ptr(), getStaStartAutoGo, &infoResp) < 0){        
        infoResp.status = STATUS_ERROR;  
        *respLen = 0;
        return FALSE;
    }    

#if 0        
        // Fetch the group ID and store into 	infoResp->cmdru.grpid 
	strcpy(&infoResp.cmdru.grpid[0], "ABCDEFGH");
#endif

   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_P2P_START_AUTO_GO_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}




/*
 * wfaStaP2pStartGrpFormation(): 
 */
int wfaStaP2pStartGrpFormation(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaP2pStartGrpForm_t *getStaP2pStartGrpForm = (caStaP2pStartGrpForm_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaP2pStartGrpFormation... ");

    memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_p2p_start_group_formation(sigma_dut_ptr(), getStaP2pStartGrpForm, &infoResp) < 0){        
        infoResp.status = STATUS_ERROR;  
        *respLen = 0;
        return FALSE;
    }    

#if 0
	// Fetch the device mode and put in 	infoResp->cmdru.p2presult 
	//strcpy(infoResp->cmdru.p2presult, "GO");

	// Fetch the device grp id and put in 	infoResp->cmdru.grpid 
	//strcpy(infoResp->cmdru.grpid, "AA:BB:CC:DD:EE:FF_DIRECT-SSID");
	
	strcpy(infoResp.cmdru.grpFormInfo.result, "CLIENT");
	strcpy(infoResp.cmdru.grpFormInfo.grpId, "AA:BB:CC:DD:EE:FF_DIRECT-SSID");
#endif

   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_P2P_START_GRP_FORM_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}


/*
 * wfaStaP2pDissolve(): 
 */
int wfaStaP2pDissolve(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaP2pDissolve_t *getStap2pDissolve= (caStaP2pDissolve_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaP2pDissolve... ");

	// Implement the function and this does not return any thing back.
    memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_p2p_dissolve(sigma_dut_ptr(), getStap2pDissolve, &infoResp) < 0){        
        infoResp.status = STATUS_ERROR;  
        *respLen = 0;
        return FALSE;
    }    

    
   
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_P2P_DISSOLVE_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}

/*
 * wfaStaSendP2pInvReq(): 
 */
int wfaStaSendP2pInvReq(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaSendP2pInvReq_t *getStaP2pInvReq= (caStaSendP2pInvReq_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaSendP2pInvReq... ");

	// Implement the function and this does not return any thing back.
   memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_send_p2p_invitation_req(sigma_dut_ptr(), getStaP2pInvReq, &infoResp) < 0){        
        infoResp.status = STATUS_ERROR;  
        *respLen = 0;
        return FALSE;
    } 	
   
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SEND_P2P_INV_REQ_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}


/*
 * wfaStaAcceptP2pInvReq(): 
 */
int wfaStaAcceptP2pInvReq(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaAcceptP2pInvReq_t *getStaP2pInvReq= (caStaAcceptP2pInvReq_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaAcceptP2pInvReq... ");

	// Implement the function and this does not return any thing back.

    memset(&infoResp, 0, sizeof(infoResp));
     if(cmd_sta_accept_p2p_invitation_req(sigma_dut_ptr(), getStaP2pInvReq, &infoResp) < 0){        
         infoResp.status = STATUS_ERROR;  
         *respLen = 0;
         return FALSE;
     }   

   
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_ACCEPT_P2P_REQ_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}


/*
 * wfaStaSendP2pProvDisReq(): 
 */
int wfaStaSendP2pProvDisReq(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaSendP2pProvDisReq_t *getStaP2pProvDisReq= (caStaSendP2pProvDisReq_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaSendP2pProvDisReq... ");

	// Implement the function and this does not return any thing back.
    
    memset(&infoResp, 0, sizeof(infoResp));
     if(cmd_sta_send_p2p_provision_dis_req(sigma_dut_ptr(), getStaP2pProvDisReq, &infoResp) < 0){        
         infoResp.status = STATUS_ERROR;  
         *respLen = 0;
         return FALSE;
     }   

   
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SEND_P2P_PROV_DIS_REQ_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}

/*
 * wfaStaSetWpsPbc(): 
 */
int wfaStaSetWpsPbc(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaSetWpsPbc_t *getStaSetWpsPbc= (caStaSetWpsPbc_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaSetWpsPbc... ");

	// Implement the function and this does not return any thing back.
    memset(&infoResp, 0, sizeof(infoResp));
     if(cmd_sta_set_wps_pbc(sigma_dut_ptr(), getStaSetWpsPbc, &infoResp) < 0){        
         infoResp.status = STATUS_ERROR;  
         *respLen = 0;
         return FALSE;
     }   

      
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_WPS_PBC_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}

/*
 * wfaStaWpsReadPin(): 
 */
int wfaStaWpsReadPin(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaWpsReadPin_t *getStaWpsReadPin= (caStaWpsReadPin_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaWpsReadPin... ");

        memset(&infoResp, 0, sizeof(infoResp));
         if(cmd_sta_wps_read_pin(sigma_dut_ptr(), getStaWpsReadPin, &infoResp) < 0){        
             infoResp.status = STATUS_ERROR;  
             *respLen = 0;
             return FALSE;
         }   

#if 0
	// Fetch the device PIN and put in 	infoResp->cmdru.wpsPin 
	//strcpy(infoResp->cmdru.wpsPin, "12345678");
	strcpy(&infoResp.cmdru.wpsPin[0], "1234456");
#endif
   
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_WPS_READ_PIN_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}



/*
 * wfaStaWpsReadLabel(): 
 */
int wfaStaWpsReadLabel(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaWpsReadLabel_t *getStaWpsReadLabel= (caStaWpsReadLabel_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaWpsReadLabel... ");
    memset(&infoResp, 0, sizeof(infoResp));
     if(cmd_sta_wps_read_label(sigma_dut_ptr(), getStaWpsReadLabel, &infoResp) < 0){        
         infoResp.status = STATUS_ERROR;  
         *respLen = 0;
         return FALSE;
     }   
    
#if 0
	// Fetch the device Label and put in	infoResp->cmdru.wpsPin 
	//strcpy(infoResp->cmdru.wpsPin, "12345678");
	strcpy(&infoResp.cmdru.wpsPin[0], "1234456");
#endif
   
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_WPS_READ_PIN_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);	
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}


/*
 * wfaStaWpsEnterPin(): 
 */
int wfaStaWpsEnterPin(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaWpsEnterPin_t *getStaWpsEnterPin= (caStaWpsEnterPin_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaWpsEnterPin... ");

   // Implement the function and this does not return any thing back.
   memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_wps_enter_pin(sigma_dut_ptr(), getStaWpsEnterPin, &infoResp) < 0){        
        infoResp.status = STATUS_ERROR;  
        *respLen = 0;
        return FALSE;
    }   

   
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_WPS_ENTER_PIN_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}


/*
 * wfaStaGetPsk(): 
 */
int wfaStaGetPsk(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaGetPsk_t *getStaGetPsk= (caStaGetPsk_t *)caCmdBuf;

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaGetPsk... ");

    memset(&infoResp, 0, sizeof(infoResp));
     if(cmd_sta_get_psk(sigma_dut_ptr(), getStaGetPsk, &infoResp) < 0){        
         infoResp.status = STATUS_ERROR;  
         *respLen = 0;
         return FALSE;
     }   

#if 0
	// Fetch the device PP and SSID  and put in 	infoResp->cmdru.pskInfo 
	//strcpy(infoResp->cmdru.wpsPin, "12345678");
	strcpy(&infoResp.cmdru.pskInfo.passPhrase[0], "1234456");
	strcpy(&infoResp.cmdru.pskInfo.ssid[0], "WIFI_DIRECT");	
#endif
   
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_GET_PSK_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}

/*
 * wfaStaP2pReset(): 
 */
int wfaStaP2pReset(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   dutCommand_t *getStaP2pReset= (dutCommand_t *)caCmdBuf;

    DPRINT_INFO(WFA_OUT, "\n Entry wfaStaP2pReset... ");

    // Implement the function and this does not return any thing back.
    memset(&infoResp, 0, sizeof(infoResp));
     if(cmd_sta_p2p_reset(sigma_dut_ptr(), getStaP2pReset, &infoResp) < 0){        
         infoResp.status = STATUS_ERROR;  
         *respLen = 0;
         return FALSE;
     }      

    infoResp.status = STATUS_COMPLETE;
    wfaEncodeTLV(WFA_STA_P2P_RESET_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
    *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}


/*
 * wfaStaGetP2pIpConfig(): 
 */
int wfaStaGetP2pIpConfig(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaGetP2pIpConfig_t *staGetP2pIpConfig= (caStaGetP2pIpConfig_t *)caCmdBuf;
   
  // caStaGetIpConfigResp_t *ifinfo = &(infoResp.cmdru.getIfconfig);

	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaGetP2pIpConfig... ");

       memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_get_p2p_ip_config(sigma_dut_ptr(), staGetP2pIpConfig, &infoResp) < 0){        
           infoResp.status = STATUS_ERROR;  
           *respLen = 0;
            return FALSE;
        }    
    
#if 0
	// Fetch the device IP config  and put in 	infoResp->cmdru 
	//strcpy(infoResp->cmdru.wpsPin, "12345678");
	ifinfo->isDhcp =0;
	strcpy(&(ifinfo->ipaddr[0]), "192.165.100.111");
	strcpy(&(ifinfo->mask[0]), "255.255.255.0");
	strcpy(&(ifinfo->dns[0][0]), "192.165.100.1");
	strcpy(&(ifinfo->mac[0]), "ba:ba:ba:ba:ba:ba");
#endif	
	
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_GET_P2P_IP_CONFIG_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}




/*
 * wfaStaSendServiceDiscoveryReq(): 
 */
int wfaStaSendServiceDiscoveryReq(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaSendServiceDiscoveryReq_t *staSendServiceDiscoveryReq= (caStaSendServiceDiscoveryReq_t *)caCmdBuf;
   
	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaSendServiceDiscoveryReq... ");
	// Implement the function and this does not return any thing back.
       memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_send_service_discovery_req(sigma_dut_ptr(), staSendServiceDiscoveryReq, &infoResp) < 0){        
           infoResp.status = STATUS_ERROR;  
           *respLen = 0;
            return FALSE;
        }

  infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SEND_SERVICE_DISCOVERY_REQ_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}



/*
 * wfaStaSendP2pPresenceReq(): 
 */
int wfaStaSendP2pPresenceReq(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
        dutCmdResponse_t infoResp;
        caStaSendP2pPresenceReq_t *staSendP2pPresenceReq= (caStaSendP2pPresenceReq_t *)caCmdBuf;
   
	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaSendP2pPresenceReq... ");
	// Implement the function and this does not return any thing back.
	DPRINT_INFO(WFA_OUT, "\n The long long Duration: %lld... ",staSendP2pPresenceReq->duration);
	DPRINT_INFO(WFA_OUT, "\n The long long interval : %lld.. ",staSendP2pPresenceReq->interval);

        memset(&infoResp, 0, sizeof(infoResp));
        if(cmd_sta_send_p2p_presence_req(sigma_dut_ptr(), staSendP2pPresenceReq, &infoResp) < 0){        
           infoResp.status = STATUS_ERROR;  
           *respLen = 0;
            return FALSE;
        }    

        infoResp.status = STATUS_COMPLETE;
        wfaEncodeTLV(WFA_STA_SEND_P2P_PRESENCE_REQ_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
        *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

        return TRUE;
}

/*
 * wfaStaSetSleepReq(): 
 */
int wfaStaSetSleepReq(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaSetSleep_t *staSetSleepReq= (caStaSetSleep_t *)caCmdBuf;
   
	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaSetSleepReq... ");

	// Implement the function and this does not return any thing back.
    memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_set_sleep(sigma_dut_ptr(), staSetSleepReq, &infoResp) < 0){        
       infoResp.status = STATUS_ERROR;  
       *respLen = 0;
        return FALSE;
    }    
	
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_SLEEP_REQ_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN +4;

   return TRUE;
}

/*
 * wfaStaSetOpportunisticPsReq(): 
 */
int wfaStaSetOpportunisticPsReq(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaSetOpprPs_t *staSetOpperPsReq= (caStaSetOpprPs_t *)caCmdBuf;
   
	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaSetOpportunisticPsReq... ");
	// Implement the function and this does not return any thing back.
    memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_set_opportunistic_ps(sigma_dut_ptr(), staSetOpperPsReq, &infoResp) < 0){        
       infoResp.status = STATUS_ERROR;  
       *respLen = 0;
        return FALSE;
    }    
	
   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_SET_OPPORTUNISTIC_PS_REQ_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}
#ifndef WFA_STA_TB
/*
 * wfaStaPresetParams(): 
 */

int wfaStaPresetParams(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
	dutCmdResponse_t infoResp;

   caStaPresetParameters_t *presetParams = (caStaPresetParameters_t *)caCmdBuf;


   DPRINT_INFO(WFA_OUT, "Inside wfaStaPresetParameters function ...\n");

	// Implement the function and its sub commands 
	infoResp.status = STATUS_COMPLETE;

   wfaEncodeTLV(WFA_STA_PRESET_PARAMETERS_RESP_TLV, 4, (BYTE *)&infoResp, respBuf);
   *respLen = WFA_TLV_HDR_LEN + 4;

   return TRUE;
}
int wfaStaSet11n(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf) 
{
	
	caSta11n_t * v11nParams = (caSta11n_t *)caCmdBuf;
	dutCmdResponse_t infoResp;
	dutCmdResponse_t *v11nParamsResp = &infoResp;
	


	int st =0; // SUCCESS
	
	DPRINT_INFO(WFA_OUT, "Inside wfaStaSet11n function....\n"); 


	if(v11nParams->addba_reject != 0xFF && v11nParams->addba_reject < 2)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_addba_reject failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}
	
    if(v11nParams->ampdu != 0xFF && v11nParams->ampdu < 2)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 

		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_ampdu failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}
	
    if(v11nParams->amsdu != 0xFF && v11nParams->amsdu < 2)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_amsdu failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}

    if(v11nParams->greenfield != 0xFF && v11nParams->greenfield < 2)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "_set_greenfield failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}

    if(v11nParams->mcs32!= 0xFF && v11nParams->mcs32 < 2 && v11nParams->mcs_fixedrate[0] != '\0')
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_mcs failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	} 
	else if (v11nParams->mcs32!= 0xFF && v11nParams->mcs32 < 2 && v11nParams->mcs_fixedrate[0] == '\0')
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_mcs32 failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}

	} 
	else if (v11nParams->mcs32 == 0xFF && v11nParams->mcs_fixedrate[0] != '\0')
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_mcs32 failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}

    if(v11nParams->rifs_test != 0xFF && v11nParams->rifs_test < 2)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_rifs_test failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}

    if(v11nParams->sgi20 != 0xFF && v11nParams->sgi20 < 2)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_sgi20 failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}

	if(v11nParams->smps != 0xFFFF)
	{
	    if(v11nParams->smps == 0)
	    {
			// implement the funciton
			//st = wfaExecuteCLI(gCmdStr); 
			;

	    }
	    else if(v11nParams->smps == 1)
	    {
			// implement the funciton
			//st = wfaExecuteCLI(gCmdStr); 
			;
	    }		
	    else if(v11nParams->smps == 2)
		{
			// implement the funciton
			//st = wfaExecuteCLI(gCmdStr); 
			;		
	    }
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_smps failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}

	if(v11nParams->stbc_rx != 0xFFFF)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_stbc_rx failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}
	
	if(v11nParams->width[0] != '\0')
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_11n_channel_width failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}

	}
	
    if(v11nParams->_40_intolerant != 0xFF && v11nParams->_40_intolerant < 2)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
            v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_40_intolerant failed");
	        wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
	        *respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}

	}

	if(v11nParams->txsp_stream != 0 && v11nParams->txsp_stream <4)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
			v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_txsp_stream failed");
			wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
			*respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}

	}

	if(v11nParams->rxsp_stream != 0 && v11nParams->rxsp_stream < 4)
	{
		// implement the funciton
		//st = wfaExecuteCLI(gCmdStr); 
		if(st != 0)
		{
			v11nParamsResp->status = STATUS_ERROR;
			strcpy(v11nParamsResp->cmdru.info, "set_rxsp_stream failed");
			wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, sizeof(dutCmdResponse_t), (BYTE *)v11nParamsResp, respBuf);
			*respLen = WFA_TLV_HDR_LEN + sizeof(dutCmdResponse_t);
			return FALSE;
		}
	}

	v11nParamsResp->status = STATUS_COMPLETE;
	wfaEncodeTLV(WFA_STA_SET_11N_RESP_TLV, 4, (BYTE *)v11nParamsResp, respBuf);
	*respLen = WFA_TLV_HDR_LEN + 4;
	return TRUE;
}
#endif
/*
 * wfaStaAddArpTableEntry(): 
 */
int wfaStaAddArpTableEntry(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaAddARPTableEntry_t *staAddARPTableEntry= (caStaAddARPTableEntry_t *)caCmdBuf;
   
	DPRINT_INFO(WFA_OUT, "\n Entry wfastaAddARPTableEntry... ");
	// Implement the function and this does not return any thing back.
    memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_add_arp_table_entry(sigma_dut_ptr(), staAddARPTableEntry, &infoResp) < 0){        
       infoResp.status = STATUS_ERROR;  
       *respLen = 0;
        return FALSE;
    }      

   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_ADD_ARP_TABLE_ENTRY_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}

/*
 * wfaStaBlockICMPResponse(): 
 */
int wfaStaBlockICMPResponse(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf)
{
   dutCmdResponse_t infoResp;
   caStaBlockICMPResponse_t *staBlockICMPRes= (caStaBlockICMPResponse_t *)caCmdBuf;
   
	DPRINT_INFO(WFA_OUT, "\n Entry wfaStaBlockICMPResponse... ");
	// Implement the function and this does not return any thing back.
    memset(&infoResp, 0, sizeof(infoResp));
    if(cmd_sta_block_icmp_response(sigma_dut_ptr(), staBlockICMPRes, &infoResp) < 0){        
       infoResp.status = STATUS_ERROR;  
       *respLen = 0;
        return FALSE;
    }      


   infoResp.status = STATUS_COMPLETE;
   wfaEncodeTLV(WFA_STA_BLOCK_ICMP_RESPONSE_RESP_TLV, sizeof(infoResp), (BYTE *)&infoResp, respBuf);   
   *respLen = WFA_TLV_HDR_LEN + sizeof(infoResp);

   return TRUE;
}
