/*****************************************************************************
  Module: mpgformat.h  -  Defines the MPEG3waveformat class.
  Copyright (C) 1999  Andrew L. Sandoval

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/
/* Module: mpgformat.h                                                       */
/* Developer: Andrew L. Sandoval                                             */
/* Purpose: Defines MPEG3waveformat class which is used for setting          */
/* MPEGrecorder options.                                                     */
/*****************************************************************************/
#pragma warning(disable:4786)

#include <iostream>
#include <string>
#include <sstream>
#include <vector>
#include <map>
#include <windows.h>
#include <mmsystem.h>
#include <mmreg.h>

using namespace std;

MPEG1WAVEFORMAT* const createFormat(DWORD BitRate, DWORD SampleFreq, WORD layer = ACM_MPEG_LAYER3);

class MPEG3waveformat
{
private:
	const DWORD bitrate;
	const DWORD samplefrequency;
	const MPEG1WAVEFORMAT* format;
	
public:
	MPEG3waveformat() :
	  bitrate(128000),
	  samplefrequency(44100),
	  format( createFormat(bitrate, samplefrequency) ) { };

	MPEG3waveformat(DWORD Bitrate, DWORD SampleFreq = 44100, WORD layer = ACM_MPEG_LAYER3) :
	  bitrate(Bitrate),
	  samplefrequency(SampleFreq),
	  format( createFormat(bitrate, samplefrequency, layer) ) {  };

	virtual ~MPEG3waveformat();
	const WAVEFORMATEX* const waveformat() const 
		{ return reinterpret_cast<const WAVEFORMATEX* const>(format); };

private:
	MPEG3waveformat& operator=(const MPEG3waveformat &) {  };
};

WAVEFORMATEX* const createWavFormat(DWORD SampleFreq);

class NORMALwaveformat
{
private:
	const DWORD bitrate;	//Preserve for MPEG encoder
	const DWORD samplefrequency;
	const WAVEFORMATEX* format;
	
public:
	NORMALwaveformat() :
	  bitrate(128000),
	  samplefrequency(44100),
	  format( createWavFormat(samplefrequency) ) { };

	NORMALwaveformat(DWORD Bitrate, DWORD SampleFreq = 44100) :
	  bitrate(Bitrate),
	  samplefrequency(SampleFreq),
	  format( createWavFormat(samplefrequency) ) {  };

	virtual ~NORMALwaveformat();
	const WAVEFORMATEX* const waveformat() const 
		{ return (format); };

private:
	NORMALwaveformat& operator=(const NORMALwaveformat &) {  };
};

