/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StepEnum {
    VALIDATING,
    EXECUTING,
    FINALIZING,
    REBALANCING_VOLUME,
    REMOVING_BRICKS,
    UNKNOWN;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static StepEnum fromValue(String value) {
        try {
            return StepEnum.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'StepEnum' enumerated type. Valid values are: 'validating', 'executing', 'finalizing', 'rebalancing_volume', 'removing_bricks', 'unknown'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(StepEnum.class);
    }
}

