/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.FileBuilder;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.CdromContainer;
import org.ovirt.engine.sdk4.types.Cdrom;
import org.ovirt.engine.sdk4.types.File;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;

public class CdromBuilder {
    private String comment;
    private String description;
    private File file;
    private String href;
    private String id;
    private InstanceType instanceType;
    private String name;
    private Template template;
    private Vm vm;
    private List<Vm> vms;

    public CdromBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public CdromBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public CdromBuilder file(File newFile) {
        this.file = newFile;
        return this;
    }

    public CdromBuilder file(FileBuilder newFile) {
        this.file = newFile == null ? null : newFile.build();
        return this;
    }

    public CdromBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public CdromBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public CdromBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public CdromBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public CdromBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public CdromBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public CdromBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public CdromBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public CdromBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public CdromBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public CdromBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public CdromBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public Cdrom build() {
        CdromContainer container = new CdromContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.file(this.file);
        container.href(this.href);
        container.id(this.id);
        container.instanceType(this.instanceType);
        container.name(this.name);
        container.template(this.template);
        container.vm(this.vm);
        container.vms(this.vms);
        return container;
    }
}

