/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.util.List;
import org.ovirt.engine.sdk4.types.AffinityGroup;
import org.ovirt.engine.sdk4.types.AffinityRule;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Vm;

public class AffinityGroupContainer extends IdentifiedContainer implements AffinityGroup {
    private Boolean enforcing;
    private AffinityRule hostsRule;
    private Boolean positive;
    private AffinityRule vmsRule;
    private Cluster cluster;
    private List<Host> hosts;
    private List<Vm> vms;
    
    public boolean enforcing() {
        return enforcing;
    }
    
    public void enforcing(boolean newEnforcing) {
        enforcing = Boolean.valueOf(newEnforcing);
    }
    
    public void enforcing(Boolean newEnforcing) {
        enforcing = newEnforcing;
    }
    
    public boolean enforcingPresent() {
        return enforcing != null;
    }
    
    public AffinityRule hostsRule() {
        return hostsRule;
    }
    
    public void hostsRule(AffinityRule newHostsRule) {
        hostsRule = newHostsRule;
    }
    
    public boolean hostsRulePresent() {
        return hostsRule != null;
    }
    
    public boolean positive() {
        return positive;
    }
    
    public void positive(boolean newPositive) {
        positive = Boolean.valueOf(newPositive);
    }
    
    public void positive(Boolean newPositive) {
        positive = newPositive;
    }
    
    public boolean positivePresent() {
        return positive != null;
    }
    
    public AffinityRule vmsRule() {
        return vmsRule;
    }
    
    public void vmsRule(AffinityRule newVmsRule) {
        vmsRule = newVmsRule;
    }
    
    public boolean vmsRulePresent() {
        return vmsRule != null;
    }
    
    public Cluster cluster() {
        return cluster;
    }
    
    public void cluster(Cluster newCluster) {
        cluster = newCluster;
    }
    
    public boolean clusterPresent() {
        return cluster != null;
    }
    
    public List<Host> hosts() {
        return makeUnmodifiableList(hosts);
    }
    
    public void hosts(List<Host> newHosts) {
        hosts = makeArrayList(newHosts);
    }
    
    public boolean hostsPresent() {
        return hosts != null && !hosts.isEmpty();
    }
    
    public List<Vm> vms() {
        return makeUnmodifiableList(vms);
    }
    
    public void vms(List<Vm> newVms) {
        vms = makeArrayList(newVms);
    }
    
    public boolean vmsPresent() {
        return vms != null && !vms.isEmpty();
    }
    
}
