eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID2 system
# Agent name:        SpaceTmp
# Agent description: Detect if /tmp is filling up.
# Author:            Diego Zamboni
#
# History of modifications:
# 
# Known bugs:
# 
# Things to do:
# 
# Future work:
# 
# Suggestions made by people:
# 
# Generated automatically by ../bin/makeagent.pl on Tue Sep  7 23:55:57 1999.
# 
###### AUTOMATICALLY GENERATED FILE --- DO NOT EDIT ##########
#

# 10 "SpaceTmp.aas"
package SpaceTmp;

# Version number
# 13 "SpaceTmp.aas"
$VERSION=eval {do { my @r = (q$Revision: 1.6 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "Detect if /tmp is filling up.",
             CheckPeriod        => eval {undef},
# 27 "SpaceTmp.aas"
             MyThreshold => 90,
# 24 "SpaceTmp.aas"
             FiltersNeeded => {    FileSystems => [ { MountPoint => '/tmp' }, 'Check'] }
            );

# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;


use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 SpaceTmp


This agent monitors the space occupied on /tmp, and warns when it is over
the limit defined by the MyThreshold parameter. Each time the disk usage
exceeds the threshold, the status is incremented by 1, and each time it
does not, it is decremented by 1. The message contains the actual
usage percentage of the file system.

=cut

# Preamble code


# The Check function.
sub Check {
  my $self=checkref(shift);
# 30 "SpaceTmp.aas"
  my ($filter, $fh, $line)=@_;
  my $pct=(split(" ", $line))[4];
  my $status=$Params{Status};
  my $thr=$Params{MyThreshold};

  if ($pct>$thr) {
    $status++;
  }
  else {
    $status--;
  }

  $status=10 if $status>10;
  $status=0 if $status<0;

  return ($status, "$pct");
}
# Agent commands

# End of entity marker
_EndOfEntity;
