eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# Filter::FileSystems
#
# AAFID project, COAST Laboratory, CERIAS, 1998-1999.
#
# Diego Zamboni, Jan 27, 1998.
#
# $Id: FileSystems.pm,v 1.5 1999/09/08 04:45:15 zamboni Exp $
#
# NOTE: This file is in Perl's POD format. For more information, see the 
#       manual page for perlpod(1).
#

package Filter::FileSystems;

use AAFID::Filter;
use AAFID::Entity;
use vars qw(
	    @ISA
	    $VERSION
	    %PARAMETERS
	   );

@ISA=qw(AAFID::Filter);

# The following keeps up with the RCS version number. The self-assignment
# keeps the -w switch from complaining by using the variable.
$VERSION = do { my @r = (q$Revision: 1.5 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }; $VERSION = $VERSION;

# The 'Command' parameter assumes the GNU version of df.
%PARAMETERS=(
     Period => 10,
     Command => 'df -P',
     Description => 'Filesystem information filter',
     DataFields => [
		    'FileSystem',
		    'TotalK',
		    'UsedK',
		    'AvailableK',
		    'PercentageUsed',
		    'MountPoint'
		   ]
    );

=pod

This filter reports file system information as provided by the "df" command.
For now, it depends on GNU df.

=cut

sub Init_log {
  my $self=shift;
  $self->addCommandDataSource(
	      $Params{Command},
	      $Params{Period},
	      sub {
		my ($fh, $msg)=@_;
		unless ($msg=~/^Filesystem/) {
		  $self->processLine($fh, $msg);
		}
	      }
	     );
  return $self;
}

=head1 Processing lines

Done automatically by the base class mechanisms. See the C<DataFields>
parameter. We only do a little bit of postprocessing on the 
C<PercentageUsed> field.

=cut

sub makefield {
  my $self=shift;
  my $fields=$self->SUPER::makefield(@_);
  $fields->{PercentageUsed} =~ s/%$//;
  return $fields;
}

_EndOfEntity;

#
# $Log: FileSystems.pm,v $
# Revision 1.5  1999/09/08 04:45:15  zamboni
# Made Init_log return the appropriate value (undef if error, $self otherwise)
#
# Revision 1.4  1999/09/03 17:08:59  zamboni
# Changed the start line to something that is path-independent, and
# updated the copyright notice.
#
# Revision 1.3  1999/06/28 21:22:09  zamboni
# Merged with a07-port-to-linux
#
# Revision 1.2.2.2  1999/06/28 19:33:56  zamboni
# - Same version as before (which uses the new facilities available in
#   the base Filter class), but commented appropriately, as all the
#   other files in the distribution.
#
#
