eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID project, COAST Laboratory, CERIAS, 1998-1999.
#
# Susana Soriano, August 11, 1998.
#
# $Id: Fproc.pm,v 1.8 1999/09/08 04:45:15 zamboni Exp $
#
# NOTE: This file is in Perl's POD format. For more information, see the 
#       manual page for perlpod(1).
#

package Filter::Fproc;

use AAFID::Filter;
use AAFID::Entity;
use AAFID::Common;
use vars qw(
	%PARAMETERS
	@ISA
	$ps
	    );

  sub makefield;
  sub makeline;

  %PARAMETERS=( SocketPath => '/tmp/catsock',
		Period  => 2
	      );

@ISA=qw(AAFID::Filter);

# The following variables are specific of the logfile and name of
# the socket that is wanted.

=pod

This is a filter which does not use a logfile. Instead, it obtain information
about which process are running by the command "ps". This filter uses the 
basic subroutines that are defined in Filter.pm, and this filter just defines 
the specific subroutines that have to be used for itself.

=head1 Defining how can be obtained the log.

Init_log and getline are two subroutines that are defined by default
in the package Filter.pm if the log is extracted by a file; however, if
this is not the case, they have to be redefined by the user to extract the
information without any logfile.

Note: The subroutine getline must return an undef function in order to avoid
an infinite loop.
=cut

sub Init_log {
  my $self=checkref(shift);
  $ps=IO::File->new("ps -fea |") or return undef;
  Comm::Reactor::add_acceptor($ps, 
	      sub {
		my ($fh)=shift;
		my $msg=<$fh>;
		if (!defined($msg)) {
		  Comm::Reactor::remove_handle($fh);
		  $fh->close;
		  # Reawake in a little bit.
		  Comm::Reactor::add_event(time()+$self->getParameter('Period'),
					   sub {$self->Init_log});
		}
		else {
		  chomp $msg;
		  $self->processLine($fh, $msg);
		}
	      });
  return $self;
}

=head1 Getting the patterns and Selecting the information.

The agent sends patterns to the filter in order to select specific information.
The filter split the lines into fields to be more careful about what information
is choosen. In this way, the filter looks for the line on the logfile which
matches with the pattern and reconstructs it to the original format. Once
this process is done, the filter send the information in the original format
to the agent.
=cut

	
sub makefield {
        my $self=checkref(shift);
        my $line=shift;
        my @subline;
        my @substring;
	my @subpid;
	my @pid;
        @subline=split(/\s+/,$line);
	if ($subline[6] =~ /[^0-9]/) {
	    $subline[9] = $subline[8];
	    $subline[8] = $subline[7];
	    $subline[7] = $subline[6];
	    $subline[6] = '-';
	}
	
	if ($subline[7] =~ /defunct/) {
	   $subline[8] = "-";
           $subline[9] = "-";
	}		
        return {Uid	=> $subline[1],
                Pid	=> $subline[2],
                Ppid	=> $subline[3],
                C	=> $subline[4],
                Month	=> $subline[5],
		Day	=> $subline[6],
                Tty	=> $subline[7],
                Time	=> $subline[8],
                Cmd	=> $subline[9],
                }
}

sub makeline{
	my $self=checkref(shift);
        my $line=shift;
	my %line=%$line;
        return "$line{Uid} $line{Pid} $line{Ppid} $line{C} $line{Month} $line{Day} $line{Tty} $line{Time} $line{Cmd}";
        }

_EndOfEntity;

#
# $Log: Fproc.pm,v $
# Revision 1.8  1999/09/08 04:45:15  zamboni
# Made Init_log return the appropriate value (undef if error, $self otherwise)
#
# Revision 1.7  1999/09/03 17:09:00  zamboni
# Changed the start line to something that is path-independent, and
# updated the copyright notice.
#
# Revision 1.6  1999/09/03 17:02:04  zamboni
# Added the standard comment block.
#
# Revision 1.5  1999/04/01 02:46:20  zamboni
# - Made the callback that receives the output of the command not block
#   when waiting between executions of the command (it was using
#   sleep()), but instead schedule a timed event into the future using
#   Reactor time events. This allows the process to still receive input
#   from other channels, even while it is waiting.
# - Changed the PS_Period parameter to Period.
#
# Revision 1.4  1999/03/29 22:33:34  zamboni
# Merged branch a05-new-comm-module, which updates it to make use of the new event-based communication mechanism.
#
# Revision 1.3.4.1  1999/03/29 22:05:58  zamboni
# - Made it work with the new event model.
# - Added the PS_Period parameter, which controls the frequency (in
#   seconds) with which the ps command is executed.
# - Fixed miscellaneous bugs.
#
# Revision 1.3  1998/09/03 21:15:47  zamboni
# Made some fixes (change Fproc to Filter::Fproc, etc.)
#
# Revision 1.2  1998/09/03 04:15:23  zamboni
# Removed the mail header lines.
#
#
