eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# Util::NumQueue package
#
# AAFID project, COAST Laboratory, CERIAS, 1998-1999.
#
# Diego Zamboni, Jan 27, 1998.
#
# $Id: NumQueue.pm,v 1.2 1999/09/03 17:09:01 zamboni Exp $
#
# NOTE: This file is in Perl's POD format. For more information, see the 
#       manual page for perlpod(1).
#

=head1 NAME

Util::NumQueue --- Store and operate on numerical values.

=cut

package Util::NumQueue;

use strict;
use Util::FiniteQueue;
use vars qw(@ISA);

@ISA=qw(Util::FiniteQueue);

=head1 SYNOPSIS

  $t=Util::NumQueue->new;
  $t->timelength(10);  # time in seconds
  for ($i=0; $i<=10; $i++) {
    print "Current queue:   (sum=".$t->sum."; avg=".$t->avg.") ".
          $t->toString."\n";
    sleep(3);
    $t->add($i+1);
  }
  $t->reset;
  $t->maxlength(10);  # number of elements
  for ($i=0; $i<=20; $i++) {
    print "Current queue:   (sum=".$t->sum."; avg=".$t->avg.") ".
          $t->toString."\n";
    sleep(3);
    $t->add($i+1);
  }

=head1 DESCRIPTION

This is a subclass of B<Util::FiniteQueue> that has special methods for
operating on numeric values.

=head1 METHODS

All the methods from B<Util::FiniteQueue> plus the following.

=over 4

=item avg()

Returns the average of the values currently in the queue, after updating it.

=cut

sub avg {
  my $self=shift;
  $self->update;
  $self->{CurAvg}=0.0;
  $self->visit(sub {
		 my ($self, $elem, $pos)=@_;
		 $self->{CurAvg}+=$elem;
	       });
  if ($self->length) {
    $self->{CurAvg}/=$self->length;
  }
  return $self->{CurAvg};
}

=item sum()

Returns the sum of the values currently in the queue, after updating it.

=cut 

sub sum {
  my $self=shift;
  $self->update;
  $self->{CurSum}=0.0;
  $self->visit(sub {
		 my ($self, $elem, $pos)=@_;
		 $self->{CurSum}+=$elem;
	       });
  return $self->{CurSum};
};

=back 4

=head1 AUTHOR

Diego Zamboni (zamboni@cs.purdue.edu).

=cut

1;
