/* Author: Wietse Venema <wietse@wzv.win.tue.nl> */

#include <sys/types.h>
#include <utmp.h>
#include <string.h>
#include <syslog.h>

/* utmp_init - update utmp and wtmp before login */

utmp_init(line, user, tag)
char   *line;
char   *user;
char   *tag;
{
    struct utmp utx;

    memset((char *) &utx, 0, sizeof(utx));
    strncpy(utx.ut_user, user, sizeof(utx.ut_user));
    strncpy(utx.ut_line, line, sizeof(utx.ut_line));
    utx.ut_pid = getpid();
    utx.ut_type = LOGIN_PROCESS;
    utx.ut_id[0] = tag[0];
    utx.ut_id[1] = tag[1];
    strncpy(utx.ut_id + 2, line + strlen(line) - 2, 2);
    time(&(utx.ut_time));
    pututline(&utx);
    updwtmp(WTMP_FILE, &utx);
    endutent();
    return (0);
}
