/*
     tcplogger - A TCP traffic logger
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

pktfilt.c - 03/20/93

*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#ifdef SUNOS4
#include <net/nit_pf.h>
#include <net/packetfilt.h>
#endif

#ifdef SOLARIS
#include <sys/pfmod.h>
#endif

#include <netinet/in.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/if_ether.h>
#include <sys/stropts.h>
#include <netdb.h>

#define offsetof(T, m) ((size_t)&(((T *)0)->m))

/*
  Rename some of the packet filter operators so that
   the names reflect what they actually do
*/

/* Short circuit if equal and keep packet */
#define ENF_CEQ ENF_COR
/* Short circuit if not equal and keep packet */
#define ENF_CNE ENF_CNAND
/* Short circuit if equal and reject packet */
#define ENF_CREQ ENF_NOR
/* Short circuit if not equal and reject packet */
#define ENF_CRNE ENF_CAND

void
pushfilter(int fd)
{
     struct packetfilt pf;
#ifdef SOLARIS
     struct strioctl ioc;
#endif
     u_short *ptr;
     struct servent *se;

     pf.Pf_Priority = 0;
     memset(pf.Pf_Filter, 0, sizeof(pf.Pf_Filter));

     ptr = pf.Pf_Filter;
#ifdef SUNOS4
     *ptr++ = ENF_PUSHWORD + 6;
     *ptr++ = ENF_PUSHLIT|ENF_CRNE;
     *ptr++ = htons(ETHERTYPE_IP);
#endif
     *ptr++ = ENF_PUSHWORD + 11;
#ifdef SUNOS4
     *ptr++ = ENF_PUSHLIT|ENF_AND;
     *ptr++ = 0xff;
#endif

#ifdef SOLARIS
     *ptr++ = ENF_PUSH00FF|ENF_AND;
#endif
     *ptr++ = ENF_PUSHLIT|ENF_CRNE;
     *ptr++ = 1;
     *ptr++ = ENF_PUSHWORD + 23;

     pf.Pf_FilterLen = ptr - &pf.Pf_Filter[0];

#ifdef SUNOS4
     if(ioctl(fd, NIOCSETF, &pf) == -1)
	  perror("pf setf");
#endif

#ifdef SOLARIS
     ioc.ic_cmd = PFIOCSETF;
     ioc.ic_timout = -1;
     ioc.ic_len = sizeof(struct packetfilt);
     ioc.ic_dp = (char *)&pf;
     if(ioctl(fd, I_STR, &ioc) == -1)
	  perror("pfmod setf");
#endif
}
