/*

  sshserverprobe.h

  Authors:
        Timo J. Rinne <tri@ssh.fi>

  Copyright (C) 1999 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

*/

#ifndef SSHSERVERPROBE_H
#define SSHSERVERPROBE_H 1

#include "sshoperation.h"

typedef void (*SshServerProbeCB)(const char *address,
                                 const char *port,
                                 const char *version,
                                 void *context);

/* Send a server probe datragram to the broadcast address defined by
   the caller.  Call probe_cb with address, port and version string of
   each server that replied.  If udp datagram cannot be sent at all,
   callback may be called immediately with NULL address, port and
   version.  In this case returned handle is null and no further
   callbacks are called.  In normal operation, valid operation handle
   is returned and operation can be aborted with ssh_operation_abort.
   When timeout is exceeded, the callback is called with arguments
   (NULL, NULL, NULL, context).  After this operation handle is
   invalid. */
SshOperationHandle ssh_server_probe(const char *broadcast_address,
                                    long timeout_sec,
                                    long timeout_usec,
                                    SshServerProbeCB probe_cb,
                                    void *context);

#endif /* SSHSERVERPROBE_H */
/* eof (sshserverprobe.h) */
