/*

  sshoperation.h

  Author: Tero Kivinen <kivinen@ssh.fi>
          Timo J. Rinne <tri@ssh.fi>

  Copyright (c) 1999 SSH Communications Security
                     All rights reserved

  Generic asynchronous call interface.  Registering, aborting and finishing
  asynchronous calls.

*/

/*
 * $Id: sshoperation.h,v 1.1 1999/10/20 17:30:09 huima Exp $
 * $Log: sshoperation.h,v $
 * $EndLog$
 */

#ifndef SSHOPERATION_H
#define SSHOPERATION_H

/* Abort callback type. This callback is called when the asyncronous operations
   is aborted to stop the real operation. After this callback returns the
   asyncronous operation is not allowed to call any callbacks associated to the
   asyncronous operation. It should also either free all the data structures
   associated to it immediately, or postpone their freeing for the later time.
   */
typedef void (*SshOperationAbortCB)(void *operation_context);

/* Asyncronous return handler returned by the sshoperation code. This handle
   should be returned to the caller of the function that starts the asyncronous
   operation so the caller can store it, and call the ssh_operation_abort
   function later. */
typedef struct SshOperationHandleRec *SshOperationHandle;


/* Interface which is used inside the functions that implement the asyncronous
   operations. */

/* Register started asynchronous call and corresponding abort callback. This
   call is called by the function that starts the real operation, and the
   handle must be returned to the caller of the function, so it can then abort
   the operation using the ssh_operation_abort. */
SshOperationHandle ssh_operation_register(SshOperationAbortCB abort_cb,
                                          void *operation_context);

/* Unregister the handle. The abort callback will not be called, and the handle
   is invalid after this (i.e any other part of the code must not call
   ssh_operation_abort using the handle). */
void ssh_operation_unregister(SshOperationHandle handle);

/* Return operation context pointer from the given operation handle. */
void *ssh_operation_get_context(SshOperationHandle handle);


/* Interface which is used by the functions which gets the SshOperationHandles
   from the other functions */

/* Call abort callback of the pending asynchronous call. The abort callback
   will then abort the operation if it is possible, and free the context
   associated to it. Note, after this call then, the handle is invalid, and no
   other calls can be made using it. The abort callback will also make sure
   that no other callbacks are called associated with this asynchronous call.
   */
void ssh_operation_abort(SshOperationHandle handle);

#endif /* SSHOPERATION_H */
/* eof (sshoperation.h) */
