/*

  auth-pam-common.c

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Common functions for client and server for PAM (Pluggable
  Authentication Modules) authentication.
  
*/

#include "sshincludes.h"
#include "sshmsgs.h"

#define SSH_DEBUG_MODULE "Ssh2AuthPAMCommon"

#if defined(DAEMON_WITH_PAM) || defined(CLIENT_WITH_PAM)
#ifdef DAEMON_WITH_PAM
#include <security/pam_appl.h>

/* Map a msg_style identifier to valid ssh protocol msg_style
   identifier. Argument must be a valid PAM msg_style identifier. */
unsigned int ssh_pam_msg_style_to_ssh(int msg_style)
{
  switch (msg_style)
    {
    case PAM_PROMPT_ECHO_OFF:
      return SSH_PAM_PROMPT_ECHO_OFF;
    case PAM_PROMPT_ECHO_ON:
      return SSH_PAM_PROMPT_ECHO_ON;
    case PAM_ERROR_MSG:
      return SSH_PAM_ERROR_MSG;
    case PAM_TEXT_INFO:
      return SSH_PAM_TEXT_INFO;
#ifdef PAM_BINARY_PROMPT
    case PAM_BINARY_PROMPT:
      return SSH_PAM_BINARY_PROMPT;
#endif /* PAM_BINARY_PROMPT */
#ifdef PAM_BINARY_MSG
    case PAM_BINARY_MSG:
      return SSH_PAM_BINARY_MSG;
#endif /* PAM_BINARY_MSG */
    default:
      ssh_fatal("ssh_pam_msg_style_to_ssh: invalid msg_style identifier.");
    }
  SSH_NOTREACHED;
  return 0; /* keep gcc happy. */
}
#endif /* DAEMON_WITH_PAM */
/* Map a ssh style resp_retcode identifier to valid PAM resp_retcode
   identifier. Returns TRUE if a valid mapping is found, FALSE
   otherwise. */
Boolean ssh_pam_resp_retcode_to_pam(unsigned int ssh_resp_retcode,
                                    int *pam_resp_retcode)
{
  switch (ssh_resp_retcode)
    {
    case SSH_PAM_DEFAULT_RESP_RETCODE:
      *pam_resp_retcode = 0;
      break;
    default:
      return FALSE;
    }
  return TRUE;
}
#endif /* DAEMON_WITH_PAM || CLIENT_WITH_PAM */
