/*
  
  authc-securid.h

  Author: Graeme Ahokas <gahokas@ssh.com>

  Copyright (C) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  SecurID authentication, client side.
  
*/

#ifndef AUTHC_SECURID_H
#define AUTHC_SECURID_H

#ifdef SSH_CLIENT_WITH_SECURID
/* SecurID authentication, client-side. */

void ssh_client_auth_securid(SshAuthClientOperation op,
                            const char *user,
                            unsigned int packet_type,
                            SshBuffer packet_in,
                            const unsigned char *session_id,
                            size_t session_id_len,
                            void **state_placeholder,
                            SshAuthClientCompletionProc completion,
                            void *completion_context,
                            void *method_context);

#endif /* SSH_CLIENT_WITH_SECURID */
#endif /* AUTHC_SECURID_H */

