/*

  sftp_server.c

  Authors:
        Tatu Ylonen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  File server that is executed by sshd.

*/

#include "ssh2includes.h"
#include "ssheloop.h"
#include "sshfdstream.h"
#include "sshfilexfer.h"
#include "sshsignals.h"

#define SSH_DEBUG_MODULE "SshSftpServer"

#ifdef HAVE_LIBWRAP
int allow_severity = SSH_LOG_INFORMATIONAL;
int deny_severity = SSH_LOG_WARNING;
#endif /* HAVE_LIBWRAP */

int main(void)
{
  SshFileServer server;

  ssh_event_loop_initialize();
  ssh_signals_prevent_core(TRUE, NULL);
  /* XXX Free server. */
  server = ssh_file_server_wrap(ssh_stream_fd_stdio());
  ssh_event_loop_run();
  ssh_signals_reset();
  ssh_event_loop_uninitialize();

  return 0;
}
