/*
  sshfc_conn_states.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1999-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Connection handling for SshFileCopy. States used by SshFileCopyConn.
 */
/* Include this into a state array. */

#ifdef SSH_FSM_PROTOTYPES
#define SSH_FSM_DECL(x,y,z) SSH_FSM_STEP(z);
#else
#define SSH_FSM_DECL SSH_FSM_STATE
#endif /* SSH_FSM_PROTOTYPES */

SSH_FSM_DECL("fcc_establish_connection", "Establish connection",        \
             ssh_fc_conn_establish)

SSH_FSM_DECL("fcc_close_connection",            \
             "Close connection",                \
             ssh_fc_conn_close)

SSH_FSM_DECL("fcc_abort",                       \
             "Abort operation, close threads",  \
             ssh_fc_abort)

SSH_FSM_DECL("fcc_suspend",                     \
             "Suspend",                         \
             ssh_fc_suspend)

SSH_FSM_DECL("fcc_connection_failed",           \
             "Connection failed",               \
             ssh_fc_conn_failed)

SSH_FSM_DECL("fcc_connection_ready",            \
             "Connection succeeded",            \
             ssh_fc_conn_ready)

#undef SSH_FSM_PROTOTYPES
#undef SSH_FSM_DECL
