/*

  sshadt_map.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999, 2000 SSH Communications Security, Finland
  All rights reserved.

  Created Tue Sep 14 09:26:13 1999.

  */

#ifndef SSH_ADT_MAP_H_INCLUDED
#define SSH_ADT_MAP_H_INCLUDED

extern const SshADTContainerType ssh_adt_map_type;

#define SSH_ADT_MAP (ssh_adt_map_type)


/**************************************************** Interface I: low level */
  
/* Set the mapped image of `object_to_be_mapped'. */
void ssh_adt_map_set_map(SshADTContainer map,
                         SshADTHandle object_to_be_mapped,
                         void *image);

/* Map the object `object_to_be_mapped' and return the result. */
void *ssh_adt_map_map(SshADTContainer map,
                      SshADTHandle object_to_be_mapped);

/* Tell the mapping object that the object at `object_with_changed_contents'
   has been changed [and that its hash value should be recomputed]. */
Boolean ssh_adt_map_changed(SshADTContainer map,
                            SshADTHandle object_with_changed_contents);


/********************************************* Interface II: more convenient */

/* add a new element (using ssh_adt_duplicate or ssh_adt_put,
   depending on memory allocation mode).  fails if key exists. */
SshADTHandle ssh_adt_xmap_add(SshADTContainer c, void *key, void *value);

/* remove an element (call to ssh_adt_delete).  if key does exist,
   remove simply does nothing.  does nothing if key does not exist. */
void ssh_adt_xmap_remove(SshADTContainer c, void *key);

/* modify existing element.  fails if key does not exist. */
void ssh_adt_xmap_set(SshADTContainer c, void *key, void *value);

/* look up existing element.  returns NULL if key does not exist. */
void *ssh_adt_xmap_get(SshADTContainer c, void *key);

/* existencial predicate. */
Boolean ssh_adt_xmap_exists(SshADTContainer c, void *key);


#endif /* SSH_ADT_MAP_H_INCLUDED */
