/*

  t-eventloop.c 

Author: Vesa Suontama <vsuontam@ssh.fi>

Copyright (c) 2000 SSH Communications Security Corp, Helsinki, Finland
                   All rights reserved
                   

  Created Thu Sep 21 10:24:48 2000. 

*/

#include "sshincludes.h"
#include "ssheloop.h"
#include "sshtimeouts.h"

void another_callback(void *ctx)
{
  fprintf(stderr, "Another callback\n");
  ssh_event_loop_abort();
}

void signal_callback(int sig_num, void *context)
{
  fprintf(stderr, "The signal %d invoked\n", sig_num);
  ssh_register_signal(SIGUSR1, signal_callback, NULL);
}

void program_entry(void *context)
{
  int argc = (int)context;
  fprintf(stderr, "The number of arguments given to the program is %d\n",
          argc);
  ssh_register_signal(SIGUSR1, signal_callback, NULL);
  ssh_register_signal(SIGINT, signal_callback, NULL);
  ssh_register_timeout(2, 00000, another_callback, NULL);

}

int main(int argc, char **argv)
{
  
  ssh_event_loop_initialize();
  ssh_register_timeout(2, 0, program_entry, (void *)argc);
  ssh_event_loop_run();
  ssh_event_loop_uninitialize();
  return 0;
}
