/*

  auth-pam-common.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Common functions for client and server for PAM (Pluggable
  Authentication Modules) authentication.
  
*/

#ifndef _AUTH_PAM_COMMON_H
#define _AUTH_PAM_COMMON_H

#if defined(DAEMON_WITH_PAM) || defined(CLIENT_WITH_PAM)

/* Map a msg_style identifier to valid ssh protocol msg_style
   identifier. Argument must be a valid PAM msg_style identifier. */
unsigned int ssh_pam_msg_style_to_ssh(int msg_style);

/* Map a ssh style resp_retcode identifier to valid PAM resp_retcode
   identifier. Returns TRUE if a valid mapping is found, FALSE
   otherwise. */
Boolean ssh_pam_resp_retcode_to_pam(unsigned int ssh_resp_retcode,
                                    int *pam_resp_retcode);

#endif /* DAEMON_WITH_PAM || CLIENT_WITH_PAM */

#endif /* _AUTH_PAM_COMMON_H */
