/*

  sftppager.h

  Author: Tomi Salo <ttsalo@ssh.com>

  Copyright (c) 1999, 2001 SSH Communications Security, Finland
  All rights reserved.

  Created Wed Jan 19 15:37:52 2000.

  Paging for Sftp2.

  */

#ifndef SFTPPAGER_H
#define SFTPPAGER_H

#include "sshincludes.h"
#include "sshstream.h"
#include "ssholdfsmstreams.h"
#include "ssholdfsm.h"

#define SSH_OLDFSM_PROTOTYPES
#include "sftppager_states.h"

typedef struct SshSftpPagerCtxRec *SshSftpPagerCtx;

typedef enum
{
  /* Directory change was successful */
  SSH_SFTP_PAGER_OK,
  /* Directory change was not successful */
  SSH_SFTP_PAGER_ERROR
} SshSftpPagerResult;

/* Initializes the pager module. Requires the SshStream for
   input/output. NOTE: You CANNOT use the sshreadline module
   when the pager module is active, unless you are using them
   on different streams. */
SshSftpPagerCtx
ssh_sftp_pager_init(SshStream stream, SshOldFSM fsm,
                    unsigned int screen_width,
                    unsigned int screen_height);

typedef void (*SshSftpPagerCb)(SshSftpPagerResult result,
                               void *context);

/* Uninitializes the pager module and destroys the context.
   Calls the callback when finished. */
void
ssh_sftp_pager_uninit(SshSftpPagerCtx pager_ctx,
                      SshSftpPagerCb cb, void *user_context);

/* Writes one string. See also the next function */
void
ssh_sftp_pager_write_string(SshSftpPagerCtx pager_ctx,
                            const char *line);

/* After calling the above function, you MUST call this function to
   wake the pager up. Also, this HAS to be called from a step
   function. */
void
ssh_sftp_pager_wakeup(SshSftpPagerCtx pager_ctx, SshOldFSMThread thread);

/* Changes the current screen size */
void
ssh_sftp_pager_change_screen_size(SshSftpPagerCtx pager_ctx,
                                  unsigned int screen_width,
                                  unsigned int screen_height);

#endif /* SFTPPAGER_H */
