/*

  ssh1bufferstream.h

  Author:
        Timo J. Rinne <tri@ssh.com>

  Copyright (C) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Stream object with which write never blocks.

*/

#ifndef SSH1BUFFERSTREAM_H
#define SSH1BUFFERSTREAM_H 1

#include "sshstream.h"

typedef void (*Ssh1BufferStreamFlushedCallback)(Boolean ok,
                                                void *context);

SshStream ssh1_buffer_stream_wrap(SshStream stream);
void ssh1_buffer_stream_wait_flush(SshStream stream,
                                   Ssh1BufferStreamFlushedCallback callback,
                                   void *context);

#endif /* ! SSH1BUFFERSTREAM_H */
