/*

  ssh1proto.c

  Author:
        Timo J. Rinne <tri@ssh.com>

  Copyright (C) 1999-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Ssh1 protocol implementation.

*/

#ifndef SSH1PROTO_H
#define SSH1PROTO_H 1

#include "ssh2includes.h"

#include "sshclient.h"
#include "sshappcommon.h"
#include "sshstream.h"
#include "sshoperation.h"
#include "sshtrans.h"

typedef void (*Ssh1DestroyCallback)(SshUInt32 exitval, void *context);



/* Wraps the stream with the ssh1 protocol object.  Stream is not to
   be touched by the other implementation any more.  Version string is
   a string sent by the remote server.  According to this string, the
   caller has determined that there is needed for ssh1 protocol.
   Client data is the ssh2 client object containing the client
   configuration.  Command is the command string sent to the remote
   end or NULL for shell connection.  Destroy callback is called after
   the ssh1 protocol connection is disconnected and protocol context
   and stream is destroyed.  Before this call a wrapped stream is
   destroyed and all callbacks that possibly has been set by the ssh1
   protocol are cancelled.

*/
SshOperationHandle ssh1_stream_wrap(SshStream stream,
                                    const char *remote_version_string,
                                    SshClient client,
                                    Ssh1DestroyCallback destroy_callback,
                                    void *destroy_context);




















































/* Returns statistics from SSH1 transport layer. */
void ssh1_get_statistics(SshOperationHandle handle,
                         SshTransportStatistics statistics_return);


#endif /* ! SSH1PROTO_H */
