/*
  sshfc_transferi.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Internal declarations common to SshFCTransfer and SshFCTransferCore.
*/

#ifndef SSHFC_TRANSFERI_H
#define SSHFC_TRANSFERI_H

#include "sshbuffer.h"
#include "sshtimemeasure.h"
#include "sshdllist.h"
#include "ssholdfsm.h"
#include "sshoperation.h"
#include "sshadt_list.h"

#define SSH_OLDFSM_PROTOTYPES
#include "sshfc_trcore_states.h"
#define SSH_OLDFSM_PROTOTYPES
#include "sshfc_trcheck_states.h"

#define SSH_FCT_CONN_ERROR_STATE "fct_conn_error"
#define CURRENT_STATE_HOLDER gdata->current_state
#define SRC FALSE,gdata->source_conn_flags

#define SSH_FCT_CHECK_DEST_CONN                                         \
do                                                                      \
{                                                                       \
  tdata->dealing_with_source = FALSE;                                   \
  SSH_FC_CHECK_CONN(gdata->dest_conn_flags, SSH_FCT_CONN_ERROR_STATE);  \
} while(0)

#define SSH_FCT_CHECK_SRC_CONN                                           \
do                                                                       \
{                                                                        \
  tdata->dealing_with_source = TRUE;                                     \
  SSH_FC_CHECK_CONN(gdata->source_conn_flags, SSH_FCT_CONN_ERROR_STATE); \
} while(0)

typedef struct SshFileCopyTransferContextRec
{
  /* Source connection. */
  SshFileCopyConnection source;
  /* Source location. */
  SshDlList file_list;
  /* Destination connection. */
  SshFileCopyConnection destination;
  /* Destination location. (single file. Must be directory, if
     multiple files are transferred. */
  SshFileCopyLocation dest_location;
  /* Transfer attributes. */
  SshFileCopyTransferAttrs attrs;

  /* Callback (and context for it), with which success or failure
     messages are returned to the application. */
  SshFileCopyTransferReadyCallback completion_callback;
  SshFileCopyTransferErrorCallback error_callback;
  SshFileCopyTransferProgressCallback progress_callback;
  SshFileCopyTransferAbortNotifyCallback abort_notify_cb;

  void *callback_context;

  SshOldFSM fsm;
  SshOldFSMThread main_thread;

  SshOldFSMCondition in_blocking;
  SshOldFSMCondition out_blocking;
  SshOldFSMThread reader;
  SshOldFSMThread writer;

  /* ASCII/binary mode stuff. */
  SshUInt64 byte_difference;
  unsigned char *dest_newline;
  unsigned char *source_newline;
  SshFileCopyTransferMode transfer_mode;
  unsigned char *ascii_extensions;

  /* Connection handling. */
  SshOldFSMThread source_conn_thread;
  SshOldFSMThread dest_conn_thread;
  SshOldFSMCondition source_conn_waiting;
  SshOldFSMCondition dest_conn_waiting;
  SshOldFSMCondition conn_failed;
  SshUInt8 source_conn_flags;
  SshUInt8 dest_conn_flags;

  /* Timer for single transfers . */
  SshTimeMeasure transfer_timer;
  /* Timer for the whole transfer operation. */
  SshTimeMeasure total_transfer_timer;

  /* Which attributes can be safely set with setstat and fsetstat,
     without getting redundant error messages, which only serve to
     confuse the user. This is ATTR_FLAGS_DEADBEEF, if the flags
     haven't been tested yet. */
  unsigned int attributes_flags;
  char *after_check_state;
  char *current_state;
  unsigned int checking_flag;

  /* Buffers used in transfer. */
  SshADTContainer buf_queue;
  /* Number of buffers in queue. */
  size_t num_bufs;

  /* Operation handle for an SshFileClient operation outside
     sshfc_trcore (that module has an internal way of storing the
     operation handle. */
  SshOperationHandle operation_handle;

  Boolean received_eof;
} *SshFileCopyTransferContext;

typedef struct TransferThreadContextRec
{
  /* Source connection. */
  SshFileCopyConnection source;
  SshFileCopyFile source_file;
  SshFileCopyFile source_dir;
  char *source_file_name;

  SshFileCopyFile current_dest_file;

  SshFileCopyFileListItem current_item;
  SshFileCopyLocation current_location;

  /* Thread pointers. */
  SshOldFSMThread parent;
  SshOldFSMThread child;

  unsigned long original_permissions;
  Boolean already_existed;

  /* Whether we are currently interested in the source or the
     destination file (during stat or remove etc.). TRUE if yes, FALSE
     otherwise. */
  Boolean dealing_with_source;

  /* Helper variable, when dealing with directories. (contains a state
     name) */
  char *after_lstat_src_dir_state;

  /* Operation handle for the ssh_file_client_* operations, so that we
     can abort them, if we get aborted. */
  SshOperationHandle op_handle;

} *TransferThreadContext;

void transfer_thread_destructor(void *tdata);
void progress_timeout_cb(void *context);

#endif /* SSHFC_TRANSFERI_H */
