/*
  sshfc_trcheck_states.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  States used by SshFCTransferCheck.
*/
/* Include this into a state array. */
#ifdef SSH_OLDFSM_PROTOTYPES
#define SSH_FSM_DECL(x,y,z) SSH_OLDFSM_STEP(z);
#else
#define SSH_FSM_DECL SSH_OLDFSM_STATE
#endif /* SSH_OLDFSM_PROTOTYPES */

SSH_FSM_DECL("fct_check_setstat_flags",
             "Check which attributes can be changed with setstat",
             transfer_check_setstat_flags)

SSH_FSM_DECL("fct_check_setstat_stat_source",
             "Stat source file",
             transfer_check_setstat_stat_source)

SSH_FSM_DECL("fct_check_setstat_flags_size",
             "Can size be changed with setstat",
             transfer_check_setstat_flags_size)

SSH_FSM_DECL("fct_check_setstat_flags_uidgid",
             "Can uid and gid be changed with setstat",
             transfer_check_setstat_flags_uidgid)

SSH_FSM_DECL("fct_check_setstat_flags_permissions",
             "Can permissions be changed with setstat",
             transfer_check_setstat_flags_permissions)

SSH_FSM_DECL("fct_check_setstat_flags_acmodtime",
             "Can access and modification times be changed with setstat",
             transfer_check_setstat_flags_acmodtime)

SSH_FSM_DECL("fct_check_setstat_flags_done",
             "Check done",
             transfer_check_setstat_flags_done)

#undef SSH_OLDFSM_PROTOTYPES
#undef SSH_FSM_DECL
