/*
  sshfc_trcore_states.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  States used by SshFCTransferCore.
 */
/* Include this into a state array. */

#ifdef SSH_OLDFSM_PROTOTYPES
#define SSH_FSM_DECL(x,y,z) SSH_OLDFSM_STEP(z);
#else
#define SSH_FSM_DECL SSH_OLDFSM_STATE
#endif /* SSH_OLDFSM_PROTOTYPES */

SSH_FSM_DECL("fctc_start_transfer",                             \
             "Prepare everything for the actual transfer",      \
             transfer_start)

SSH_FSM_DECL("fctc_shred",                      \
             "Shred file to requests",          \
             transfer_shred)

SSH_FSM_DECL("fctc_read_in",                    \
             "Try to read file",                \
             transfer_read_in)

SSH_FSM_DECL("fctc_write_out",                  \
             "Try to write data to file",       \
             transfer_write_out)

SSH_FSM_DECL("fctc_wake_parent_and_finish",             \
             "Wake parent and finish thread",           \
             transfer_core_wake_parent_and_finish)

SSH_FSM_DECL("fctc_readwrite_error",                            \
             "Un-recoverable error during actual transfer",     \
             transfer_readwrite_error)

#undef SSH_OLDFSM_PROTOTYPES
#undef SSH_FSM_DECL
