/*

  sshhostkeyio.h

  Author: Tomi Salo <ttsalo@ssh.fi>

  Copyright (c) 2001 SSH Communications Security, Finland
  All rights reserved.

  Created Fri Feb 23 21:07:27 2001.

  Functions and data structures for handling multiple host keys.

  */

#ifndef SSHHOSTKEYIO_H_INCLUDED
#define SSHHOSTKEYIO_H_INCLUDED

#include "ssh2includes.h"
#include "sshconfig.h"

/* Informs the manager that no more keys will be specified. If no
   valid keypairs have yet been specified, the system default
   locations will be used to insert one keypair into the list of
   keypairs. After this the keyfiles will be read in. If `user' is
   non-NULL, the keys will be read using that user's
   privileges. Otherwise, default privileges will be used. If no keys
   can be successfully read, the function returns FALSE.  Otherwise it
   returns TRUE. */
Boolean
ssh_host_key_read_keys(SshHostKeysContext ctx,
                       SshConfig config,
                       SshUser user,
                       Boolean read_private_keys,
                       Boolean dont_use_user_dir);

#endif /* SSHHOSTKEYIO_H_INCLUDED */

